/**
 * $Id: StorageAliasableWriteable.java 3443 2009-02-06 15:38:18Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageAliasableWriteable.java $
 * StorageMovable.java - DS2 - Feb 6, 2009 10:54:41 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

/**
 * Allows storage entities to be aliased (symlinked) to other locations in the storage tree,
 * like filesystems the permissions are based on the original location <br/>
 * For example: trees/apple/golden_delicious could be aliased as trees/fruit/golden_delicious <br/>
 * All aliases should be removed automatically if a storage entity is deleted <br/>
 * One of the mixins for the storage service
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface StorageAliasableWriteable extends StorageWriteable, StorageAliasable {

    /**
     * Adds a new alias for the given storage reference
     * 
     * @param reference the unique reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @param aliasReference the alias for this reference, same structure as a normal reference
     * @return true if the alias was created, false if the alias already exists
     * @throws IllegalArgumentException if any of the arguments are null or invalid
     * @throws StorageInvalidReferenceException if the given reference does not exist or cannot be aliased
     * @throws StorageInvalidPathException if there is already something at the alias location reference
     */
    public boolean addAlias(String reference, String aliasReference);

    /**
     * This removes the given alias by its reference
     * 
     * @param reference the unique alias reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @return true if the alias was found and removed OR false if the alias was not found
     * @throws IllegalArgumentException if any of the arguments are null or invalid
     * @throws StorageInvalidReferenceException if the given reference is not an alias
     */
    public boolean removeAlias(String aliasReference);

}
