/**
 * $Id: StorageCopyable.java 3443 2009-02-06 15:38:18Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageCopyable.java $
 * StorageMovable.java - DS2 - Feb 6, 2009 10:54:41 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import org.dspace.services.exceptions.StorageWriteException;

/**
 * Allows storage entities to be copied (will also optionally copy all children in the tree as well) <br/>
 * One of the mixins for the storage service
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface StorageCopyable extends StorageWriteable {

    /**
     * Copy a storage entity (and optionally all children) to a new location,
     * this will be an actual copy and all information is duplicated
     * (e.g. copying plants/apple to the path trees/fruit would yield trees/fruit/apple)
     * 
     * @param reference the unique reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @param path the path to copy this item to (e.g. trees/fruit)
     * @param recursive if true then copy all children as well, if false only copy this entity and properties
     * @param newName (optional) the new name for this storage entity OR null to use the existing name
     * @return the new reference to the base copied storage entity
     * @throws IllegalArgumentException if any of the required arguments are null or invalid
     * @throws StorageInvalidReferenceException if the given reference does not exist
     * @throws StorageInvalidPathException if the path does not exist or there is already something with the name/newName at this path
     * @throws StorageWriteException if the copy operation fails internally in the storage system
     */
    public String copyEntity(String reference, String path, boolean recursive, String newName);

}
