/**
 * $Id: StorageWriteable.java 3476 2009-02-12 16:37:41Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageWriteable.java $
 * StorageWriteable.java - DS2 - Feb 6, 2009 3:22:57 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import org.dspace.services.StorageService;
import org.dspace.services.exceptions.StorageWriteException;
import org.dspace.services.model.StorageEntity;


/**
 * Allows for writing into the system storage,
 * all mixins which include writing will extend this one
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface StorageWriteable extends StorageService {

    /**
     * Create a new storage entity given the information in the storage entity object,
     * if the given path does not exist yet then it will be created,
     * if the path 
     * 
     * @param storageEntity a storage entity object
     * @throws IllegalArgumentException if the storageEntity is invalid
     * @throws StorageWriteException if the storageEntity cannot be saved
     */
    public void createEntity(StorageEntity storageEntity);

    /**
     * Updates the properties on an entity if and only if it already exists, 
     * NOTE: changing the path or name is not possible here and this will not create the entity
     * 
     * @param storageEntity an existing storage entity object
     * @throws IllegalArgumentException if the storageEntity is invalid
     * @throws StorageWriteException if the storageEntity cannot be saved
     */
    public void updateEntity(StorageEntity storageEntity);

    /**
     * Delete an entity from the storage system, this will also remove all children entities
     * so proper care should be taken before calling this method
     * 
     * @param reference the unique reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @return true if the storage entity was found and deleted, false if it was not found
     * @throws IllegalArgumentException if the reference is null
     * @throws StorageWriteException if the storageEntity cannot be removed
     */
    public boolean deleteEntity(String reference);

}
