/**
 * $Id: EvidencePassword.java 3308 2008-11-19 20:16:31Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/model/EvidencePassword.java $
 * EvidencePassword.java - DSpace2 - Oct 13, 2008 11:14:41 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.model;


/**
 * This is evidence provided in the typical way,
 * user entered username and password
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class EvidencePassword implements Evidence {

    private String userEid;
    private String password;
    private UserEidType userEidType = UserEidType.USERNAME;

    /* (non-Javadoc)
     * @see java.security.Principal#getName()
     */
    public String getName() {
        return userEid;
    }

    /*
     * (non-Javadoc)
     * @see org.dspace.services.model.Evidence#getUserEid()
     */
    public String getUserEid() {
        return userEid;
    }

    public EvidencePassword(String userEid, String password) {
        this.password = password;
        this.userEid = userEid;
    }

    public EvidencePassword(String userEid, String password, UserEidType userEidType) {
        this.password = password;
        this.userEid = userEid;
        this.userEidType = userEidType;
    }

    public UserEidType getUserEidType() {
        return userEidType;
    }

    public void setUserEidType(UserEidType userEidType) {
        this.userEidType = userEidType;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUserEid(String userEid) {
        this.userEid = userEid;
    }

    @Override
    public String toString() {
    	return userEid+"("+userEidType+"):"+encode(password);
    }

    // Have to put this here since java still has no built in encoding... lame -AZ
    private static final String baseTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    /**
     * SHA1 encode a string
     * @param str any string
     * @return the encoded string
     */
    private static String encode(String str) {
    	if (str == null || "".equals(str)) return "";
    	byte[] bytes = str.getBytes();
        StringBuilder tmp = new StringBuilder();
        int i = 0;
        byte pos;
        for (i = 0; i < bytes.length - bytes.length % 3; i += 3) {
            pos = (byte) (bytes[i] >> 2 & 63);
            tmp.append( baseTable.charAt( pos ) );
            pos = (byte) (((bytes[i] & 3) << 4) + (bytes[i + 1] >> 4 & 15));
            tmp.append( baseTable.charAt( pos ) );
            pos = (byte) (((bytes[i + 1] & 15) << 2) + (bytes[i + 2] >> 6 & 3));
            tmp.append( baseTable.charAt( pos ) );
            pos = (byte) (bytes[i + 2] & 63);
            tmp.append( baseTable.charAt( pos ) );
            // Add a new line for each 76 chars.
            // 76*3/4 = 57
            if ((i + 2) % 56 == 0) {
                tmp.append( "\r\n" );
            }
        }
        if (bytes.length % 3 != 0) {
            if (bytes.length % 3 == 2) {
                pos = (byte) (bytes[i] >> 2 & 63);
                tmp.append( baseTable.charAt( pos ) );
                pos = (byte) (((bytes[i] & 3) << 4) + (bytes[i + 1] >> 4 & 15));
                tmp.append( baseTable.charAt( pos ) );
                pos = (byte) ((bytes[i + 1] & 15) << 2);
                tmp.append( baseTable.charAt( pos ) );
                tmp.append( "=" );
            } else if (bytes.length % 3 == 1) {
                pos = (byte) (bytes[i] >> 2 & 63);
                tmp.append( baseTable.charAt( pos ) );
                pos = (byte) ((bytes[i] & 3) << 4);
                tmp.append( baseTable.charAt( pos ) );
                tmp.append( "==" );
            }
        }
        return tmp.toString();
    }
}
