/**
 * $Id: StorageProperty.java 3757 2009-04-30 09:29:45Z benbosman $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/model/StorageProperty.java $
 * StorageProperty.java - DS2 - Feb 2, 2009 10:44:37 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 *
 * A copy of the Apache License has been included in this
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.model;

import java.io.InputStream;


/**
 * This represents the properties on a storage item
 *
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class StorageProperty {
    public final static String RELATION_PREFIX = "relation::";

    protected String name;
    protected Object value;
    protected Class<?> type;
//    protected MetadataField metadataField;


    @Deprecated
    public StorageProperty(String name, String value) {
        this(name, value, String.class);
    }

    @Deprecated
    public StorageProperty(String name, long value) {
        this(name, value, Long.class);
    }

    public StorageProperty(String name, InputStream value) {
        this(name, value, InputStream.class);
    }

    public StorageProperty(String name, Object value, Class<?> type) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name.trim();
        this.value = value;
        if (type == null) {
            type = String.class;
        }
        this.type = type;
    }

    public StorageProperty(String name, StorageEntity storageEntity){
        this(RELATION_PREFIX + name, storageEntity.getId(), String.class);
    }

    public StorageProperty(MetadataField metadataField, String value) {
//        this.metadataField = metadataField;
        this.value = value;
        this.name = metadataField.toString();
    }

    public boolean isRelation(){
        return getName() != null && name.startsWith(RELATION_PREFIX);
    }

    public String getStringValue() {
        return (value == null ? null : value.toString());
    }

    public String getName() {
        return name;
    }
    public Class<?> getType() {
        return type;
    }
    public Object getValue() {
        return value;
    }
}
