/*
 * $URL: $
 * 
 * $Revision: $
 * 
 * $Date: $
 *
 * Copyright (c) 2008, The DSpace Foundation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the DSpace Foundation nor the names of its 
 * contributors may be used to endorse or promote products derived from 
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
package org.dspace.services.model.metadata;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * A DSP describes the structure of a Description Set by using the notions of
 * "templates" and "constraints". A template describes the possible metadata
 * structures in a conforming record.
 * 
 * There are two levels of templates in a Description Set Profile:
 * 
 * Description templates, that contains the statement templates that apply to a
 * single kind of description as well as constraints on the described resource.
 * 
 * Statement templates, that contains all the constraints on the property, value
 * strings, vocabulary encoding schemes, etc. that apply to a single kind of
 * statement.
 * 
 * While templates are used to express structures, constraints are used to limit
 * those structures.
 *
 * More can be found out about the DescriptionSet and the DCAM itself at:
 * 
 * http://dublincore.org/documents/abstract-model/
 * http://dublincore.org/documents/dc-dsp/
 * 
 * @author mdiggory
 *
 */
public class DescriptionSetTemplate
{

    private List<DescriptionTemplate> descriptionTemplate;

    /**
     * A DescriptionSetTemplate is a set of Description Templates
     * 
     * @return DescriptionTemplates
     */
    public List<DescriptionTemplate> getDescriptionTemplate()
    {
        if (descriptionTemplate == null)
        {
            descriptionTemplate = new ArrayList<DescriptionTemplate>();
        }
        return this.descriptionTemplate;
    }

}
