/*
 * $URL: $
 * 
 * $Revision: $
 * 
 * $Date: $
 *
 * Copyright (c) 2008, The DSpace Foundation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the DSpace Foundation nor the names of its 
 * contributors may be used to endorse or promote products derived from 
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
package org.dspace.services.model.metadata;

import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author mdiggory
 *
 */
public class NonLiteralConstraint {

    protected List<String> valueClass;

    protected Occurrence valueURIOccurrence;

    protected List<String> valueURI;

    protected Occurrence vocabularyEncodingSchemeOccurrence;

    protected List<String> vocabularyEncodingSchemeURI;

    protected List<ValueStringConstraint> valueStringConstraint;

    protected Object descriptionTemplateRef;

    /**
     * 
     * @return Value Class
     */
    public List<String> getValueClass() {
        if (valueClass == null) {
            valueClass = new ArrayList<String>();
        }
        return this.valueClass;
    }

    /**
     * 
     * @return Value URI Occurance
     */
    public Occurrence getValueURIOccurrence() {
        return valueURIOccurrence;
    }

    /**
     * 
     * @param value
     */
    public void setValueURIOccurrence(Occurrence value) {
        this.valueURIOccurrence = value;
    }

    /**
     * 
     * @return Value URI
     */
    public List<String> getValueURI() {
        if (valueURI == null) {
            valueURI = new ArrayList<String>();
        }
        return this.valueURI;
    }

    /**
     * 
     * @return Vocabulary Encoding Scheme Occurance
     */
    public Occurrence getVocabularyEncodingSchemeOccurrence() {
        return vocabularyEncodingSchemeOccurrence;
    }

    /**
     * 
     * @param value
     */
    public void setVocabularyEncodingSchemeOccurrence(Occurrence value) {
        this.vocabularyEncodingSchemeOccurrence = value;
    }

    /**
     * 
     * @return Vocabulary Encoding Scheme URI
     */
    public List<String> getVocabularyEncodingSchemeURI() {
        if (vocabularyEncodingSchemeURI == null) {
            vocabularyEncodingSchemeURI = new ArrayList<String>();
        }
        return this.vocabularyEncodingSchemeURI;
    }

    /**
     * 
     * @return Value String Constraint
     */
    public List<ValueStringConstraint> getValueStringConstraint() {
        if (valueStringConstraint == null) {
            valueStringConstraint = new ArrayList<ValueStringConstraint>();
        }
        return this.valueStringConstraint;
    }

    /**
     * 
     * @return Description Template Ref
     */
    public Object getDescriptionTemplateRef() {
        return descriptionTemplateRef;
    }

    /**
     * 
     * @param value
     */
    public void setDescriptionTemplateRef(Object value) {
        this.descriptionTemplateRef = value;
    }

}