/*
 * $URL: $
 * 
 * $Revision: $
 * 
 * $Date: $
 *
 * Copyright (c) 2008, The DSpace Foundation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the DSpace Foundation nor the names of its 
 * contributors may be used to endorse or promote products derived from 
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
package org.dspace.services.model.metadata;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * @author mdiggory
 *
 */
/**
 * @author mdiggory
 *
 */
/**
 * @author mdiggory
 *
 */
/**
 * @author mdiggory
 *
 */
public class StatementTemplate {


    protected List<String> property;

    protected String subPropertyOf;

    protected NonLiteralConstraint nonLiteralConstraint;

    protected LiteralConstraint literalConstraint;

    protected String id;

    protected String type;

    protected BigInteger maxOccurs;

    protected BigInteger minOccurs;

    /**
     * @return properties
     */
    public List<String> getProperty() {
        if (property == null) {
            property = new ArrayList<String>();
        }
        return this.property;
    }

    /**
     * 
     * @return subPropertyOf
     */
    public String getSubPropertyOf() {
        return subPropertyOf;
    }

    /**
     * 
     * @param value
     */
    public void setSubPropertyOf(String value) {
        this.subPropertyOf = value;
    }

    /**
     * 
     * @return Non Literal Constraint
     */
    public NonLiteralConstraint getNonLiteralConstraint() {
        return nonLiteralConstraint;
    }

    /**
     * 
     * @param value
     */
    public void setNonLiteralConstraint(NonLiteralConstraint value) {
        this.nonLiteralConstraint = value;
    }

    /**
     * 
     * @return Literal Constraint Type
     */
    public LiteralConstraint getLiteralConstraint() {
        return literalConstraint;
    }

    /**
     * 
     * @param value
     */
    public void setLiteralConstraint(LiteralConstraint value) {
        this.literalConstraint = value;
    }

    /**
     * 
     * @return ID
     */
    public String getID() {
        return id;
    }

    /**
     * 
     * @param value
     */
    public void setID(String value) {
        this.id = value;
    }

    /**
     * 
     * @return Type
     */
    public String getType() {
        return type;
    }

    /**
     * 
     * @param value
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * 
     * @return Max Occurance
     */
    public BigInteger getMaxOccurs() {
        return maxOccurs;
    }

    /**
     * 
     * @param value
     */
    public void setMaxOccurs(BigInteger value) {
        this.maxOccurs = value;
    }

    /**
     * 
     * @return Min Occurance
     */
    public BigInteger getMinOccurs() {
        return minOccurs;
    }
    
    /**
     * 
     * @param value
     */
    public void setMinOccurs(BigInteger value) {
        this.minOccurs = value;
    }

}