/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DSpaceCSVTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(DSpaceCSVTest.class);

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testDSpaceCSV() {
        try {
            String[] csv = new String[]{"id,collection,\"dc.title[en]\",dc.contributor.author,dc.description.abstract", "1,2,Easy line,\"Lewis, Stuart\",A nice short abstract", "2,2,Two authors,\"Lewis, Stuart||Bloggs, Joe\",Two people wrote this item", "3,2,Three authors,\"Lewis, Stuart||Bloggs, Joe||Loaf, Meat\",Three people wrote this item", "4,2,\"Two line\ntitle\",\"Lewis, Stuart\",abstract", "5,2,\"\"\"Embedded quotes\"\" here\",\"Lewis, Stuart\",\"Abstract with\ntwo\nnew lines\"", "6,2,\"\"\"Unbalanced embedded\"\" quotes\"\" here\",\"Lewis, Stuart\",\"Abstract with\ntwo\nnew lines\""};
            String filename = "test.csv";
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String csvLine : csv) {
                out.write(csvLine + "\n");
            }
            out.flush();
            out.close();
            Context c = new Context();
            DSpaceCSV dcsv = new DSpaceCSV(new File(filename), c);
            String[] lines = dcsv.getCSVLinesAsStringArray();
            Assert.assertThat((String)"testDSpaceCSV Good CSV", (Object)lines.length, (Matcher)CoreMatchers.equalTo((Object)7));
            List csvLines = dcsv.getCSVLines();
            DSpaceCSVLine line = (DSpaceCSVLine)csvLines.get(5);
            ArrayList<String> value = new ArrayList<String>();
            value.add("Abstract with\ntwo\nnew lines");
            Assert.assertThat((String)"testDSpaceCSV New lines", (Object)line.valueToCSV(value), (Matcher)CoreMatchers.equalTo((Object)"\"Abstract with\ntwo\nnew lines\""));
            csv[0] = "id,collection,\"dc.title[en]\",dc.contributor.foobar[en-US],dc.description.abstract";
            filename = "test.csv";
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String csvLine : csv) {
                out.write(csvLine + "\n");
            }
            out.flush();
            out.close();
            try {
                dcsv = new DSpaceCSV(new File(filename), c);
                lines = dcsv.getCSVLinesAsStringArray();
                Assert.fail((String)"An exception should have been thrown due to bad CSV");
            }
            catch (Exception e) {
                Assert.assertThat((String)"testDSpaceCSV Bad heading CSV", (Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Unknown metadata element in row 4: dc.contributor.foobar"));
            }
            lines = dcsv.getCSVLinesAsStringArray();
            Assert.assertThat((String)"testDSpaceCSV Good CSV", (Object)lines.length, (Matcher)CoreMatchers.equalTo((Object)7));
            csv[0] = "id,collection,\"dcdc.title[en]\",dc.contributor[en-US],dc.description.abstract";
            filename = "test.csv";
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            for (String csvLine : csv) {
                out.write(csvLine + "\n");
            }
            out.flush();
            out.close();
            try {
                dcsv = new DSpaceCSV(new File(filename), c);
                lines = dcsv.getCSVLinesAsStringArray();
                Assert.fail((String)"An exception should have been thrown due to bad CSV");
            }
            catch (Exception e) {
                Assert.assertThat((String)"testDSpaceCSV Bad heading CSV", (Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Unknown metadata schema in row 3: dcdc.title"));
            }
            File toDelete = new File(filename);
            toDelete.delete();
        }
        catch (Exception ex) {
            log.error((Object)"IO Error while creating test CSV file", (Throwable)ex);
            Assert.fail((String)"IO Error while creating test CSV file");
        }
    }
}

