/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import org.dspace.AbstractUnitTest;
import org.dspace.authenticate.IPMatcher;
import org.dspace.authenticate.IPMatcherException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IPMatcherTest
extends AbstractUnitTest {
    private static final String IP6_FULL_ADDRESS1 = "2001:18e8:3:171:218:8bff:fe2a:56a4";
    private static final String IP6_FULL_ADDRESS2 = "2001:18e8:3:171:218:8bff:fe2a:56a3";
    private static final String IP6_MASKED_ADDRESS = "2001:18e8:3::/48";
    private static IPMatcher ip6FullMatcher;
    private static IPMatcher ip6MaskedMatcher;

    @BeforeClass
    public static void setUp() throws IPMatcherException {
        ip6FullMatcher = new IPMatcher(IP6_FULL_ADDRESS1);
        ip6MaskedMatcher = new IPMatcher(IP6_MASKED_ADDRESS);
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6Incomplete() throws IPMatcherException {
        new IPMatcher("1234:5");
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6MaskOutOfRange() throws IPMatcherException {
        new IPMatcher("123::456/999");
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6MaskNotNumeric() throws IPMatcherException {
        new IPMatcher("123::456/abc");
    }

    @Test(expected=IPMatcherException.class)
    public void testIPMatcherIp6TooManySlashes() throws IPMatcherException {
        new IPMatcher("123::456/12/12");
    }

    @Test
    public void testIp6FullMatch() throws IPMatcherException {
        Assert.assertTrue((String)"IPv6 full match fails", (boolean)ip6FullMatcher.match(IP6_FULL_ADDRESS1));
    }

    @Test
    public void testIp6MisMatch() throws IPMatcherException {
        Assert.assertFalse((String)"IPv6 full nonmatch succeeds", (boolean)ip6FullMatcher.match(IP6_FULL_ADDRESS2));
    }

    @Test
    public void testIp6MaskedMatch() throws IPMatcherException {
        Assert.assertTrue((String)"IPv6 masked match fails", (boolean)ip6MaskedMatcher.match(IP6_FULL_ADDRESS2));
    }

    @AfterClass
    public static void cleanup() {
        ip6FullMatcher = null;
        ip6MaskedMatcher = null;
    }
}

