/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.BitstreamFormat;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitstreamFormatTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(BitstreamFormatTest.class);
    private BitstreamFormat bf;
    private BitstreamFormat bunknown;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.bf = BitstreamFormat.find((Context)this.context, (int)5);
            this.bunknown = BitstreamFormat.findUnknown((Context)this.context);
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.bf = null;
        this.bunknown = null;
        super.destroy();
    }

    @Test
    public void testFind() throws SQLException {
        BitstreamFormat found = BitstreamFormat.find((Context)this.context, (int)1);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"Unknown"));
        found = BitstreamFormat.find((Context)this.context, (int)2);
        Assert.assertThat((String)"testFind 2", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 3", (Object)found.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"License"));
        Assert.assertTrue((String)"testFind 4", (boolean)found.isInternal());
    }

    @Test
    public void testFindByMIMEType() throws SQLException {
        BitstreamFormat found = BitstreamFormat.findByMIMEType((Context)this.context, (String)"text/plain");
        Assert.assertThat((String)"testFindByMIMEType 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByMIMEType 1", (Object)found.getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"text/plain"));
        Assert.assertFalse((String)"testFindByMIMEType 2", (boolean)found.isInternal());
        found = BitstreamFormat.findByMIMEType((Context)this.context, (String)"text/xml");
        Assert.assertThat((String)"testFindByMIMEType 3", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByMIMEType 4", (Object)found.getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"text/xml"));
        Assert.assertFalse((String)"testFindByMIMEType 5", (boolean)found.isInternal());
    }

    @Test
    public void testFindByShortDescription() throws SQLException {
        BitstreamFormat found = BitstreamFormat.findByShortDescription((Context)this.context, (String)"Adobe PDF");
        Assert.assertThat((String)"testFindByShortDescription 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByShortDescription 1", (Object)found.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"Adobe PDF"));
        Assert.assertFalse((String)"testFindByShortDescription 2", (boolean)found.isInternal());
        found = BitstreamFormat.findByShortDescription((Context)this.context, (String)"XML");
        Assert.assertThat((String)"testFindByShortDescription 3", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByShortDescription 4", (Object)found.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"XML"));
        Assert.assertFalse((String)"testFindByShortDescription 5", (boolean)found.isInternal());
    }

    @Test
    public void testFindUnknown() throws SQLException {
        BitstreamFormat found = BitstreamFormat.findUnknown((Context)this.context);
        Assert.assertThat((String)"testFindUnknown 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindUnknown 1", (Object)found.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"Unknown"));
        Assert.assertFalse((String)"testFindUnknown 2", (boolean)found.isInternal());
        Assert.assertThat((String)"testFindUnknown 3", (Object)found.getSupportLevel(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testFindAll() throws SQLException {
        BitstreamFormat[] found = BitstreamFormat.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindAll 1", (Object)found[0].getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"Unknown"));
        Assert.assertFalse((String)"testFindAll 2", (boolean)found[0].isInternal());
        Assert.assertThat((String)"testFindAll 3", (Object)found[0].getSupportLevel(), (Matcher)CoreMatchers.equalTo((Object)0));
        boolean added = false;
        for (BitstreamFormat bsf : found) {
            if (!bsf.equals(this.bf)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 4", (boolean)added);
    }

    @Test
    public void testFindNonInternal() throws SQLException {
        BitstreamFormat[] found = BitstreamFormat.findNonInternal((Context)this.context);
        Assert.assertThat((String)"testFindNonInternal 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        int i = 0;
        for (BitstreamFormat b : found) {
            Assert.assertFalse((String)("testFindNonInternal " + ++i + " (" + b.getShortDescription() + ")"), (boolean)b.isInternal());
        }
    }

    @Test
    public void testCreateAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        BitstreamFormat found = BitstreamFormat.create((Context)this.context);
        Assert.assertThat((String)"testCreate 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)found.getDescription(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testCreate 2", (Object)found.getMIMEType(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testCreate 3", (Object)found.getSupportLevel(), (Matcher)CoreMatchers.equalTo((Object)-1));
        Assert.assertFalse((String)"testCreate 4", (boolean)found.isInternal());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNotAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = false;
            }
        };
        BitstreamFormat found = BitstreamFormat.create((Context)this.context);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.bf.getID() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testGetID 1", (this.bunknown.getID() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetShortDescription() {
        Assert.assertThat((String)"getShortDescription 0", (Object)this.bf.getShortDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"getShortDescription 1", (Object)this.bf.getShortDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"getShortDescription 2", (Object)this.bf.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)"XML"));
    }

    @Test
    public void testSetShortDescription() throws SQLException {
        String desc = "short";
        this.bf.setShortDescription(desc);
        Assert.assertThat((String)"testSetShortDescription 0", (Object)this.bf.getShortDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetShortDescription 1", (Object)this.bf.getShortDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetShortDescription 2", (Object)this.bf.getShortDescription(), (Matcher)CoreMatchers.equalTo((Object)desc));
    }

    @Test
    public void testGetDescription() {
        Assert.assertThat((String)"getDescription 0", (Object)this.bf.getDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"getDescription 1", (Object)this.bf.getDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"getDescription 2", (Object)this.bf.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"Extensible Markup Language"));
    }

    @Test
    public void testSetDescription() {
        String desc = "long description stored here";
        this.bf.setDescription(desc);
        Assert.assertThat((String)"testSetDescription 0", (Object)this.bf.getDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetDescription 1", (Object)this.bf.getDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetDescription 2", (Object)this.bf.getDescription(), (Matcher)CoreMatchers.equalTo((Object)desc));
    }

    @Test
    public void testGetMIMEType() {
        Assert.assertThat((String)"testGetMIMEType 0", (Object)this.bf.getMIMEType(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetMIMEType 1", (Object)this.bf.getMIMEType(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testGetMIMEType 2", (Object)this.bf.getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"text/xml"));
    }

    @Test
    public void testSetMIMEType() {
        String mime = "text/plain";
        this.bf.setMIMEType(mime);
        Assert.assertThat((String)"testSetMIMEType 0", (Object)this.bf.getMIMEType(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetMIMEType 1", (Object)this.bf.getMIMEType(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetMIMEType 2", (Object)this.bf.getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)mime));
    }

    @Test
    public void testGetSupportLevel() throws SQLException {
        Assert.assertTrue((String)"testGetSupportLevel 0", (this.bf.getSupportLevel() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testGetSupportLevel 1", (this.bf.getSupportLevel() <= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testGetSupportLevel 2", (this.bunknown.getSupportLevel() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testGetSupportLevel 3", (this.bunknown.getSupportLevel() <= 2 ? 1 : 0) != 0);
        BitstreamFormat[] found = BitstreamFormat.findAll((Context)this.context);
        int i = 0;
        for (BitstreamFormat b : found) {
            Assert.assertTrue((String)("testGetSupportLevel " + ++i + " (" + b.getMIMEType() + ")"), (b.getSupportLevel() >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)("testGetSupportLevel " + ++i + " (" + b.getMIMEType() + ")"), (b.getSupportLevel() <= 2 ? 1 : 0) != 0);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSupportLevelInvalidValue() {
        this.bf.setSupportLevel(5);
        Assert.fail((String)"Exception should be thrown");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSupportLevelNegativeValue() {
        this.bf.setSupportLevel(-1);
        Assert.fail((String)"Exception should be thrown");
    }

    @Test
    public void testSetSupportLevelValidValues() {
        this.bf.setSupportLevel(0);
        Assert.assertThat((String)"testSetSupportLevelValidValues 0", (Object)this.bf.getSupportLevel(), (Matcher)CoreMatchers.equalTo((Object)0));
        this.bf.setSupportLevel(1);
        Assert.assertThat((String)"testSetSupportLevelValidValues 1", (Object)this.bf.getSupportLevel(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.bf.setSupportLevel(2);
        Assert.assertThat((String)"testSetSupportLevelValidValues 2", (Object)this.bf.getSupportLevel(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testGetSupportLevelIDValid() {
        int id1 = BitstreamFormat.getSupportLevelID((String)"UNKNOWN");
        Assert.assertThat((String)"testGetSupportLevelIDValid 0", (Object)id1, (Matcher)CoreMatchers.equalTo((Object)0));
        int id2 = BitstreamFormat.getSupportLevelID((String)"KNOWN");
        Assert.assertThat((String)"testGetSupportLevelIDValid 1", (Object)id2, (Matcher)CoreMatchers.equalTo((Object)1));
        int id3 = BitstreamFormat.getSupportLevelID((String)"SUPPORTED");
        Assert.assertThat((String)"testGetSupportLevelIDValid 2", (Object)id3, (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void testGetSupportLevelIDInvalid() {
        int id1 = BitstreamFormat.getSupportLevelID((String)"IAmNotAValidSupportLevel");
        Assert.assertThat((String)"testGetSupportLevelIDInvalid 0", (Object)id1, (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testIsInternal() throws SQLException {
        Assert.assertThat((String)"testIsInternal 0", (Object)this.bf.isInternal(), (Matcher)CoreMatchers.equalTo((Object)false));
        BitstreamFormat found = BitstreamFormat.findByShortDescription((Context)this.context, (String)"License");
        Assert.assertThat((String)"testIsInternal 1", (Object)found.isInternal(), (Matcher)CoreMatchers.equalTo((Object)true));
        found = BitstreamFormat.findByShortDescription((Context)this.context, (String)"CC License");
        Assert.assertThat((String)"testIsInternal 2", (Object)found.isInternal(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"testIsInternal 3", (Object)this.bunknown.isInternal(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testSetInternal() {
        Assert.assertFalse((String)"testSetInternal 0", (boolean)this.bf.isInternal());
        this.bf.setInternal(true);
        Assert.assertThat((String)"testSetInternal 1", (Object)this.bf.isInternal(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNotAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = false;
            }
        };
        this.bf.update();
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testUpdateAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        String desc = "Test description";
        this.bf.setDescription(desc);
        this.bf.update();
        BitstreamFormat b = BitstreamFormat.find((Context)this.context, (int)5);
        Assert.assertThat((String)"testUpdateAdmin 0", (Object)b.getDescription(), (Matcher)CoreMatchers.equalTo((Object)desc));
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNotAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = false;
            }
        };
        this.bf.delete();
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testDeleteAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            BitstreamFormat unknown;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        this.bf.delete();
        BitstreamFormat b = BitstreamFormat.find((Context)this.context, (int)5);
        Assert.assertThat((String)"testDeleteAdmin 0", (Object)b, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeleteUnknown() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        this.bunknown.delete();
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testGetExtensions() {
        Assert.assertThat((String)"testGetExtensions 0", (Object)this.bf.getExtensions(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetExtensions 1", (this.bf.getExtensions().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetExtensions 2", (Object)this.bf.getExtensions()[0], (Matcher)CoreMatchers.equalTo((Object)"xml"));
    }

    @Test
    public void setExtensions(String[] exts) {
        Assert.assertThat((String)"setExtensions 0", (Object)this.bf.getExtensions()[0], (Matcher)CoreMatchers.equalTo((Object)"xml"));
        this.bf.setExtensions(new String[]{"1", "2", "3"});
        Assert.assertThat((String)"setExtensions 1", (Object)this.bf.getExtensions(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"setExtensions 2", (this.bf.getExtensions().length == 3 ? 1 : 0) != 0);
        Assert.assertThat((String)"setExtensions 3", (Object)this.bf.getExtensions()[0], (Matcher)CoreMatchers.equalTo((Object)"1"));
        Assert.assertThat((String)"setExtensions 4", (Object)this.bf.getExtensions()[1], (Matcher)CoreMatchers.equalTo((Object)"2"));
        Assert.assertThat((String)"setExtensions 5", (Object)this.bf.getExtensions()[2], (Matcher)CoreMatchers.equalTo((Object)"3"));
        this.bf.setExtensions(new String[0]);
        Assert.assertThat((String)"setExtensions 6", (Object)this.bf.getExtensions(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"setExtensions 7", (this.bf.getExtensions().length == 0 ? 1 : 0) != 0);
    }
}

