/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitstreamTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(BitstreamTest.class);
    private Bitstream bs;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            File f = new File(testProps.get("test.bitstream").toString());
            this.bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
            this.dspaceObject = this.bs;
            this.context.commit();
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.bs = null;
        super.destroy();
    }

    @Test
    public void testBSFind() throws SQLException {
        int id = 1;
        Bitstream found = Bitstream.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testBSFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testBSFind 1", (Object)found.getFormat().getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"application/octet-stream"));
        Assert.assertThat((String)"testBSFind 2", (Object)found.getName(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testBSFind 3", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testFindAll() throws SQLException {
        Bitstream[] found = Bitstream.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (found.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Bitstream b : found) {
            if (!b.equals(this.bs)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testCreate() throws IOException, SQLException {
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream created = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testCreate 0", (Object)created.getFormat().getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"application/octet-stream"));
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRegister() throws IOException, SQLException {
        int assetstore = 0;
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream registered = Bitstream.register((Context)this.context, (int)assetstore, (String)f.getName());
        Assert.assertThat((String)"testRegister 0", (Object)registered.getFormat().getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"application/octet-stream"));
        Assert.assertThat((String)"testRegister 1", (Object)registered.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.bs.getID() >= 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertThat((String)"testGetHandle 0", (Object)this.bs.getHandle(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetSequenceID() {
        Assert.assertThat((String)"testGetSequenceID 0", (Object)this.bs.getSequenceID(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testSetSequenceID() {
        int val = 2;
        this.bs.setSequenceID(val);
        Assert.assertThat((String)"testSetSequenceID 0", (Object)this.bs.getSequenceID(), (Matcher)CoreMatchers.equalTo((Object)val));
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.bs.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetName() {
        String name = "new name";
        this.bs.setName(name);
        Assert.assertThat((String)"testGetName 0", (Object)this.bs.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetName 1", (Object)this.bs.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testGetName 2", (Object)this.bs.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetSource() {
        Assert.assertThat((String)"testGetSource 0", (Object)this.bs.getSource(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetSource() {
        String source = "new source";
        this.bs.setSource(source);
        Assert.assertThat((String)"testSetSource 0", (Object)this.bs.getSource(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetSource 1", (Object)this.bs.getSource(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetSource 2", (Object)this.bs.getSource(), (Matcher)CoreMatchers.equalTo((Object)source));
    }

    @Test
    public void testGetDescription() {
        Assert.assertThat((String)"testGetDescription 0", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetDescription() {
        String description = "new description";
        this.bs.setDescription(description);
        Assert.assertThat((String)"testSetDescription 0", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetDescription 1", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetDescription 2", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
    }

    @Test
    public void testGetChecksum() {
        String checksum = "75a060bf6eb63fd0aad88b7d757728d3";
        Assert.assertThat((String)"testGetChecksum 0", (Object)this.bs.getChecksum(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetChecksum 1", (Object)this.bs.getChecksum(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testGetChecksum 2", (Object)this.bs.getChecksum(), (Matcher)CoreMatchers.equalTo((Object)checksum));
    }

    @Test
    public void testGetChecksumAlgorithm() {
        String alg = "MD5";
        Assert.assertThat((String)"testGetChecksumAlgorithm 0", (Object)this.bs.getChecksumAlgorithm(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetChecksumAlgorithm 1", (Object)this.bs.getChecksumAlgorithm(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testGetChecksumAlgorithm 2", (Object)this.bs.getChecksumAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)alg));
    }

    @Test
    public void testGetSize() {
        long size = 238413L;
        Assert.assertThat((String)"testGetSize 0", (Object)this.bs.getSize(), (Matcher)CoreMatchers.equalTo((Object)size));
    }

    @Test
    public void testSetUserFormatDescription() throws SQLException {
        String userdescription = "user format description";
        this.bs.setUserFormatDescription(userdescription);
        Assert.assertThat((String)"testSetUserFormatDescription 0", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetUserFormatDescription 1", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetUserFormatDescription 2", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.equalTo((Object)userdescription));
    }

    @Test
    public void testGetUserFormatDescription() {
        Assert.assertThat((String)"testGetUserFormatDescription 0", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetFormatDescription() {
        String format = "Unknown";
        Assert.assertThat((String)"testGetFormatDescription 0", (Object)this.bs.getFormatDescription(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetFormatDescription 1", (Object)this.bs.getFormatDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testGetFormatDescription 2", (Object)this.bs.getFormatDescription(), (Matcher)CoreMatchers.equalTo((Object)format));
    }

    @Test
    public void testGetFormat() throws SQLException {
        Assert.assertThat((String)"testGetFormat 0", (Object)this.bs.getFormat(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetFormat 1", (Object)this.bs.getFormat(), (Matcher)CoreMatchers.equalTo((Object)BitstreamFormat.findUnknown((Context)this.context)));
    }

    @Test
    public void testSetFormat() throws SQLException {
        int id = 3;
        BitstreamFormat format = BitstreamFormat.find((Context)this.context, (int)id);
        this.bs.setFormat(format);
        Assert.assertThat((String)"testSetFormat 0", (Object)this.bs.getFormat(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetFormat 1", (Object)this.bs.getFormat(), (Matcher)CoreMatchers.equalTo((Object)BitstreamFormat.find((Context)this.context, (int)id)));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNotAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bitstream)any), (int)1);
                result = new AuthorizeException();
            }
        };
        this.bs.update();
    }

    @Test
    public void testUpdateAdmin() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bitstream)any), (int)1);
                result = null;
            }
        };
        this.bs.update();
    }

    @Test
    public void testDelete() throws SQLException, AuthorizeException {
        this.bs.delete();
        Assert.assertTrue((String)"testDelete 0", (boolean)this.bs.isDeleted());
    }

    @Test
    public void testIsDeleted() throws SQLException, AuthorizeException {
        Assert.assertFalse((String)"testIsDeleted 0", (boolean)this.bs.isDeleted());
        this.bs.delete();
        Assert.assertTrue((String)"testIsDeleted 1", (boolean)this.bs.isDeleted());
    }

    @Test
    public void testRetrieveCanRead() throws IOException, SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bitstream)any), (int)0);
                result = null;
            }
        };
        Assert.assertThat((String)"testRetrieveCanRead 0", (Object)this.bs.retrieve(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRetrieveNoRead() throws IOException, SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bitstream)any), (int)0);
                result = new AuthorizeException();
            }
        };
        Assert.assertThat((String)"testRetrieveNoRead 0", (Object)this.bs.retrieve(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetBundles() throws SQLException {
        Assert.assertThat((String)"testGetBundles 0", (Object)this.bs.getBundles(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles 1", (this.bs.getBundles().length == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.bs.getType(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testIsRegisteredBitstream() {
        Assert.assertThat((String)"testIsRegisteredBitstream 0", (Object)this.bs.isRegisteredBitstream(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testGetStoreNumber() {
        Assert.assertTrue((String)"testGetStoreNumber 0", (this.bs.getStoreNumber() == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        Assert.assertThat((String)"testGetParentObject 0", (Object)this.bs.getParentObject(), (Matcher)CoreMatchers.nullValue());
    }
}

