/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BundleTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(BundleTest.class);
    private Bundle b;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.b = Bundle.create((Context)this.context);
            this.dspaceObject = this.b;
            this.context.commit();
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.b = null;
        super.destroy();
    }

    @Test
    public void testBundleFind() throws SQLException {
        int id = this.b.getID();
        Bundle found = Bundle.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testBundleFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testBundleFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testCreate() throws SQLException {
        Bundle created = Bundle.create((Context)this.context);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreate 1", (created.getID() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"testCreate 2", (created.getBitstreams().length == 0 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 3", (Object)created.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.b.getID() >= 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.b.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetName() {
        String name = "new name";
        this.b.setName(name);
        Assert.assertThat((String)"testSetName 0", (Object)this.b.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetName 1", (Object)this.b.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetName 2", (Object)this.b.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetPrimaryBitstreamID() {
        Assert.assertThat((String)"testGetPrimaryBitstreamID 0", (Object)this.b.getPrimaryBitstreamID(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testSetPrimaryBitstreamID() {
        int id = 1;
        this.b.setPrimaryBitstreamID(id);
        Assert.assertThat((String)"testSetPrimaryBitstreamID 0", (Object)this.b.getPrimaryBitstreamID(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testUnsetPrimaryBitstreamID() {
        int id = 6;
        this.b.setPrimaryBitstreamID(id);
        this.b.unsetPrimaryBitstreamID();
        Assert.assertThat((String)"testUnsetPrimaryBitstreamID 0", (Object)this.b.getPrimaryBitstreamID(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertThat((String)"testGetHandle 0", (Object)this.b.getHandle(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetBitstreamByName() throws FileNotFoundException, SQLException, IOException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = null;
            }
        };
        String name = "name";
        Assert.assertThat((String)"testGetHandle 0", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.nullValue());
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        bs.setName(name);
        this.b.addBitstream(bs);
        Assert.assertThat((String)"testGetHandle 1", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetHandle 2", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testGetHandle 3", (Object)this.b.getBitstreamByName(name).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        this.context.commit();
    }

    @Test
    public void testGetBitstreams() throws FileNotFoundException, SQLException, IOException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = null;
            }
        };
        Assert.assertThat((String)"testGetBitstreams 0", (Object)this.b.getBitstreams(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetBitstreams 1", (Object)this.b.getBitstreams().length, (Matcher)CoreMatchers.equalTo((Object)0));
        String name = "name";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        bs.setName(name);
        this.b.addBitstream(bs);
        Assert.assertThat((String)"testGetBitstreams 2", (Object)this.b.getBitstreams(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetBitstreams 3", (Object)this.b.getBitstreams().length, (Matcher)CoreMatchers.equalTo((Object)1));
        Assert.assertThat((String)"testGetBitstreams 4", (Object)this.b.getBitstreams()[0].getName(), (Matcher)CoreMatchers.equalTo((Object)name));
        this.context.commit();
    }

    @Test
    public void testGetItems() throws SQLException {
        Assert.assertThat((String)"testGetItems 0", (Object)this.b.getItems(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetItems 1", (Object)this.b.getItems().length, (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateBitstreamNoAuth() throws FileNotFoundException, AuthorizeException, SQLException, IOException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = new AuthorizeException();
            }
        };
        String name = "name";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.b.createBitstream((InputStream)new FileInputStream(f));
        Assert.fail((String)"Exception should be thrown");
    }

    @Test
    public void testCreateBitstreamAuth() throws FileNotFoundException, AuthorizeException, SQLException, IOException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = null;
            }
        };
        String name = "name";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.b.createBitstream((InputStream)new FileInputStream(f));
        bs.setName(name);
        Assert.assertThat((String)"testCreateBitstreamAuth 0", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateBitstreamAuth 1", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testCreateBitstreamAuth 2", (Object)this.b.getBitstreamByName(name).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test(expected=AuthorizeException.class)
    public void testRegisterBitstreamNoAuth() throws AuthorizeException, IOException, SQLException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = new AuthorizeException();
            }
        };
        int assetstore = 0;
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.b.registerBitstream(assetstore, f.getAbsolutePath());
        Assert.fail((String)"Exception should be thrown");
    }

    @Test
    public void testRegisterBitstreamAuth() throws AuthorizeException, IOException, SQLException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = null;
            }
        };
        int assetstore = 0;
        String name = "name bitstream";
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = this.b.registerBitstream(assetstore, f.getName());
        bs.setName(name);
        Assert.assertThat((String)"testRegisterBitstream 0", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRegisterBitstream 1", (Object)this.b.getBitstreamByName(name), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testRegisterBitstream 2", (Object)this.b.getBitstreamByName(name).getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddBitstreamNoAuth() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = new AuthorizeException();
            }
        };
        int id = 1;
        Bitstream bs = Bitstream.find((Context)this.context, (int)id);
        this.b.addBitstream(bs);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testAddBitstreamAuth() throws SQLException, AuthorizeException, FileNotFoundException, IOException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)3);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        bs.setName("name");
        this.b.addBitstream(bs);
        Assert.assertThat((String)"testAddBitstreamAuth 0", (Object)this.b.getBitstreamByName(bs.getName()), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testAddBitstreamAuth 1", (Object)this.b.getBitstreamByName(bs.getName()), (Matcher)CoreMatchers.equalTo((Object)bs));
        Assert.assertThat((String)"testAddBitstreamAuth 2", (Object)this.b.getBitstreamByName(bs.getName()).getName(), (Matcher)CoreMatchers.equalTo((Object)bs.getName()));
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveBitstreamNoAuth() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)4);
                result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        bs.setName("name");
        this.b.removeBitstream(bs);
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testRemoveBitstreamAuth() throws SQLException, AuthorizeException, IOException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Bundle)any), (int)4);
                result = null;
            }
        };
        int id = 1;
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = Bitstream.find((Context)this.context, (int)id);
        this.b.addBitstream(bs);
        this.context.commit();
        this.b.removeBitstream(bs);
        Assert.assertThat((String)"testRemoveBitstreamAuth 0", (Object)this.b.getBitstreamByName(bs.getName()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testUpdate() throws SQLException, AuthorizeException {
        this.b.update();
    }

    @Test
    public void testDelete() throws SQLException, AuthorizeException, IOException {
        int id = this.b.getID();
        this.b.delete();
        this.context.commit();
        Assert.assertThat((String)"testDelete 0", (Object)Bundle.find((Context)this.context, (int)id), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.b.getType(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testInheritCollectionDefaultPolicies() throws AuthorizeException, SQLException {
        Collection c = Collection.create((Context)this.context);
        List newpolicies = AuthorizeManager.getPoliciesActionFilter((Context)this.context, (DSpaceObject)c, (int)9);
        for (ResourcePolicy rp : newpolicies) {
            rp.setAction(0);
        }
        this.b.inheritCollectionDefaultPolicies(c);
        List bspolicies = this.b.getBundlePolicies();
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 0", (newpolicies.size() == bspolicies.size() ? 1 : 0) != 0);
        boolean equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(bspolicies.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 1", (boolean)equals);
        bspolicies = this.b.getBitstreamPolicies();
        boolean exists = true;
        for (int i = 0; bspolicies.size() > 0 && i < newpolicies.size() && exists; ++i) {
            if (bspolicies.contains(newpolicies.get(i))) continue;
            exists = false;
        }
        Assert.assertTrue((String)"testInheritCollectionDefaultPolicies 2", (boolean)exists);
    }

    @Test
    public void testReplaceAllBitstreamPolicies() throws SQLException, AuthorizeException {
        ArrayList<ResourcePolicy> newpolicies = new ArrayList<ResourcePolicy>();
        newpolicies.add(ResourcePolicy.create((Context)this.context));
        newpolicies.add(ResourcePolicy.create((Context)this.context));
        newpolicies.add(ResourcePolicy.create((Context)this.context));
        this.b.replaceAllBitstreamPolicies(newpolicies);
        List bspolicies = this.b.getBundlePolicies();
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 0", (newpolicies.size() == bspolicies.size() ? 1 : 0) != 0);
        boolean equals = true;
        for (int i = 0; i < newpolicies.size() && equals; ++i) {
            if (newpolicies.contains(bspolicies.get(i))) continue;
            equals = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 1", (boolean)equals);
        bspolicies = this.b.getBitstreamPolicies();
        boolean exists = true;
        for (int i = 0; bspolicies.size() > 0 && i < newpolicies.size() && exists; ++i) {
            if (bspolicies.contains(newpolicies.get(i))) continue;
            exists = false;
        }
        Assert.assertTrue((String)"testReplaceAllBitstreamPolicies 2", (boolean)exists);
    }

    @Test
    public void testGetBundlePolicies() throws SQLException {
        List bspolicies = this.b.getBundlePolicies();
        Assert.assertTrue((String)"testGetBundlePolicies 0", (boolean)bspolicies.isEmpty());
    }

    @Test
    public void testGetBitstreamPolicies() throws SQLException {
        List bspolicies = this.b.getBitstreamPolicies();
        Assert.assertTrue((String)"testGetBitstreamPolicies 0", (boolean)bspolicies.isEmpty());
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)this.b.getAdminObject(4), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetAdminObject 1", (Object)this.b.getAdminObject(3), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        Assert.assertThat((String)"testGetParentObject 0", (Object)this.b.getParentObject(), (Matcher)CoreMatchers.nullValue());
    }
}

