/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CollectionTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(CollectionTest.class);
    private Collection c;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.c = Collection.create((Context)this.context);
            this.dspaceObject = this.c;
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)"Authorization Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.c = null;
        super.destroy();
    }

    @Test
    public void testCollectionFind() throws Exception {
        int id = this.c.getID();
        Collection found = Collection.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testCollectionFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCollectionFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testCollectionFind 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreate() throws Exception {
        Collection created = Collection.create((Context)this.context);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreateWithValidHandle() throws Exception {
        Collection created = Collection.create((Context)this.context, (String)"987654321/100");
        Assert.assertThat((String)"testCreateWithValidHandle 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateWithValidHandle 1", (Object)created.getHandle(), (Matcher)CoreMatchers.equalTo((Object)"987654321/100"));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWithInvalidHandle() throws Exception {
        String inUseHandle = this.c.getHandle();
        Collection created = Collection.create((Context)this.context, (String)inUseHandle);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        Collection[] all = Collection.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (all.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Collection cl : all) {
            if (!cl.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testGetItems() throws Exception {
        ItemIterator items = this.c.getItems();
        Assert.assertThat((String)"testGetItems 0", (Object)items, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testGetItems 1", (boolean)items.hasNext());
        Assert.assertThat((String)"testGetItems 2", (Object)items.next(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetItems 3", (Object)items.nextID(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testGetAllItems() throws Exception {
        ItemIterator items = this.c.getAllItems();
        Assert.assertThat((String)"testGetAllItems 0", (Object)items, (Matcher)CoreMatchers.notNullValue());
        Assert.assertFalse((String)"testGetAllItems 1", (boolean)items.hasNext());
        Assert.assertThat((String)"testGetAllItems 2", (Object)items.next(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetAllItems 3", (Object)items.nextID(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.c.getID() >= 1 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertTrue((String)"testGetHandle 0", (boolean)this.c.getHandle().contains("123456789/"));
    }

    @Test
    public void testGetMetadata() {
        Assert.assertThat((String)"testGetMetadata 0", (Object)this.c.getMetadata("name"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 1", (Object)this.c.getMetadata("short_description"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 2", (Object)this.c.getMetadata("introductory_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 3", (Object)this.c.getMetadata("logo_bitstream_id"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 4", (Object)this.c.getMetadata("copyright_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 5", (Object)this.c.getMetadata("template_item_id"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 6", (Object)this.c.getMetadata("provenance_description"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 7", (Object)this.c.getMetadata("side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 8", (Object)this.c.getMetadata("license"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testSetMetadata() {
        String name = "name";
        String sdesc = "short description";
        String itext = "introductory text";
        String logo = "1";
        String copy = "copyright declaration";
        String sidebar = "side bar text";
        String tempItem = "3";
        String provDesc = "provenance description";
        String license = "license text";
        this.c.setMetadata("name", name);
        this.c.setMetadata("short_description", sdesc);
        this.c.setMetadata("introductory_text", itext);
        this.c.setMetadata("logo_bitstream_id", logo);
        this.c.setMetadata("copyright_text", copy);
        this.c.setMetadata("side_bar_text", sidebar);
        this.c.setMetadata("template_item_id", tempItem);
        this.c.setMetadata("provenance_description", provDesc);
        this.c.setMetadata("license", license);
        Assert.assertThat((String)"testSetMetadata 0", (Object)this.c.getMetadata("name"), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((String)"testSetMetadata 1", (Object)this.c.getMetadata("short_description"), (Matcher)CoreMatchers.equalTo((Object)sdesc));
        Assert.assertThat((String)"testSetMetadata 2", (Object)this.c.getMetadata("introductory_text"), (Matcher)CoreMatchers.equalTo((Object)itext));
        Assert.assertThat((String)"testSetMetadata 3", (Object)this.c.getMetadata("logo_bitstream_id"), (Matcher)CoreMatchers.equalTo((Object)logo));
        Assert.assertThat((String)"testSetMetadata 4", (Object)this.c.getMetadata("copyright_text"), (Matcher)CoreMatchers.equalTo((Object)copy));
        Assert.assertThat((String)"testSetMetadata 5", (Object)this.c.getMetadata("side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)sidebar));
        Assert.assertThat((String)"testGetMetadata 6", (Object)this.c.getMetadata("template_item_id"), (Matcher)CoreMatchers.equalTo((Object)tempItem));
        Assert.assertThat((String)"testGetMetadata 7", (Object)this.c.getMetadata("provenance_description"), (Matcher)CoreMatchers.equalTo((Object)provDesc));
        Assert.assertThat((String)"testGetMetadata 8", (Object)this.c.getMetadata("license"), (Matcher)CoreMatchers.equalTo((Object)license));
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.c.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testGetLogo() {
        Assert.assertThat((String)"testGetLogo 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth2 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth2 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth3() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth3 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth3 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth4() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth4 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth4 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testSetLogoNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.fail((String)"EXception expected");
    }

    @Test
    public void testCreateWorkflowGroupAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageWorkflowsGroup((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        int step = 1;
        Group result = this.c.createWorkflowGroup(step);
        Assert.assertThat((String)"testCreateWorkflowGroupAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateWorkflowGroupNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageWorkflowsGroup((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        int step = 1;
        Group result = this.c.createWorkflowGroup(step);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testSetWorkflowGroup() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        int step = 1;
        Group g = Group.create((Context)this.context);
        this.context.restoreAuthSystemState();
        this.c.setWorkflowGroup(step, g);
        Assert.assertThat((String)"testSetWorkflowGroup 0", (Object)this.c.getWorkflowGroup(step), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetWorkflowGroup 1", (Object)this.c.getWorkflowGroup(step), (Matcher)CoreMatchers.equalTo((Object)g));
    }

    @Test
    public void testGetWorkflowGroup() {
        int step = 1;
        Assert.assertThat((String)"testGetWorkflowGroup 0", (Object)this.c.getWorkflowGroup(step), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreateSubmittersAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        Group result = this.c.createSubmitters();
        Assert.assertThat((String)"testCreateSubmittersAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSubmittersNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        Group result = this.c.createSubmitters();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveSubmittersAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        this.c.removeSubmitters();
        Assert.assertThat((String)"testRemoveSubmittersAuth 0", (Object)this.c.getSubmitters(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveSubmittersNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageSubmittersGroup((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        this.c.removeSubmitters();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetSubmitters() {
        Assert.assertThat((String)"testGetSubmitters 0", (Object)this.c.getSubmitters(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreateAdministratorsAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        Group result = this.c.createAdministrators();
        Assert.assertThat((String)"testCreateAdministratorsAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        Group result = this.c.createAdministrators();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveAdministratorsAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        this.c.removeAdministrators();
        Assert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        this.c.removeAdministrators();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetAdministrators() {
        Assert.assertThat((String)"testGetAdministrators 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetLicense() {
        Assert.assertThat((String)"testGetLicense 0", (Object)this.c.getLicense(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetLicense 1", (Object)this.c.getLicense(), (Matcher)CoreMatchers.equalTo((Object)ConfigurationManager.getDefaultSubmissionLicense()));
    }

    @Test
    public void testGetLicenseCollection() {
        Assert.assertThat((String)"testGetLicenseCollection 0", (Object)this.c.getLicenseCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetLicenseCollection 1", (Object)this.c.getLicenseCollection(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testHasCustomLicense() {
        Assert.assertFalse((String)"testHasCustomLicense 0", (boolean)this.c.hasCustomLicense());
    }

    @Test
    public void testSetLicense() {
        String license = "license for test";
        this.c.setLicense(license);
        Assert.assertThat((String)"testSetLicense 0", (Object)this.c.getLicense(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetLicense 1", (Object)this.c.getLicense(), (Matcher)CoreMatchers.equalTo((Object)license));
        Assert.assertThat((String)"testSetLicense 2", (Object)this.c.getLicenseCollection(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetLicense 3", (Object)this.c.getLicenseCollection(), (Matcher)CoreMatchers.equalTo((Object)license));
    }

    @Test
    public void testGetTemplateItem() throws Exception {
        Assert.assertThat((String)"testGetTemplateItem 0", (Object)this.c.getTemplateItem(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCreateTemplateItemAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        this.c.createTemplateItem();
        Assert.assertThat((String)"testCreateTemplateItemAuth 0", (Object)this.c.getTemplateItem(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateTemplateItemNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        this.c.createTemplateItem();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveTemplateItemAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        this.c.removeTemplateItem();
        Assert.assertThat((String)"testRemoveTemplateItemAuth 0", (Object)this.c.getTemplateItem(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveTemplateItemNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
            }
        };
        this.c.removeTemplateItem();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddItemAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = null;
            }
        };
        Item item = Item.create((Context)this.context);
        this.c.addItem(item);
        boolean added = false;
        ItemIterator ii = this.c.getAllItems();
        while (ii.hasNext()) {
            if (!ii.next().equals((Object)item)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testAddItemAuth 0", (boolean)added);
    }

    @Test(expected=AuthorizeException.class)
    public void testAddItemNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = new AuthorizeException();
            }
        };
        Item item = Item.create((Context)this.context);
        this.c.addItem(item);
        Assert.fail((String)"Excep[tion expected");
    }

    @Test
    public void testRemoveItemAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)4);
                result = null;
            }
        };
        Item item = Item.create((Context)this.context);
        this.c.addItem(item);
        this.c.removeItem(item);
        boolean isthere = false;
        ItemIterator ii = this.c.getAllItems();
        while (ii.hasNext()) {
            if (!ii.next().equals((Object)item)) continue;
            isthere = true;
        }
        Assert.assertFalse((String)"testRemoveItemAuth 0", (boolean)isthere);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveItemNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)4);
                result = new AuthorizeException();
            }
        };
        Item item = Item.create((Context)this.context);
        this.c.addItem(item);
        this.c.removeItem(item);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.update();
    }

    @Test
    public void testUpdateAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.update();
    }

    @Test
    public void testUpdateAuth3() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.update();
    }

    @Test
    public void testUpdateAuth4() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.update();
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        this.c.update();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth4() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth_boolean 0", (boolean)this.c.canEditBoolean(true));
    }

    @Test
    public void testCanEditBooleanAuth2_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2_boolean 0", (boolean)this.c.canEditBoolean(true));
    }

    @Test
    public void testCanEditBooleanAuth3_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth3_boolean 0", (boolean)this.c.canEditBoolean(true));
    }

    @Test
    public void testCanEditBooleanAuth4_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4_boolean 0", (boolean)this.c.canEditBoolean(true));
    }

    @Test
    public void testCanEditBooleanAuth5_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth5_boolean 0", (boolean)this.c.canEditBoolean(false));
    }

    @Test
    public void testCanEditBooleanAuth6_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth6_boolean 0", (boolean)this.c.canEditBoolean(false));
    }

    @Test
    public void testCanEditBooleanAuth7_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth7_boolean 0", (boolean)this.c.canEditBoolean(false));
    }

    @Test
    public void testCanEditBooleanAuth8_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth8_boolean 0", (boolean)this.c.canEditBoolean(false));
    }

    @Test
    public void testCanEditBooleanNoAuth_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth_boolean 0", (boolean)this.c.canEditBoolean(true));
    }

    @Test
    public void testCanEditBooleanNoAuth2_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth_boolean 0", (boolean)this.c.canEditBoolean(false));
    }

    @Test
    public void testCanEditAuth_0args() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test
    public void testCanEditAuth2_0args() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test
    public void testCanEditAuth3_0args() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test
    public void testCanEditAuth4_0args() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth_0args() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        this.c.canEdit();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCanEditAuth_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit(true);
    }

    @Test
    public void testCanEditAuth2_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit(true);
    }

    @Test
    public void testCanEditAuth3_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit(true);
    }

    @Test
    public void testCanEditAuth4_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = null;
            }
        };
        this.c.canEdit(true);
    }

    @Test
    public void testCanEditAuth5_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        this.c.canEdit(false);
    }

    @Test
    public void testCanEditAuth6_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        this.c.canEdit(false);
    }

    @Test
    public void testCanEditAuth7_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        this.c.canEdit(false);
    }

    @Test
    public void testCanEditAuth8_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = null;
            }
        };
        this.c.canEdit(false);
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)false);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)false);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)false);
                result = new AuthorizeException();
            }
        };
        this.c.canEdit(false);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth2_boolean() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1, (boolean)true);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3, (boolean)true);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)true);
                result = new AuthorizeException();
            }
        };
        this.c.canEdit(true);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authUtil;
            AuthorizeManager authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)anyBoolean);
                result = null;
            }
        };
        int id = this.c.getID();
        this.c.delete();
        Assert.assertThat((String)"testDelete 0", (Object)Collection.find((Context)this.context, (int)id), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authUtil;
            AuthorizeManager authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = new AuthorizeException();
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)anyBoolean);
                result = null;
            }
        };
        int id = this.c.getID();
        this.c.delete();
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authUtil;
            AuthorizeManager authManager;
            {
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)1, (boolean)anyBoolean);
                result = new AuthorizeException();
            }
        };
        int id = this.c.getID();
        this.c.delete();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetCommunities() throws Exception {
        Assert.assertThat((String)"testGetCommunities 0", (Object)this.c.getCommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCommunities 1", (this.c.getCommunities().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = true;
            }
        };
        Assert.assertFalse((String)"testEquals 0", (boolean)this.c.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)this.c.equals((Object)Collection.create((Context)this.context)));
        Assert.assertTrue((String)"testEquals 2", (boolean)this.c.equals((Object)this.c));
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.c.getType(), (Matcher)CoreMatchers.equalTo((Object)3));
    }

    @Test
    public void testFindAuthorized() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community com = Community.create(null, (Context)this.context);
        this.context.restoreAuthSystemState();
        Collection[] found = Collection.findAuthorized((Context)this.context, (Community)com, (int)1);
        Assert.assertThat((String)"testFindAuthorized 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 1", (found.length == 0 ? 1 : 0) != 0);
        found = Collection.findAuthorized((Context)this.context, null, (int)1);
        Assert.assertThat((String)"testFindAuthorized 2", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 3", (found.length == 0 ? 1 : 0) != 0);
        found = Collection.findAuthorized((Context)this.context, (Community)com, (int)3);
        Assert.assertThat((String)"testFindAuthorized 3", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 4", (found.length == 0 ? 1 : 0) != 0);
        found = Collection.findAuthorized((Context)this.context, null, (int)3);
        Assert.assertThat((String)"testFindAuthorized 5", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 6", (found.length == 0 ? 1 : 0) != 0);
        found = Collection.findAuthorized((Context)this.context, (Community)com, (int)0);
        Assert.assertThat((String)"testFindAuthorized 7", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 8", (found.length == 0 ? 1 : 0) != 0);
        found = Collection.findAuthorized((Context)this.context, null, (int)0);
        Assert.assertThat((String)"testFindAuthorized 9", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAuthorized 10", (found.length >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCountItems() throws Exception {
        Assert.assertTrue((String)"testCountItems 0", (this.c.countItems() == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)((Collection)this.c.getAdminObject(4)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)((Collection)this.c.getAdminObject(3)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        Assert.assertThat((String)"testGetAdminObject 2", (Object)this.c.getAdminObject(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetAdminObject 3", (Object)((Collection)this.c.getAdminObject(11)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            Assert.assertThat((String)"testGetParentObject 0", (Object)this.c.getParentObject(), (Matcher)CoreMatchers.nullValue());
            this.context.turnOffAuthorisationSystem();
            Community parent = Community.create(null, (Context)this.context);
            parent.addCollection(this.c);
            this.context.restoreAuthSystemState();
            Assert.assertThat((String)"testGetParentObject 1", (Object)this.c.getParentObject(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testGetParentObject 2", (Object)((Community)this.c.getParentObject()), (Matcher)CoreMatchers.equalTo((Object)parent));
        }
        catch (AuthorizeException ex) {
            Assert.fail((String)"Authorize exception catched");
        }
    }
}

