/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.Required;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommunityCollectionIntegrationTest
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(CommunityCollectionIntegrationTest.class);

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    @PerfTest(invocations=25, threads=1)
    @Required(percentile95=1200, average=700, throughput=1)
    public void testCreateTree() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        Community parent = Community.create(null, (Context)this.context);
        Community child1 = Community.create((Community)parent, (Context)this.context);
        Collection col1 = Collection.create((Context)this.context);
        Collection col2 = Collection.create((Context)this.context);
        child1.addCollection(col1);
        child1.addCollection(col2);
        this.context.restoreAuthSystemState();
        this.context.commit();
        Assert.assertThat((String)"testCreateTree 0", (Object)parent.getParentCommunity(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testCreateTree 1", (Object)child1.getParentCommunity(), (Matcher)CoreMatchers.equalTo((Object)parent));
        Assert.assertThat((String)"testCreateTree 2", (Object)((Community)col1.getParentObject()), (Matcher)CoreMatchers.equalTo((Object)child1));
        Assert.assertThat((String)"testCreateTree 3", (Object)((Community)col2.getParentObject()), (Matcher)CoreMatchers.equalTo((Object)child1));
    }

    @Test
    @PerfTest(invocations=50, threads=1)
    @Required(percentile95=2000, average=1800)
    public void testCountItems() throws SQLException, AuthorizeException {
        int totalitems = 4;
        this.context.turnOffAuthorisationSystem();
        Community parent = Community.create(null, (Context)this.context);
        Community child1 = Community.create((Community)parent, (Context)this.context);
        Collection col1 = Collection.create((Context)this.context);
        Collection col2 = Collection.create((Context)this.context);
        child1.addCollection(col1);
        child1.addCollection(col2);
        for (int count = 0; count < totalitems / 2; ++count) {
            Item item1 = Item.create((Context)this.context);
            item1.setArchived(true);
            item1.update();
            Item item2 = Item.create((Context)this.context);
            item2.setArchived(true);
            item2.update();
            col1.addItem(item1);
            col2.addItem(item2);
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        Assert.assertThat((String)"testCountItems 0", (Object)col1.countItems(), (Matcher)CoreMatchers.equalTo((Object)(totalitems / 2)));
        Assert.assertThat((String)"testCountItems 1", (Object)col2.countItems(), (Matcher)CoreMatchers.equalTo((Object)(totalitems / 2)));
        Assert.assertThat((String)"testCountItems 2", (Object)child1.countItems(), (Matcher)CoreMatchers.equalTo((Object)totalitems));
        Assert.assertThat((String)"testCountItems 3", (Object)parent.countItems(), (Matcher)CoreMatchers.equalTo((Object)totalitems));
    }
}

