/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.eperson.Group;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommunityTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = Logger.getLogger(CommunityTest.class);
    private Community c;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.c = Community.create(null, (Context)this.context);
            this.dspaceObject = this.c;
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)"Authorization Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.c = null;
        super.destroy();
    }

    @Test
    public void testCommunityFind() throws Exception {
        int id = this.c.getID();
        Community found = Community.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testCommunityFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCommunityFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testCommunityFind 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testCreateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = false;
            }
        };
        Community son = Community.create((Community)this.c, (Context)this.context);
        Assert.assertThat((String)"testCreate 2", (Object)son, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 3", (Object)son.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertTrue((String)"testCreate 4", (son.getAllParents().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 5", (Object)son.getAllParents()[0], (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testCreateAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        Community created = Community.create(null, (Context)this.context);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Community son = Community.create((Community)created, (Context)this.context);
        Assert.assertThat((String)"testCreate 2", (Object)son, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreate 3", (Object)son.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertTrue((String)"testCreate 4", (son.getAllParents().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 5", (Object)son.getAllParents()[0], (Matcher)CoreMatchers.equalTo((Object)created));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = false;
            }
        };
        Community created = Community.create(null, (Context)this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateWithValidHandle() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        Community created = Community.create(null, (Context)this.context, (String)"987654321/100");
        Assert.assertThat((String)"testCreateWithValidHandle 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateWithValidHandle 1", (Object)created.getHandle(), (Matcher)CoreMatchers.equalTo((Object)"987654321/100"));
    }

    @Test(expected=IllegalStateException.class)
    public void testCreateWithInvalidHandle() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        String inUseHandle = this.c.getHandle();
        Community created = Community.create(null, (Context)this.context, (String)inUseHandle);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = false;
            }
        };
        Community created = Community.create(null, (Context)this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        Community[] all = Community.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (all.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Community cm : all) {
            if (!cm.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFindAllTop() throws Exception {
        Community[] all = Community.findAllTop((Context)this.context);
        Assert.assertThat((String)"testFindAllTop 0", (Object)all, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAllTop 1", (all.length >= 1 ? 1 : 0) != 0);
        for (Community cm : all) {
            Assert.assertThat((String)"testFindAllTop for", (Object)cm.getAllParents().length, (Matcher)CoreMatchers.equalTo((Object)0));
        }
        boolean added = false;
        for (Community cm : all) {
            if (!cm.equals((Object)this.c)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAllTop 2", (boolean)added);
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.c.getID() >= 1 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        Assert.assertTrue((String)"testGetHandle 0", (boolean)this.c.getHandle().contains("123456789/"));
    }

    @Test
    public void testGetMetadata() {
        Assert.assertThat((String)"testGetMetadata 0", (Object)this.c.getMetadata("name"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 1", (Object)this.c.getMetadata("short_description"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 2", (Object)this.c.getMetadata("introductory_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 3", (Object)this.c.getMetadata("logo_bitstream_id"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 4", (Object)this.c.getMetadata("copyright_text"), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((String)"testGetMetadata 5", (Object)this.c.getMetadata("side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testSetMetadata() {
        String name = "name";
        String sdesc = "short description";
        String itext = "introductory text";
        String logo = "1";
        String copy = "copyright declaration";
        String sidebar = "side bar text";
        this.c.setMetadata("name", name);
        this.c.setMetadata("short_description", sdesc);
        this.c.setMetadata("introductory_text", itext);
        this.c.setMetadata("logo_bitstream_id", logo);
        this.c.setMetadata("copyright_text", copy);
        this.c.setMetadata("side_bar_text", sidebar);
        Assert.assertThat((String)"testSetMetadata 0", (Object)this.c.getMetadata("name"), (Matcher)CoreMatchers.equalTo((Object)name));
        Assert.assertThat((String)"testSetMetadata 1", (Object)this.c.getMetadata("short_description"), (Matcher)CoreMatchers.equalTo((Object)sdesc));
        Assert.assertThat((String)"testSetMetadata 2", (Object)this.c.getMetadata("introductory_text"), (Matcher)CoreMatchers.equalTo((Object)itext));
        Assert.assertThat((String)"testSetMetadata 3", (Object)this.c.getMetadata("logo_bitstream_id"), (Matcher)CoreMatchers.equalTo((Object)logo));
        Assert.assertThat((String)"testSetMetadata 4", (Object)this.c.getMetadata("copyright_text"), (Matcher)CoreMatchers.equalTo((Object)copy));
        Assert.assertThat((String)"testSetMetadata 5", (Object)this.c.getMetadata("side_bar_text"), (Matcher)CoreMatchers.equalTo((Object)sidebar));
    }

    @Override
    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.c.getName(), (Matcher)CoreMatchers.equalTo((Object)""));
    }

    @Test
    public void testGetLogo() {
        Assert.assertThat((String)"testGetLogo 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth2 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth2 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth3() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth3 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth3 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetLogoAuth4() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.assertThat((String)"testSetLogoAuth4 0", (Object)this.c.getLogo(), (Matcher)CoreMatchers.equalTo((Object)logo));
        this.c.setLogo(null);
        Assert.assertThat((String)"testSetLogoAuth4 1", (Object)this.c.getLogo(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testSetLogoNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = new AuthorizeException();
            }
        };
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream logo = this.c.setLogo((InputStream)new FileInputStream(f));
        Assert.fail((String)"EXception expected");
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = new AuthorizeException();
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = new AuthorizeException();
            }
        };
        this.c.update();
        Assert.fail((String)"Exception must be thrown");
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
            }
        };
        this.c.update();
    }

    @Test
    public void testCreateAdministratorsAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)any), (Community)((Community)any));
                result = null;
            }
        };
        Group result = this.c.createAdministrators();
        Assert.assertThat((String)"testCreateAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)any), (Community)((Community)any));
                result = new AuthorizeException();
            }
        };
        Group result = this.c.createAdministrators();
        Assert.fail((String)"Exception should have been thrown");
    }

    @Test
    public void testRemoveAdministratorsAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeManageAdminGroup((Context)((Context)any), (Community)((Community)any));
                result = null;
            }
        };
        Group result = this.c.createAdministrators();
        Assert.assertThat((String)"testRemoveAdministratorsAuth 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testRemoveAdministratorsAuth 1", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.equalTo((Object)result));
        this.c.removeAdministrators();
        Assert.assertThat((String)"testRemoveAdministratorsAuth 2", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveAdministratorsNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeUtil authManager;
            {
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)((Context)any), (Community)((Community)any));
                result = new AuthorizeException();
            }
        };
        this.c.removeAdministrators();
        Assert.fail((String)"Should have thrown exception");
    }

    @Test
    public void testGetAdministrators() {
        Assert.assertThat((String)"testGetAdministrators 0", (Object)this.c.getAdministrators(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetCollections() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
            }
        };
        Assert.assertThat((String)"testGetCollections 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 1", (this.c.getCollections().length == 0 ? 1 : 0) != 0);
        Collection result = this.c.createCollection();
        Assert.assertThat((String)"testGetCollections 2", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetCollections 3", (this.c.getCollections().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetCollections 4", (Object)this.c.getCollections()[0], (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test
    public void testGetSubcommunities() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
            }
        };
        Assert.assertThat((String)"testGetSubcommunities 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSubcommunities 1", (this.c.getSubcommunities().length == 0 ? 1 : 0) != 0);
        Community son = Community.create((Community)this.c, (Context)this.context);
        Assert.assertThat((String)"testGetSubcommunities 2", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSubcommunities 3", (this.c.getSubcommunities().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetSubcommunities 4", (Object)this.c.getSubcommunities()[0], (Matcher)CoreMatchers.equalTo((Object)son));
    }

    @Test
    public void testGetParentCommunity() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
            }
        };
        Assert.assertThat((String)"testGetParentCommunity 0", (Object)this.c.getParentCommunity(), (Matcher)CoreMatchers.nullValue());
        Community son = Community.create((Community)this.c, (Context)this.context);
        Assert.assertThat((String)"testGetParentCommunity 1", (Object)son.getParentCommunity(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetParentCommunity 2", (Object)son.getParentCommunity(), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testGetAllParents() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
            }
        };
        Assert.assertThat((String)"testGetAllParents 0", (Object)this.c.getAllParents(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllParents 1", (this.c.getAllParents().length == 0 ? 1 : 0) != 0);
        Community son = Community.create((Community)this.c, (Context)this.context);
        Assert.assertThat((String)"testGetAllParents 2", (Object)son.getAllParents(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAllParents 3", (son.getAllParents().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetAllParents 4", (Object)son.getAllParents()[0], (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Test
    public void testCreateCollectionAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
            }
        };
        Collection result = this.c.createCollection();
        Assert.assertThat((String)"testCreateCollectionAuth 0", (Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateCollectionAuth 1", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testCreateCollectionAuth 2", (Object)this.c.getCollections()[0], (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateCollectionNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = new AuthorizeException();
            }
        };
        Collection result = this.c.createCollection();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddCollectionAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
            }
        };
        Collection col = Collection.create((Context)this.context);
        this.c.addCollection(col);
        Assert.assertThat((String)"testAddCollectionAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testAddCollectionAuth 1", (Object)this.c.getCollections()[0], (Matcher)CoreMatchers.equalTo((Object)col));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddCollectionNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = new AuthorizeException();
            }
        };
        Collection col = Collection.create((Context)this.context);
        this.c.addCollection(col);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCreateSubcommunityAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
            }
        };
        Community result = this.c.createSubcommunity();
        Assert.assertThat((String)"testCreateSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreateSubcommunityAuth 1", (this.c.getSubcommunities().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreateSubcommunityAuth 2", (Object)this.c.getSubcommunities()[0], (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateSubcommunityNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = new AuthorizeException();
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
            }
        };
        Community result = this.c.createSubcommunity();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testAddSubcommunityAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        Community result = Community.create(null, (Context)this.context);
        this.c.addSubcommunity(result);
        Assert.assertThat((String)"testAddSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testAddSubcommunityAuth 1", (this.c.getSubcommunities().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testAddSubcommunityAuth 2", (Object)this.c.getSubcommunities()[0], (Matcher)CoreMatchers.equalTo((Object)result));
    }

    @Test(expected=AuthorizeException.class)
    public void testAddSubcommunityNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = new AuthorizeException();
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
            }
        };
        Community result = Community.create(null, (Context)this.context);
        this.c.addSubcommunity(result);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveCollectionAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            AuthorizeUtil authUtil;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)4);
                result = null;
                AuthorizeUtil.authorizeManageTemplateItem((Context)((Context)any), (Collection)((Collection)any));
                result = null;
            }
        };
        Collection col = Collection.create((Context)this.context);
        this.c.addCollection(col);
        Assert.assertThat((String)"testRemoveCollectionAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionAuth 1", (this.c.getCollections().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testRemoveCollectionAuth 2", (Object)this.c.getCollections()[0], (Matcher)CoreMatchers.equalTo((Object)col));
        this.c.removeCollection(col);
        Assert.assertThat((String)"testRemoveCollectionAuth 3", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionAuth 4", (this.c.getCollections().length == 0 ? 1 : 0) != 0);
    }

    @Test(expected=AuthorizeException.class)
    public void testRemoveCollectionNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)4);
                result = new AuthorizeException();
            }
        };
        Collection col = Collection.create((Context)this.context);
        this.c.addCollection(col);
        Assert.assertThat((String)"testRemoveCollectionNoAuth 0", (Object)this.c.getCollections(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveCollectionNoAuth 1", (this.c.getCollections().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testRemoveCollectionNoAuth 2", (Object)this.c.getCollections()[0], (Matcher)CoreMatchers.equalTo((Object)col));
        this.c.removeCollection(col);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testRemoveSubcommunityAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)4);
                result = null;
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        Community com = Community.create(null, (Context)this.context);
        this.c.addSubcommunity(com);
        Assert.assertThat((String)"testRemoveSubcommunityAuth 0", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveSubcommunityAuth 1", (this.c.getSubcommunities().length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testRemoveSubcommunityAuth 2", (Object)this.c.getSubcommunities()[0], (Matcher)CoreMatchers.equalTo((Object)com));
        this.c.removeSubcommunity(com);
        Assert.assertThat((String)"testRemoveSubcommunityAuth 3", (Object)this.c.getSubcommunities(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testRemoveSubcommunityAuth 4", (this.c.getSubcommunities().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)2);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)4);
                result = false;
            }
        };
        int id = this.c.getID();
        this.c.delete();
        Community found = Community.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)2);
                result = null;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)4);
                result = true;
            }
        };
        int id = this.c.getID();
        this.c.delete();
        Community found = Community.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testDeleteAuth2 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)2);
                result = new AuthorizeException();
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)4);
                result = false;
            }
        };
        int id = this.c.getID();
        this.c.delete();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testEquals() throws SQLException, AuthorizeException {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)((Context)any));
                result = true;
            }
        };
        Assert.assertFalse((String)"testEquals 0", (boolean)this.c.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)this.c.equals((Object)Community.create(null, (Context)this.context)));
        Assert.assertTrue((String)"testEquals 2", (boolean)this.c.equals((Object)this.c));
    }

    @Override
    @Test
    public void testGetType() {
        Assert.assertThat((String)"testGetType 0", (Object)this.c.getType(), (Matcher)CoreMatchers.equalTo((Object)4));
    }

    @Test
    public void testCanEditBooleanAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth2 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth3() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth3 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanAuth4() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        Assert.assertTrue((String)"testCanEditBooleanAuth4 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditBooleanNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = new AuthorizeException();
            }
        };
        Assert.assertFalse((String)"testCanEditBooleanNoAuth 0", (boolean)this.c.canEditBoolean());
    }

    @Test
    public void testCanEditAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test
    public void testCanEditAuth1() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = true;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test
    public void testCanEditAuth2() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = true;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = null;
            }
        };
        this.c.canEdit();
    }

    @Test(expected=AuthorizeException.class)
    public void testCanEditNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = false;
                AuthorizeManager.authorizeActionBoolean((Context)((Context)any), (DSpaceObject)((Community)any), (int)3);
                result = false;
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Community)any), (int)1);
                result = new AuthorizeException();
            }
        };
        this.c.canEdit();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testCountItems() throws Exception {
        Assert.assertTrue((String)"testCountItems 0", (this.c.countItems() == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetAdminObject() throws SQLException {
        Assert.assertThat((String)"testGetAdminObject 0", (Object)((Community)this.c.getAdminObject(4)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        Assert.assertThat((String)"testGetAdminObject 1", (Object)((Community)this.c.getAdminObject(3)), (Matcher)CoreMatchers.equalTo((Object)this.c));
        Assert.assertThat((String)"testGetAdminObject 2", (Object)this.c.getAdminObject(2), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"testGetAdminObject 3", (Object)((Community)this.c.getAdminObject(11)), (Matcher)CoreMatchers.equalTo((Object)this.c));
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        try {
            Assert.assertThat((String)"testGetParentObject 0", (Object)this.c.getParentObject(), (Matcher)CoreMatchers.nullValue());
            this.context.turnOffAuthorisationSystem();
            Community son = this.c.createSubcommunity();
            this.context.restoreAuthSystemState();
            Assert.assertThat((String)"testGetParentObject 1", (Object)son.getParentObject(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testGetParentObject 2", (Object)((Community)son.getParentObject()), (Matcher)CoreMatchers.equalTo((Object)this.c));
        }
        catch (AuthorizeException ex) {
            Assert.fail((String)"Authorize exception catched");
        }
    }
}

