/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.FormatIdentifier;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormatIdentifierTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(FormatIdentifierTest.class);

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testGuessFormat() throws Exception {
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream bs = null;
        BitstreamFormat result = null;
        BitstreamFormat pdf = BitstreamFormat.findByShortDescription((Context)this.context, (String)"Adobe PDF");
        bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        this.context.commit();
        bs.setName(null);
        result = FormatIdentifier.guessFormat((Context)this.context, (Bitstream)bs);
        Assert.assertThat((String)"testGuessFormat 0", (Object)result, (Matcher)CoreMatchers.nullValue());
        bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        bs.setName("file_without_extension.");
        this.context.commit();
        result = FormatIdentifier.guessFormat((Context)this.context, (Bitstream)bs);
        Assert.assertThat((String)"testGuessFormat 1", (Object)result, (Matcher)CoreMatchers.nullValue());
        bs = Bitstream.create((Context)this.context, (InputStream)new FileInputStream(f));
        bs.setName(testProps.get("test.bitstream").toString());
        this.context.commit();
        result = FormatIdentifier.guessFormat((Context)this.context, (Bitstream)bs);
        Assert.assertThat((String)"testGuessFormat 2", (Object)result.getID(), (Matcher)CoreMatchers.equalTo((Object)pdf.getID()));
        Assert.assertThat((String)"testGuessFormat 3", (Object)result.getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)pdf.getMIMEType()));
        Assert.assertThat((String)"testGuessFormat 4", (Object)result.getExtensions(), (Matcher)CoreMatchers.equalTo((Object)pdf.getExtensions()));
    }
}

