/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.ItemComparator;
import org.dspace.core.Context;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemComparatorTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(ItemComparatorTest.class);
    private Item one;
    private Item two;

    @Override
    @Before
    public void init() {
        try {
            super.init();
            this.context.turnOffAuthorisationSystem();
            this.one = Item.create((Context)this.context);
            this.context.commit();
            this.two = Item.create((Context)this.context);
            this.context.commit();
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)"Authorization Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testCompare() {
        int result = 0;
        ItemComparator ic = null;
        ic = new ItemComparator("test", "one", "*", true);
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 0", (result == 0 ? 1 : 0) != 0);
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 1", (result >= 1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.two.addMetadata("dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 2", (result <= -1 ? 1 : 0) != 0);
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "2");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 3", (result <= -1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 4", (result == 0 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "2");
        this.two.addMetadata("dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 5", (result >= 1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "0");
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "2");
        this.two.addMetadata("dc", "test", "one", "*", "3");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 3", (result <= -1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "0");
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "-1");
        this.two.addMetadata("dc", "test", "one", "*", "1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 4", (result == 0 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", true);
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.one.addMetadata("dc", "test", "one", "*", "2");
        this.two.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "-1");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 5", (result >= 1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", false);
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.one.addMetadata("dc", "test", "one", "*", "2");
        this.two.addMetadata("dc", "test", "one", "*", "2");
        this.two.addMetadata("dc", "test", "one", "*", "3");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 3", (result <= -1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", false);
        this.one.addMetadata("dc", "test", "one", "*", "1");
        this.one.addMetadata("dc", "test", "one", "*", "2");
        this.two.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "5");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 4", (result == 0 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
        ic = new ItemComparator("test", "one", "*", false);
        this.one.addMetadata("dc", "test", "one", "*", "2");
        this.one.addMetadata("dc", "test", "one", "*", "3");
        this.two.addMetadata("dc", "test", "one", "*", "1");
        this.two.addMetadata("dc", "test", "one", "*", "4");
        result = ic.compare((Object)this.one, (Object)this.two);
        Assert.assertTrue((String)"testCompare 5", (result >= 1 ? 1 : 0) != 0);
        this.one.clearMetadata("dc", "test", "one", "*");
        this.two.clearMetadata("dc", "test", "one", "*");
    }

    @Test
    public void testEquals() {
        ItemComparator ic = new ItemComparator("test", "one", "*", true);
        ItemComparator target = null;
        Assert.assertFalse((String)"testEquals 0", (boolean)ic.equals(null));
        Assert.assertFalse((String)"testEquals 1", (boolean)ic.equals((Object)"test one"));
        target = new ItemComparator("test1", "one", "*", true);
        Assert.assertFalse((String)"testEquals 2", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test", "one1", "*", true);
        Assert.assertFalse((String)"testEquals 3", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test", "one", "es", true);
        Assert.assertFalse((String)"testEquals 4", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test1", "one", "*", false);
        Assert.assertFalse((String)"testEquals 5", (boolean)ic.equals((Object)target));
        target = new ItemComparator("test", "one", "*", true);
        Assert.assertTrue((String)"testEquals 6", (boolean)ic.equals((Object)target));
    }
}

