/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ItemIteratorTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(ItemIteratorTest.class);
    private ItemIterator iitr;
    private ItemIterator iitid;
    private ItemIterator iitnone;
    private int numitems;

    @Override
    @Before
    public void init() {
        try {
            super.init();
            ArrayList<Integer> list = new ArrayList<Integer>();
            this.numitems = 1;
            this.context.turnOffAuthorisationSystem();
            for (int i = 0; i < this.numitems; ++i) {
                Item it = Item.create((Context)this.context);
                list.add(it.getID());
                it.setArchived(true);
                it.update();
            }
            this.context.restoreAuthSystemState();
            this.iitr = Item.findAll((Context)this.context);
            this.iitid = new ItemIterator(this.context, list);
            this.iitnone = new ItemIterator(this.context, new ArrayList());
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)"Authorization Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testHasNext() throws Exception {
        int i;
        Assert.assertFalse((String)"testHasNext iitnone 0", (boolean)this.iitnone.hasNext());
        for (i = 0; i < this.numitems; ++i) {
            Assert.assertTrue((String)("testHasNext iitr " + i), (boolean)this.iitr.hasNext());
            this.iitr.next();
        }
        for (i = 0; i < this.numitems; ++i) {
            Assert.assertTrue((String)("testHasNext iitid " + i), (boolean)this.iitid.hasNext());
            this.iitid.next();
        }
    }

    @Test
    public void testNext() throws Exception {
        int i;
        Assert.assertThat((String)"testNext iitnone 0", (Object)this.iitnone.next(), (Matcher)CoreMatchers.nullValue());
        for (i = 0; i < this.numitems; ++i) {
            Assert.assertThat((String)("testNext iitr " + i), (Object)this.iitr.next(), (Matcher)CoreMatchers.notNullValue());
        }
        for (i = 0; i < this.numitems; ++i) {
            Assert.assertThat((String)("testNext iitid " + i), (Object)this.iitid.next(), (Matcher)CoreMatchers.notNullValue());
        }
    }

    @Test
    public void testNextID() throws Exception {
        int i;
        Assert.assertThat((String)"testNextID iitnone 0", (Object)this.iitnone.nextID(), (Matcher)CoreMatchers.equalTo((Object)-1));
        for (i = 0; i < this.numitems; ++i) {
            Assert.assertTrue((String)("testNextID iitr " + i), (this.iitr.nextID() >= 0 ? 1 : 0) != 0);
        }
        for (i = 0; i < this.numitems; ++i) {
            Assert.assertTrue((String)("testNextID iitid " + i), (this.iitid.nextID() >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testClose() {
        this.iitnone.close();
        this.iitr.close();
        this.iitid.close();
    }
}

