/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.Required;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataIntegrationTest
extends AbstractIntegrationTest {
    private static final Logger log = Logger.getLogger(MetadataIntegrationTest.class);

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    @PerfTest(invocations=50, threads=1)
    @Required(percentile95=500, average=200)
    public void testCreateSchema() throws SQLException, AuthorizeException, NonUniqueMetadataException, IOException {
        String schemaName = "integration";
        this.context.turnOffAuthorisationSystem();
        Item it = Item.create((Context)this.context);
        MetadataSchema schema = new MetadataSchema("htpp://test/schema/", schemaName);
        schema.create(this.context);
        MetadataField field1 = new MetadataField(schema, "elem1", "qual1", "note 1");
        field1.create(this.context);
        MetadataField field2 = new MetadataField(schema, "elem2", "qual2", "note 2");
        field2.create(this.context);
        MetadataValue value1 = new MetadataValue(field1);
        value1.setItemId(it.getID());
        value1.setValue("value1");
        value1.create(this.context);
        MetadataValue value2 = new MetadataValue(field2);
        value2.setItemId(it.getID());
        value2.setValue("value2");
        value2.create(this.context);
        this.context.commit();
        Assert.assertThat((String)"testCreateSchema 0", (Object)schema.getName(), (Matcher)CoreMatchers.equalTo((Object)schemaName));
        Assert.assertThat((String)"testCreateSchema 1", (Object)field1.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)schema.getSchemaID()));
        Assert.assertThat((String)"testCreateSchema 2", (Object)field2.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)schema.getSchemaID()));
        MetadataField[] fields = MetadataField.findAllInSchema((Context)this.context, (int)schema.getSchemaID());
        Assert.assertTrue((String)"testCreateSchema 3", (fields.length == 2 ? 1 : 0) != 0);
        boolean exist = true;
        for (MetadataField f : fields) {
            if (f.equals((Object)field1) || f.equals((Object)field2)) continue;
            exist = false;
        }
        Assert.assertTrue((String)"testCreateSchema 4", (boolean)exist);
        List col1 = MetadataValue.findByField((Context)this.context, (int)field1.getFieldID());
        Assert.assertTrue((String)"testCreateSchema 5", (boolean)col1.contains(value1));
        List col2 = MetadataValue.findByField((Context)this.context, (int)field2.getFieldID());
        Assert.assertTrue((String)"testCreateSchema 6", (boolean)col2.contains(value2));
        value1.delete(this.context);
        col1 = MetadataValue.findByField((Context)this.context, (int)field1.getFieldID());
        Assert.assertFalse((String)"testCreateSchema 7", (boolean)col1.contains(value1));
        value2.delete(this.context);
        field1.delete(this.context);
        field2.delete(this.context);
        schema.delete(this.context);
        this.context.restoreAuthSystemState();
        this.context.commit();
    }
}

