/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataSchemaTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(MetadataSchemaTest.class);
    private MetadataSchema ms;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.ms = MetadataSchema.find((Context)this.context, (int)1);
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testGetNamespace() {
        Assert.assertThat((String)"testGetNamespace 0", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetNamespace 1", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void testSetNamespace() {
        String oldnamespace = this.ms.getNamespace();
        String namespace = "new namespace";
        this.ms.setNamespace(namespace);
        Assert.assertThat((String)"testSetNamespace 0", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetNamespace 1", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetNamespace 2", (Object)this.ms.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)namespace));
        this.ms.setNamespace(oldnamespace);
    }

    @Test
    public void testGetName() {
        Assert.assertThat((String)"testGetName 0", (Object)this.ms.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetName 1", (Object)this.ms.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
    }

    @Test
    public void testSetName() {
        String name = "new name";
        this.ms.setName(name);
        Assert.assertThat((String)"testSetName 0", (Object)this.ms.getName(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testSetName 1", (Object)this.ms.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        Assert.assertThat((String)"testSetName 2", (Object)this.ms.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetSchemaID() {
        Assert.assertThat((String)"testGetSchemaID 0", (Object)this.ms.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testCreateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = true;
            }
        };
        String namespace = "namespace";
        String name = "name";
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.create(this.context);
        MetadataSchema found = MetadataSchema.findByNamespace((Context)this.context, (String)namespace);
        Assert.assertThat((String)"testCreateAuth 0", (Object)found.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)m.getSchemaID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = false;
            }
        };
        String namespace = "namespace";
        String name = "name";
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.create(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testCreateRepeated() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = true;
            }
        };
        String namespace = this.ms.getNamespace();
        String name = this.ms.getName();
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.create(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindByNamespace() throws Exception {
        log.info((Object)(">>" + this.ms.getNamespace() + " " + this.ms.getName()));
        MetadataSchema found = MetadataSchema.findByNamespace((Context)this.context, (String)this.ms.getNamespace());
        Assert.assertThat((String)"testFindByNamespace 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFindByNamespace 1", (Object)found.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getSchemaID()));
    }

    @Test
    public void testUpdateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = true;
            }
        };
        String namespace = "namespace2";
        String name = "name2";
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.create(this.context);
        m.update(this.context);
        MetadataSchema found = MetadataSchema.findByNamespace((Context)this.context, (String)namespace);
        Assert.assertThat((String)"testUpdateAuth 0", (Object)found.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)m.getSchemaID()));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = false;
            }
        };
        String namespace = "namespace2";
        String name = "name2";
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.update(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test(expected=NonUniqueMetadataException.class)
    public void testUpdateRepeated() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = true;
            }
        };
        String namespace = this.ms.getNamespace();
        String name = this.ms.getName();
        MetadataSchema m = new MetadataSchema();
        m.create(this.context);
        m.setName(name);
        m.setNamespace(namespace);
        m.update(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testDeleteAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = true;
            }
        };
        String namespace = "namespace3";
        String name = "name3";
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.create(this.context);
        this.context.commit();
        m.delete(this.context);
        MetadataSchema found = MetadataSchema.findByNamespace((Context)this.context, (String)namespace);
        Assert.assertThat((String)"testDeleteAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.isAdmin((Context)MetadataSchemaTest.this.context);
                result = false;
            }
        };
        String namespace = "namespace3";
        String name = "name3";
        MetadataSchema m = new MetadataSchema();
        m.setName(name);
        m.setNamespace(namespace);
        m.create(this.context);
        this.context.commit();
        m.delete(this.context);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindAll() throws Exception {
        MetadataSchema[] found = MetadataSchema.findAll((Context)this.context);
        Assert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (found.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (MetadataSchema msc : found) {
            if (!msc.equals((Object)this.ms)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testFind_Context_int() throws Exception {
        int id = 1;
        MetadataSchema found = MetadataSchema.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testFind_Context_int 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind_Context_int 1", (Object)found.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getSchemaID()));
        Assert.assertThat((String)"testFind_Context_int 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getName()));
        Assert.assertThat((String)"testFind_Context_int 3", (Object)found.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getNamespace()));
    }

    @Test
    public void testFind_Context_String() throws Exception {
        String shortName = this.ms.getName();
        MetadataSchema found = MetadataSchema.find((Context)this.context, (String)shortName);
        Assert.assertThat((String)"testFind_Context_String 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind_Context_String 1", (Object)found.getSchemaID(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getSchemaID()));
        Assert.assertThat((String)"testFind_Context_String 2", (Object)found.getName(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getName()));
        Assert.assertThat((String)"testFind_Context_String 3", (Object)found.getNamespace(), (Matcher)CoreMatchers.equalTo((Object)this.ms.getNamespace()));
        found = MetadataSchema.find((Context)this.context, null);
        Assert.assertThat((String)"testFind_Context_String 4", (Object)found, (Matcher)CoreMatchers.nullValue());
    }
}

