/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.SupervisedItem;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.Supervisor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SupervisedItemTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(SupervisedItemTest.class);
    private SupervisedItem si;
    private Group gr;
    private WorkspaceItem wi;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            SupervisedItem[] found;
            this.context.turnOffAuthorisationSystem();
            Collection col = Collection.create((Context)this.context);
            this.wi = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)false);
            this.gr = Group.create((Context)this.context);
            this.gr.addMember(this.context.getCurrentUser());
            this.gr.update();
            Supervisor.add((Context)this.context, (int)this.gr.getID(), (int)this.wi.getID(), (int)1);
            for (SupervisedItem sia : found = SupervisedItem.getAll((Context)this.context)) {
                if (sia.getID() != this.wi.getID()) continue;
                this.si = sia;
            }
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in init", (Throwable)ex);
            Assert.fail((String)"IO Error in init");
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)"Authorization Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.si = null;
        this.wi = null;
        this.gr = null;
        super.destroy();
    }

    @Test
    public void testGetAll() throws Exception {
        SupervisedItem[] found = SupervisedItem.getAll((Context)this.context);
        Assert.assertThat((String)"testGetAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetAll 1", (found.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (SupervisedItem sia : found) {
            if (!sia.equals((Object)this.si)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testGetAll 2", (boolean)added);
    }

    @Test
    public void testGetSupervisorGroups_Context_int() throws Exception {
        Group[] found = this.si.getSupervisorGroups(this.context, this.wi.getID());
        Assert.assertThat((String)"testGetSupervisorGroups_Context_int 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSupervisorGroups_Context_int 1", (found.length == 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testGetSupervisorGroups_Context_int 2", (Object)found[0].getID(), (Matcher)CoreMatchers.equalTo((Object)this.gr.getID()));
    }

    @Test
    public void testGetSupervisorGroups_0args() throws Exception {
        Group[] found = this.si.getSupervisorGroups();
        Assert.assertThat((String)"testGetSupervisorGroups_0args 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetSupervisorGroups_0args 1", (found.length == 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Group g : found) {
            if (!g.equals((Object)this.gr)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testGetSupervisorGroups_0args 2", (boolean)added);
    }

    @Test
    public void testFindbyEPerson() throws Exception {
        this.context.turnOffAuthorisationSystem();
        SupervisedItem[] found = SupervisedItem.findbyEPerson((Context)this.context, (EPerson)EPerson.create((Context)this.context));
        Assert.assertThat((String)"testFindbyEPerson 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindbyEPerson 1", (found.length == 0 ? 1 : 0) != 0);
        found = SupervisedItem.findbyEPerson((Context)this.context, (EPerson)this.context.getCurrentUser());
        Assert.assertThat((String)"testFindbyEPerson 2", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindbyEPerson 3", (found.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (SupervisedItem sia : found) {
            if (!sia.equals((Object)this.si)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindbyEPerson 4", (boolean)added);
        this.context.restoreAuthSystemState();
    }
}

