/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import mockit.NonStrictExpectations;
import org.apache.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkspaceItemTest
extends AbstractUnitTest {
    private static final Logger log = Logger.getLogger(WorkspaceItemTest.class);
    private WorkspaceItem wi;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            Collection col = Collection.create((Context)this.context);
            this.wi = WorkspaceItem.create((Context)this.context, (Collection)col, (boolean)true);
            this.context.restoreAuthSystemState();
            this.context.commit();
        }
        catch (IOException ex) {
            log.error((Object)"IO Error in init", (Throwable)ex);
            Assert.fail((String)"IO Error in init");
        }
        catch (AuthorizeException ex) {
            log.error((Object)"Authorization Error in init", (Throwable)ex);
            Assert.fail((String)"Authorization Error in init");
        }
        catch (SQLException ex) {
            log.error((Object)"SQL Error in init", (Throwable)ex);
            Assert.fail((String)"SQL Error in init");
        }
    }

    @Override
    @After
    public void destroy() {
        this.wi = null;
        super.destroy();
    }

    @Test
    public void testFind() throws Exception {
        int id = this.wi.getID();
        WorkspaceItem found = WorkspaceItem.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testFind 1", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
        Assert.assertThat((String)"testFind 2", (Object)found, (Matcher)CoreMatchers.equalTo((Object)this.wi));
        Assert.assertThat((String)"testFind 3", (Object)found.getCollection(), (Matcher)CoreMatchers.equalTo((Object)this.wi.getCollection()));
    }

    @Test
    public void testCreateAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = null;
            }
        };
        Collection coll = null;
        boolean template = false;
        WorkspaceItem created = null;
        coll = Collection.create((Context)this.context);
        template = false;
        created = WorkspaceItem.create((Context)this.context, (Collection)coll, (boolean)template);
        Assert.assertThat((String)"testCreate 0", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreate 1", (created.getID() >= 0 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 2", (Object)created.getCollection(), (Matcher)CoreMatchers.equalTo((Object)coll));
        coll = Collection.create((Context)this.context);
        template = true;
        created = WorkspaceItem.create((Context)this.context, (Collection)coll, (boolean)template);
        Assert.assertThat((String)"testCreate 3", (Object)created, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testCreate 4", (created.getID() >= 0 ? 1 : 0) != 0);
        Assert.assertThat((String)"testCreate 5", (Object)created.getCollection(), (Matcher)CoreMatchers.equalTo((Object)coll));
    }

    @Test(expected=AuthorizeException.class)
    public void testCreateNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Collection)any), (int)3);
                result = new AuthorizeException();
            }
        };
        Collection coll = null;
        boolean template = false;
        WorkspaceItem created = null;
        coll = Collection.create((Context)this.context);
        template = false;
        created = WorkspaceItem.create((Context)this.context, (Collection)coll, (boolean)template);
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testFindByEPerson() throws Exception {
        EPerson ep = this.context.getCurrentUser();
        WorkspaceItem[] found = WorkspaceItem.findByEPerson((Context)this.context, (EPerson)ep);
        Assert.assertThat((String)"testFindByEPerson 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByEPerson 1", (found.length >= 1 ? 1 : 0) != 0);
        boolean exists = false;
        for (WorkspaceItem w : found) {
            if (!w.equals((Object)this.wi)) continue;
            exists = true;
        }
        Assert.assertTrue((String)"testFindByEPerson 2", (boolean)exists);
    }

    @Test
    public void testFindByCollection() throws Exception {
        Collection c = this.wi.getCollection();
        WorkspaceItem[] found = WorkspaceItem.findByCollection((Context)this.context, (Collection)c);
        Assert.assertThat((String)"testFindByCollection 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindByCollection 1", (found.length >= 1 ? 1 : 0) != 0);
        Assert.assertThat((String)"testFindByCollection 2", (Object)found[0].getID(), (Matcher)CoreMatchers.equalTo((Object)this.wi.getID()));
        Assert.assertThat((String)"testFindByCollection 3", (Object)found[0], (Matcher)CoreMatchers.equalTo((Object)this.wi));
        Assert.assertThat((String)"testFindByCollection 4", (Object)found[0].getCollection(), (Matcher)CoreMatchers.equalTo((Object)this.wi.getCollection()));
    }

    @Test
    public void testFindAll() throws Exception {
        WorkspaceItem[] found = WorkspaceItem.findAll((Context)this.context);
        Assert.assertTrue((String)"testFindAll 0", (found.length >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (WorkspaceItem f : found) {
            Assert.assertThat((String)"testFindAll 1", (Object)f, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testFindAll 2", (Object)f.getItem(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((String)"testFindAll 3", (Object)f.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
            if (!f.equals((Object)this.wi)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 4", (boolean)added);
    }

    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.wi.getID() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetStageReached() {
        Assert.assertTrue((String)"testGetStageReached 0", (this.wi.getStageReached() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSetStageReached() {
        this.wi.setStageReached(4);
        Assert.assertTrue((String)"testSetStageReached 0", (this.wi.getStageReached() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testGetPageReached() {
        Assert.assertTrue((String)"testGetPageReached 0", (this.wi.getPageReached() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSetPageReached() {
        this.wi.setPageReached(4);
        Assert.assertTrue((String)"testSetPageReached 0", (this.wi.getPageReached() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdate() throws Exception {
        this.wi.update();
        System.out.println("update");
    }

    @Test
    public void testDeleteAllAuth() throws Exception {
        int id = this.wi.getID();
        this.wi.deleteAll();
        WorkspaceItem found = WorkspaceItem.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testDeleteAllAuth 0", (Object)found, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testDeleteAllNoAuth() throws Exception {
        EPerson old = this.context.getCurrentUser();
        this.context.turnOffAuthorisationSystem();
        this.context.setCurrentUser(EPerson.create((Context)this.context));
        this.context.restoreAuthSystemState();
        try {
            this.wi.deleteAll();
            Assert.fail((String)"Exception expected");
        }
        catch (AuthorizeException ex) {
            this.context.setCurrentUser(old);
        }
    }

    @Test
    public void testDeleteWrapperAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = null;
            }
        };
        int itemid = this.wi.getItem().getID();
        int id = this.wi.getID();
        this.wi.deleteWrapper();
        Item found = Item.find((Context)this.context, (int)itemid);
        Assert.assertThat((String)"testDeleteWrapperAuth 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        WorkspaceItem wfound = WorkspaceItem.find((Context)this.context, (int)id);
        Assert.assertThat((String)"testDeleteWrapperAuth 1", (Object)wfound, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testDeleteWrapperNoAuth() throws Exception {
        new NonStrictExpectations(){
            AuthorizeManager authManager;
            {
                AuthorizeManager.authorizeAction((Context)((Context)any), (DSpaceObject)((Item)any), (int)1);
                result = new AuthorizeException();
            }
        };
        this.wi.deleteWrapper();
        Assert.fail((String)"Exception expected");
    }

    @Test
    public void testGetItem() {
        Assert.assertThat((String)"testGetItem 0", (Object)this.wi.getItem(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetCollection() {
        Assert.assertThat((String)"testGetCollection 0", (Object)this.wi.getCollection(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetSubmitter() throws Exception {
        Assert.assertThat((String)"testGetSubmitter 0", (Object)this.wi.getSubmitter(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"testGetSubmitter 1", (Object)this.wi.getSubmitter(), (Matcher)CoreMatchers.equalTo((Object)this.context.getCurrentUser()));
    }

    @Test
    public void testHasMultipleFiles() {
        Assert.assertFalse((String)"testHasMultipleFiles 0", (boolean)this.wi.hasMultipleFiles());
    }

    @Test
    public void testSetMultipleFiles() {
        this.wi.setMultipleFiles(true);
        Assert.assertTrue((String)"testSetMultipleFiles 0", (boolean)this.wi.hasMultipleFiles());
    }

    @Test
    public void testHasMultipleTitles() {
        Assert.assertFalse((String)"testHasMultipleTitles 0", (boolean)this.wi.hasMultipleTitles());
    }

    @Test
    public void testSetMultipleTitles() {
        this.wi.setMultipleTitles(true);
        Assert.assertTrue((String)"testSetMultipleTitles 0", (boolean)this.wi.hasMultipleTitles());
    }

    @Test
    public void testIsPublishedBefore() {
        Assert.assertFalse((String)"testIsPublishedBefore 0", (boolean)this.wi.isPublishedBefore());
    }

    @Test
    public void testSetPublishedBefore() {
        this.wi.setPublishedBefore(true);
        Assert.assertTrue((String)"testSetPublishedBefore 0", (boolean)this.wi.isPublishedBefore());
    }
}

