/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.PasswordHash;
import org.jdom.Namespace;

public class RoleDisseminator
implements PackageDisseminator {
    private static final Logger log = Logger.getLogger(RoleDisseminator.class);
    public static final Namespace DSROLES_NS = Namespace.getNamespace((String)"dsroles", (String)"http://www.dspace.org/xmlns/dspace/dspace-roles");
    public static final String DSPACE_ROLES = "DSpaceRoles";
    public static final String ID = "ID";
    public static final String GROUPS = "Groups";
    public static final String GROUP = "Group";
    public static final String NAME = "Name";
    public static final String TYPE = "Type";
    public static final String MEMBERS = "Members";
    public static final String MEMBER = "Member";
    public static final String MEMBER_GROUPS = "MemberGroups";
    public static final String MEMBER_GROUP = "MemberGroup";
    public static final String EPERSONS = "People";
    public static final String EPERSON = "Person";
    public static final String EMAIL = "Email";
    public static final String NETID = "Netid";
    public static final String FIRST_NAME = "FirstName";
    public static final String LAST_NAME = "LastName";
    public static final String LANGUAGE = "Language";
    public static final String PASSWORD_HASH = "PasswordHash";
    public static final String PASSWORD_DIGEST = "digest";
    public static final String PASSWORD_SALT = "salt";
    public static final String CAN_LOGIN = "CanLogin";
    public static final String REQUIRE_CERTIFICATE = "RequireCertificate";
    public static final String SELF_REGISTERED = "SelfRegistered";
    public static final String GROUP_TYPE_ADMIN = "ADMIN";
    public static final String GROUP_TYPE_SUBMIT = "SUBMIT";
    public static final String GROUP_TYPE_WORKFLOW_STEP_1 = "WORKFLOW_STEP_1";
    public static final String GROUP_TYPE_WORKFLOW_STEP_2 = "WORKFLOW_STEP_2";
    public static final String GROUP_TYPE_WORKFLOW_STEP_3 = "WORKFLOW_STEP_3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disseminate(Context context, DSpaceObject object, PackageParameters params, File pkgFile) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        boolean emitPasswords = params.containsKey("passwords");
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(pkgFile);
            this.writeToStream(context, object, fileOut, emitPasswords);
        }
        finally {
            if (fileOut != null) {
                fileOut.close();
            }
        }
    }

    InputStream asStream(Context context, DSpaceObject object, boolean emitPasswords) throws IOException {
        PipedOutputStream outStream = new PipedOutputStream();
        PipedInputStream inStream = new PipedInputStream(outStream);
        Serializer serializer = new Serializer(context, object, outStream, emitPasswords);
        new Thread(serializer).start();
        return inStream;
    }

    private void writeToStream(Context context, DSpaceObject object, OutputStream stream, boolean emitPasswords) throws PackageException {
        try {
            Group[] groups = this.findAssociatedGroups(context, object);
            EPerson[] people = this.findAssociatedPeople(context, object);
            if (groups != null && groups.length > 0 || people != null && people.length > 0) {
                XMLOutputFactory factory = XMLOutputFactory.newInstance();
                XMLStreamWriter writer = factory.createXMLStreamWriter(stream, "UTF-8");
                writer.setDefaultNamespace(DSROLES_NS.getURI());
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement(DSPACE_ROLES);
                if (groups != null) {
                    writer.writeStartElement(GROUPS);
                    for (DSpaceObject dSpaceObject : groups) {
                        this.writeGroup(context, object, (Group)dSpaceObject, writer);
                    }
                    writer.writeEndElement();
                }
                if (people != null) {
                    writer.writeStartElement(EPERSONS);
                    for (DSpaceObject dSpaceObject : people) {
                        this.writeEPerson((EPerson)dSpaceObject, writer, emitPasswords);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.close();
            }
        }
        catch (Exception e) {
            throw new PackageException(e);
        }
    }

    @Override
    public List<File> disseminateAll(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new PackageException("disseminateAll() is not implemented, as disseminate() method already handles dissemination of all roles to an external file.");
    }

    @Override
    public String getMIMEType(PackageParameters params) {
        return "application/xml";
    }

    private void writeGroup(Context context, DSpaceObject relatedObject, Group group, XMLStreamWriter writer) throws XMLStreamException, PackageException {
        String exportGroupName = PackageUtils.translateGroupNameForExport(context, group.getName());
        if (exportGroupName == null) {
            return;
        }
        writer.writeStartElement(GROUP);
        writer.writeAttribute(ID, String.valueOf(group.getID()));
        writer.writeAttribute(NAME, exportGroupName);
        String groupType = this.getGroupType(relatedObject, group);
        if (groupType != null && !groupType.isEmpty()) {
            writer.writeAttribute(TYPE, groupType);
        }
        if (group.getMembers().length > 0) {
            writer.writeStartElement(MEMBERS);
            for (DSpaceObject dSpaceObject : group.getMembers()) {
                writer.writeEmptyElement(MEMBER);
                writer.writeAttribute(ID, String.valueOf(((EPerson)dSpaceObject).getID()));
                writer.writeAttribute(NAME, ((EPerson)dSpaceObject).getName());
            }
            writer.writeEndElement();
        }
        if (group.getMemberGroups().length > 0) {
            writer.writeStartElement(MEMBER_GROUPS);
            for (DSpaceObject dSpaceObject : group.getMemberGroups()) {
                String exportMemberName = PackageUtils.translateGroupNameForExport(context, ((Group)dSpaceObject).getName());
                if (exportMemberName == null) continue;
                writer.writeEmptyElement(MEMBER_GROUP);
                writer.writeAttribute(ID, String.valueOf(((Group)dSpaceObject).getID()));
                writer.writeAttribute(NAME, exportMemberName);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private String getGroupType(DSpaceObject dso, Group group) {
        if (dso == null || group == null) {
            return null;
        }
        if (dso.getType() == 4) {
            Community community = (Community)dso;
            if (group.equals(community.getAdministrators())) {
                return GROUP_TYPE_ADMIN;
            }
        } else if (dso.getType() == 3) {
            Collection collection = (Collection)dso;
            if (group.equals(collection.getAdministrators())) {
                return GROUP_TYPE_ADMIN;
            }
            if (group.equals(collection.getSubmitters())) {
                return GROUP_TYPE_SUBMIT;
            }
            if (group.equals(collection.getWorkflowGroup(1))) {
                return GROUP_TYPE_WORKFLOW_STEP_1;
            }
            if (group.equals(collection.getWorkflowGroup(2))) {
                return GROUP_TYPE_WORKFLOW_STEP_2;
            }
            if (group.equals(collection.getWorkflowGroup(3))) {
                return GROUP_TYPE_WORKFLOW_STEP_3;
            }
        }
        return null;
    }

    private void writeEPerson(EPerson eperson, XMLStreamWriter writer, boolean emitPassword) throws XMLStreamException {
        writer.writeStartElement(EPERSON);
        writer.writeAttribute(ID, String.valueOf(eperson.getID()));
        writer.writeStartElement(EMAIL);
        writer.writeCharacters(eperson.getEmail());
        writer.writeEndElement();
        if (eperson.getNetid() != null) {
            writer.writeStartElement(NETID);
            writer.writeCharacters(eperson.getNetid());
            writer.writeEndElement();
        }
        if (eperson.getFirstName() != null) {
            writer.writeStartElement(FIRST_NAME);
            writer.writeCharacters(eperson.getFirstName());
            writer.writeEndElement();
        }
        if (eperson.getLastName() != null) {
            writer.writeStartElement(LAST_NAME);
            writer.writeCharacters(eperson.getLastName());
            writer.writeEndElement();
        }
        if (eperson.getLanguage() != null) {
            writer.writeStartElement(LANGUAGE);
            writer.writeCharacters(eperson.getLanguage());
            writer.writeEndElement();
        }
        if (emitPassword) {
            String salt;
            PasswordHash password = eperson.getPasswordHash();
            writer.writeStartElement(PASSWORD_HASH);
            String algorithm = password.getAlgorithm();
            if (null != algorithm) {
                writer.writeAttribute(PASSWORD_DIGEST, algorithm);
            }
            if (null != (salt = password.getSaltString())) {
                writer.writeAttribute(PASSWORD_SALT, salt);
            }
            writer.writeCharacters(password.getHashString());
            writer.writeEndElement();
        }
        if (eperson.canLogIn()) {
            writer.writeEmptyElement(CAN_LOGIN);
        }
        if (eperson.getRequireCertificate()) {
            writer.writeEmptyElement(REQUIRE_CERTIFICATE);
        }
        if (eperson.getSelfRegistered()) {
            writer.writeEmptyElement(SELF_REGISTERED);
        }
        writer.writeEndElement();
    }

    private Group[] findAssociatedGroups(Context context, DSpaceObject object) throws SQLException {
        if (object.getType() == 5) {
            return Group.findAll(context, 1);
        }
        if (object.getType() == 4) {
            Group[] matchingGroups;
            Community community = (Community)object;
            ArrayList<Group> list = new ArrayList<Group>();
            if (community.getAdministrators() != null) {
                list.add(community.getAdministrators());
            }
            for (Group g : matchingGroups = Group.search(context, "COMMUNITY\\_" + community.getID() + "\\_")) {
                if (list.contains(g)) continue;
                list.add(g);
            }
            if (list.size() > 0) {
                Group[] groupArray = new Group[list.size()];
                groupArray = list.toArray(groupArray);
                return groupArray;
            }
        } else if (object.getType() == 3) {
            Group[] matchingGroups;
            Collection collection = (Collection)object;
            ArrayList<Group> list = new ArrayList<Group>();
            if (collection.getAdministrators() != null) {
                list.add(collection.getAdministrators());
            }
            if (collection.getSubmitters() != null) {
                list.add(collection.getSubmitters());
            }
            if (collection.getWorkflowGroup(1) != null) {
                list.add(collection.getWorkflowGroup(1));
            }
            if (collection.getWorkflowGroup(2) != null) {
                list.add(collection.getWorkflowGroup(2));
            }
            if (collection.getWorkflowGroup(3) != null) {
                list.add(collection.getWorkflowGroup(3));
            }
            for (Group g : matchingGroups = Group.search(context, "COLLECTION\\_" + collection.getID() + "\\_")) {
                if (list.contains(g)) continue;
                list.add(g);
            }
            if (list.size() > 0) {
                Group[] groupArray = new Group[list.size()];
                groupArray = list.toArray(groupArray);
                return groupArray;
            }
        }
        return null;
    }

    private EPerson[] findAssociatedPeople(Context context, DSpaceObject object) throws SQLException {
        if (object.getType() == 5) {
            return EPerson.findAll(context, 1);
        }
        return null;
    }

    @Override
    public String getParameterHelp() {
        return "* passwords=[boolean]      If true, user password hashes are also exported (so that they can be later restored).  If false, user passwords are not exported. (Default is false)";
    }

    private class Serializer
    implements Runnable {
        private Context context;
        private DSpaceObject object;
        private OutputStream stream;
        private boolean emitPasswords;

        private Serializer() {
        }

        Serializer(Context context, DSpaceObject object, OutputStream stream, boolean emitPasswords) {
            this.context = context;
            this.object = object;
            this.stream = stream;
            this.emitPasswords = emitPasswords;
        }

        @Override
        public void run() {
            try {
                RoleDisseminator.this.writeToStream(this.context, this.object, this.stream, this.emitPasswords);
                this.stream.close();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            catch (PackageException e) {
                log.error((Object)e);
            }
        }
    }
}

