/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery.configuration;

import java.util.List;
import java.util.Map;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryRecentSubmissionsConfiguration;
import org.dspace.discovery.configuration.DiscoverySearchFilter;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.utils.DSpace;

public class DiscoveryConfigurationService {
    private Map<String, DiscoveryConfiguration> map;

    public Map<String, DiscoveryConfiguration> getMap() {
        return this.map;
    }

    public void setMap(Map<String, DiscoveryConfiguration> map) {
        this.map = map;
    }

    public static void main(String[] args) {
        DSpace dspace = new DSpace();
        System.out.println(dspace.getServiceManager().getServicesNames().size());
        DiscoveryConfigurationService mainService = (DiscoveryConfigurationService)dspace.getServiceManager().getServiceByName(DiscoveryConfigurationService.class.getName(), DiscoveryConfigurationService.class);
        for (String key : mainService.getMap().keySet()) {
            System.out.println(key);
            System.out.println("Facets:");
            DiscoveryConfiguration discoveryConfiguration = mainService.getMap().get(key);
            for (int i = 0; i < discoveryConfiguration.getSidebarFacets().size(); ++i) {
                DiscoverySearchFilterFacet sidebarFacet = discoveryConfiguration.getSidebarFacets().get(i);
                System.out.println("\t" + sidebarFacet.getIndexFieldName());
                for (int j = 0; j < sidebarFacet.getMetadataFields().size(); ++j) {
                    String metadataField = sidebarFacet.getMetadataFields().get(j);
                    System.out.println("\t\t" + metadataField);
                }
            }
            System.out.println("Search filters");
            List<DiscoverySearchFilter> searchFilters = discoveryConfiguration.getSearchFilters();
            for (DiscoverySearchFilter searchFilter : searchFilters) {
                for (int i = 0; i < searchFilter.getMetadataFields().size(); ++i) {
                    String metadataField = searchFilter.getMetadataFields().get(i);
                    System.out.println("\t\t" + metadataField);
                }
            }
            System.out.println("Recent submissions configuration:");
            DiscoveryRecentSubmissionsConfiguration recentSubmissionConfiguration = discoveryConfiguration.getRecentSubmissionConfiguration();
            System.out.println("\tMetadata sort field: " + recentSubmissionConfiguration.getMetadataSortField());
            System.out.println("\tMax recent submissions: " + recentSubmissionConfiguration.getMax());
            List<String> defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries();
            if (0 >= defaultFilterQueries.size()) continue;
            System.out.println("Default filter queries");
            for (String fq : defaultFilterQueries) {
                System.out.println("\t" + fq);
            }
        }
    }
}

