/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class HandleManager {
    private static Logger log = Logger.getLogger(HandleManager.class);
    static final String EXAMPLE_PREFIX = "123456789";

    private HandleManager() {
    }

    public static String resolveToURL(Context context, String handle) throws SQLException {
        TableRow dbhandle = HandleManager.findHandleInternal(context, handle);
        if (dbhandle == null) {
            return null;
        }
        String url = ConfigurationManager.getProperty("dspace.url") + "/handle/" + handle;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved " + handle + " to " + url));
        }
        return url;
    }

    public static String getCanonicalForm(String handle) {
        String handlePrefix = ConfigurationManager.getProperty("handle.canonical.prefix");
        if (handlePrefix == null || handlePrefix.length() == 0) {
            handlePrefix = "http://hdl.handle.net/";
        }
        return handlePrefix + handle;
    }

    public static String createHandle(Context context, DSpaceObject dso) throws SQLException {
        TableRow handle = DatabaseManager.create(context, "Handle");
        String handleId = HandleManager.createId(handle.getIntColumn("handle_id"));
        handle.setColumn("handle", handleId);
        handle.setColumn("resource_type_id", dso.getType());
        handle.setColumn("resource_id", dso.getID());
        DatabaseManager.update(context, handle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new handle for " + Constants.typeText[dso.getType()] + " (ID=" + dso.getID() + ") " + handleId));
        }
        return handleId;
    }

    public static String createHandle(Context context, DSpaceObject dso, String suppliedHandle) throws SQLException, IllegalStateException {
        TableRow handle = HandleManager.findHandleInternal(context, suppliedHandle);
        if (handle != null && !handle.isColumnNull("resource_id")) {
            if (handle.getIntColumn("resource_id") == dso.getID() && handle.getIntColumn("resource_type_id") == dso.getType()) {
                return suppliedHandle;
            }
            throw new IllegalStateException("Attempted to create a handle which is already in use: " + suppliedHandle);
        }
        if (handle != null && !handle.isColumnNull("resource_type_id")) {
            int previousType = handle.getIntColumn("resource_type_id");
            if (previousType != dso.getType()) {
                throw new IllegalStateException("Attempted to reuse a handle previously used by a " + Constants.typeText[previousType] + " for a new " + Constants.typeText[dso.getType()]);
            }
        } else if (handle == null) {
            handle = DatabaseManager.create(context, "Handle");
            handle.setColumn("handle", suppliedHandle);
        }
        handle.setColumn("resource_type_id", dso.getType());
        handle.setColumn("resource_id", dso.getID());
        DatabaseManager.update(context, handle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new handle for " + Constants.typeText[dso.getType()] + " (ID=" + dso.getID() + ") " + suppliedHandle));
        }
        return suppliedHandle;
    }

    public static void unbindHandle(Context context, DSpaceObject dso) throws SQLException {
        TableRowIterator rows = HandleManager.getInternalHandles(context, dso.getType(), dso.getID());
        if (rows != null) {
            while (rows.hasNext()) {
                TableRow row = rows.next();
                row.setColumnNull("resource_id");
                DatabaseManager.update(context, row);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unbound Handle " + row.getStringColumn("handle") + " from object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
            }
        } else {
            log.warn((Object)("Cannot find Handle entry to unbind for object " + Constants.typeText[dso.getType()] + " id=" + dso.getID()));
        }
    }

    public static DSpaceObject resolveToObject(Context context, String handle) throws IllegalStateException, SQLException {
        TableRow dbhandle = HandleManager.findHandleInternal(context, handle);
        if (dbhandle == null) {
            if (handle.equals(Site.getSiteHandle())) {
                return Site.find(context, 0);
            }
            return null;
        }
        if (dbhandle.isColumnNull("resource_type_id") || dbhandle.isColumnNull("resource_id")) {
            return null;
        }
        int handletypeid = dbhandle.getIntColumn("resource_type_id");
        int resourceID = dbhandle.getIntColumn("resource_id");
        if (handletypeid == 2) {
            Item item = Item.find(context, resourceID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved handle " + handle + " to item " + (item == null ? -1 : item.getID())));
            }
            return item;
        }
        if (handletypeid == 3) {
            Collection collection = Collection.find(context, resourceID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved handle " + handle + " to collection " + (collection == null ? -1 : collection.getID())));
            }
            return collection;
        }
        if (handletypeid == 4) {
            Community community = Community.find(context, resourceID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved handle " + handle + " to community " + (community == null ? -1 : community.getID())));
            }
            return community;
        }
        throw new IllegalStateException("Unsupported Handle Type " + Constants.typeText[handletypeid]);
    }

    public static String findHandle(Context context, DSpaceObject dso) throws SQLException {
        TableRowIterator rows = HandleManager.getInternalHandles(context, dso.getType(), dso.getID());
        if (rows == null || !rows.hasNext()) {
            if (dso.getType() == 5) {
                return Site.getSiteHandle();
            }
            return null;
        }
        String result = rows.next().getStringColumn("handle");
        while (rows.hasNext()) {
            TableRow row = rows.next();
            if (row.getStringColumn("handle").matches(".*/.*\\.\\d+")) continue;
            result = row.getStringColumn("handle");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> getHandlesForPrefix(Context context, String prefix) throws SQLException {
        String sql = "SELECT handle FROM handle WHERE handle LIKE ? ";
        TableRowIterator iterator = DatabaseManager.queryTable(context, null, sql, prefix + "%");
        ArrayList<String> results = new ArrayList<String>();
        try {
            while (iterator.hasNext()) {
                TableRow row = iterator.next();
                results.add(row.getStringColumn("handle"));
            }
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return results;
    }

    public static String getPrefix() {
        String prefix = ConfigurationManager.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error((Object)("handle.prefix is not configured; using " + prefix));
        }
        return prefix;
    }

    private static TableRowIterator getInternalHandles(Context context, int type, int id) throws SQLException {
        String sql = "SELECT * FROM Handle WHERE resource_type_id = ? AND resource_id = ?";
        return DatabaseManager.queryTable(context, "Handle", sql, type, id);
    }

    private static TableRow findHandleInternal(Context context, String handle) throws SQLException {
        if (handle == null) {
            throw new IllegalArgumentException("Handle is null");
        }
        return DatabaseManager.findByUnique(context, "Handle", "handle", handle);
    }

    private static String createId(int id) throws SQLException {
        String handlePrefix = HandleManager.getPrefix();
        return new StringBuffer().append(handlePrefix).append(handlePrefix.endsWith("/") ? "" : "/").append(id).toString();
    }
}

