/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.statistics.SolrLogger;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;

public class StatisticsImporter {
    private static final Logger log = Logger.getLogger(StatisticsImporter.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static CommonsHttpSolrServer solr;
    private static LookupService geoipLookup;
    private static Map<String, String> metadataStorageInfo;
    private static boolean skipReverseDNS;
    private List<Integer> localItems;
    private List<Integer> localCollections;
    private List<Integer> localCommunities;
    private List<Integer> localBitstreams;
    private boolean useLocal;

    public StatisticsImporter(boolean local) {
        this.useLocal = local;
        if (local) {
            try {
                System.out.print("Loading local communities... ");
                Context c = new Context();
                Community[] communities = Community.findAll(c);
                this.localCommunities = new ArrayList<Integer>();
                for (Community community : communities) {
                    this.localCommunities.add(community.getID());
                }
                System.out.println("Found " + this.localCommunities.size());
                System.out.print("Loading local collections... ");
                Collection[] collections = Collection.findAll(c);
                this.localCollections = new ArrayList<Integer>();
                for (Collection collection : collections) {
                    this.localCollections.add(collection.getID());
                }
                System.out.println("Found " + this.localCollections.size());
                System.out.print("Loading local items... ");
                ItemIterator items = Item.findAll(c);
                this.localItems = new ArrayList<Integer>();
                while (items.hasNext()) {
                    Item i = items.next();
                    this.localItems.add(i.getID());
                }
                System.out.println("Found " + this.localItems.size());
                System.out.print("Loading local bitstreams... ");
                Bitstream[] bitstreams = Bitstream.findAll(c);
                this.localBitstreams = new ArrayList<Integer>();
                for (Bitstream bitstream : bitstreams) {
                    if (bitstream.getName() == null) continue;
                    this.localBitstreams.add(bitstream.getID());
                }
                System.out.println("Found " + this.localBitstreams.size());
            }
            catch (Exception e) {
                System.err.println("Error retrieving items from DSpace database:");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void load(String filename, Context context, boolean verbose) {
        int counter = 0;
        int errors = 0;
        int searchengines = 0;
        try {
            String line;
            BufferedReader input;
            if (null == filename || "-".equals(filename)) {
                input = new BufferedReader(new InputStreamReader(System.in));
                filename = "standard input";
            } else {
                input = new BufferedReader(new FileReader(new File(filename)));
            }
            System.out.println("Processing file: " + filename);
            String continent = "";
            String country = "";
            String countryCode = "";
            float longitude = 0.0f;
            float latitude = 0.0f;
            String city = "";
            DNSCache<String, String> dnsCache = new DNSCache<String, String>(2500, 0.75f, 2500);
            Random rand = new Random();
            while ((line = input.readLine()) != null) {
                DSpaceObject dso;
                String data = "";
                ++counter;
                ++errors;
                if (verbose) {
                    System.out.println("Line:" + line);
                }
                String[] parts = line.split(",");
                String action = parts[1];
                String id = parts[2];
                Date date = dateFormat.parse(parts[3]);
                String user = parts[4];
                String ip = parts[5];
                String dns = "";
                if (!skipReverseDNS) {
                    Object fromCache = dnsCache.get(ip);
                    if (fromCache != null) {
                        dns = (String)fromCache;
                    } else {
                        try {
                            dns = DnsLookup.reverseDns(ip);
                            dnsCache.put(ip, dns);
                        }
                        catch (Exception e) {
                            dns = "";
                        }
                    }
                }
                data = data + "ip addr = " + ip;
                data = data + ", dns name = " + dns;
                if (dns.endsWith(".googlebot.com.") || dns.endsWith(".crawl.yahoo.net.") || dns.endsWith(".search.msn.com.")) {
                    if (verbose) {
                        System.out.println(data + ", IGNORE (search engine)");
                    }
                    --errors;
                    ++searchengines;
                    continue;
                }
                try {
                    Location location = geoipLookup.getLocation(ip);
                    city = location.city;
                    country = location.countryName;
                    countryCode = location.countryCode;
                    longitude = location.longitude;
                    latitude = location.latitude;
                    if (verbose) {
                        data = data + ", country = " + country;
                        data = data + ", city = " + city;
                        System.out.println(data);
                    }
                    try {
                        continent = LocationUtils.getContinentCode(countryCode);
                    }
                    catch (Exception e) {
                        if (!verbose) continue;
                        System.out.println("Unknown country code: " + countryCode);
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int type = 0;
                if ("view_bitstream".equals(action)) {
                    type = 0;
                    if (this.useLocal) {
                        id = "" + this.localBitstreams.get(rand.nextInt(this.localBitstreams.size()));
                    }
                } else if ("view_item".equals(action)) {
                    type = 2;
                    if (this.useLocal) {
                        id = "" + this.localItems.get(rand.nextInt(this.localItems.size()));
                    }
                } else if ("view_collection".equals(action)) {
                    type = 3;
                    if (this.useLocal) {
                        id = "" + this.localCollections.get(rand.nextInt(this.localCollections.size()));
                    }
                } else if ("view_community".equals(action)) {
                    type = 4;
                    if (this.useLocal) {
                        id = "" + this.localCommunities.get(rand.nextInt(this.localCommunities.size()));
                    }
                }
                if ((dso = DSpaceObject.find(context, type, Integer.parseInt(id))) == null) {
                    if (!verbose) continue;
                    System.err.println(" - DSO with ID '" + id + "' is no longer in the system");
                    continue;
                }
                EPerson eperson = EPerson.findByEmail(context, user);
                int epersonId = 0;
                if (eperson != null) {
                    eperson.getID();
                }
                SolrInputDocument sid = new SolrInputDocument();
                sid.addField("ip", (Object)ip);
                sid.addField("type", (Object)dso.getType());
                sid.addField("id", (Object)dso.getID());
                sid.addField("time", (Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
                sid.addField("continent", (Object)continent);
                sid.addField("country", (Object)country);
                sid.addField("countryCode", (Object)countryCode);
                sid.addField("city", (Object)city);
                sid.addField("latitude", (Object)Float.valueOf(latitude));
                sid.addField("longitude", (Object)Float.valueOf(longitude));
                if (epersonId > 0) {
                    sid.addField("epersonid", (Object)epersonId);
                }
                if (dns != null) {
                    sid.addField("dns", (Object)dns.toLowerCase());
                }
                if (dso instanceof Item) {
                    Item item = (Item)dso;
                    for (String storedField : metadataStorageInfo.keySet()) {
                        DCValue[] vals;
                        String dcField = metadataStorageInfo.get(storedField);
                        for (DCValue val1 : vals = item.getMetadata(dcField.split("\\.")[0], dcField.split("\\.")[1], dcField.split("\\.")[2], "*")) {
                            String val = val1.value;
                            sid.addField(String.valueOf(storedField), (Object)val);
                            sid.addField(String.valueOf(storedField + "_search"), (Object)val.toLowerCase());
                        }
                    }
                }
                SolrLogger.storeParents(sid, dso);
                solr.add(sid);
                --errors;
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        DecimalFormat percentage = new DecimalFormat("##.###");
        int committed = counter - errors - searchengines;
        System.out.println("Processed " + counter + " log lines");
        if (counter > 0) {
            Double committedpercentage = 100.0 * (double)committed / (double)counter;
            System.out.println(" - " + committed + " entries added to solr: " + percentage.format(committedpercentage) + "%");
            Double errorpercentage = 100.0 * (double)errors / (double)counter;
            System.out.println(" - " + errors + " errors: " + percentage.format(errorpercentage) + "%");
            Double sepercentage = 100.0 * (double)searchengines / (double)counter;
            System.out.println(" - " + searchengines + " search engine activity skipped: " + percentage.format(sepercentage) + "%");
            System.out.print("About to commit data to solr...");
            try {
                solr.commit();
            }
            catch (SolrServerException sse) {
                System.err.println("Error committing statistics to solr server!");
                sse.printStackTrace();
                System.exit(1);
            }
            catch (IOException ioe) {
                System.err.println("Error writing to solr server!");
                ioe.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println(" done!");
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("StatisticsImporter\n", options);
        System.exit(exitCode);
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "in", true, "the input file ('-' or omit for standard input)");
        options.addOption("l", "local", false, "developers tool - map external log file to local handles");
        options.addOption("m", "multiple", false, "treat the input file as having a wildcard ending");
        options.addOption("s", "skipdns", false, "skip performing reverse DNS lookups on IP addresses");
        options.addOption("v", "verbose", false, "display verbose output (useful for debugging)");
        options.addOption("h", "help", false, "help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            StatisticsImporter.printHelp(options, 0);
        }
        if (line.hasOption('s')) {
            skipReverseDNS = true;
        }
        boolean local = line.hasOption('l');
        Context context = new Context();
        boolean verbose = line.hasOption('v');
        String sserver = ConfigurationManager.getProperty("solr-statistics", "server");
        if (verbose) {
            System.out.println("Writing to solr server at: " + sserver);
        }
        solr = new CommonsHttpSolrServer(sserver);
        metadataStorageInfo = SolrLogger.getMetadataStorageInfo();
        String dbfile = ConfigurationManager.getProperty("usage-statistics", "dbfile");
        try {
            geoipLookup = new LookupService(dbfile, 0);
        }
        catch (FileNotFoundException fe) {
            log.error((Object)("The GeoLite Database file is missing (" + dbfile + ")! Solr Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file."), (Throwable)fe);
        }
        catch (IOException e) {
            log.error((Object)("Unable to load GeoLite Database file (" + dbfile + ")! You may need to reinstall it. See the DSpace installation instructions for more details."), (Throwable)e);
        }
        StatisticsImporter si = new StatisticsImporter(local);
        if (line.hasOption('m')) {
            String[] children;
            final File sample = new File(line.getOptionValue('i'));
            File dir = sample.getParentFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(sample.getName());
                }
            };
            for (String in : children = dir.list(filter)) {
                System.out.println(in);
                si.load(dir.getAbsolutePath() + System.getProperty("file.separator") + in, context, verbose);
            }
        } else {
            si.load(line.getOptionValue('i'), context, verbose);
        }
    }

    static {
        skipReverseDNS = false;
    }

    static class DNSCache<K, V>
    extends LinkedHashMap<K, V> {
        private int maxCapacity;

        public DNSCache(int initialCapacity, float loadFactor, int maxCapacity) {
            super(initialCapacity, loadFactor, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() >= this.maxCapacity;
        }
    }
}

