/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.ItemIterator;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierService;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.utils.DSpace;
import org.dspace.versioning.VersioningService;

public class Item
extends DSpaceObject {
    public static final String ANY = "*";
    private static final Logger log = Logger.getLogger(Item.class);
    private Context ourContext;
    private TableRow itemRow;
    private EPerson submitter;
    private List<Bundle> bundles;
    MetadataCache dublinCore = new MetadataCache();
    private String handle;
    private boolean dublinCoreChanged;
    private boolean modified;
    private transient MetadataField[] allMetadataFields = null;

    Item(Context context, TableRow row) throws SQLException {
        this.ourContext = context;
        this.itemRow = row;
        this.dublinCoreChanged = false;
        this.modified = false;
        this.clearDetails();
        this.handle = HandleManager.findHandle(context, this);
        context.cache(this, row.getIntColumn("item_id"));
    }

    private TableRowIterator retrieveMetadata() throws SQLException {
        return DatabaseManager.queryTable(this.ourContext, "MetadataValue", "SELECT * FROM MetadataValue WHERE item_id= ? ORDER BY metadata_field_id, place", this.itemRow.getIntColumn("item_id"));
    }

    public static Item find(Context context, int id) throws SQLException {
        Item fromCache = (Item)context.fromCache(Item.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "item", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_item", "not_found,item_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_item", "item_id=" + id));
        }
        return new Item(context, row);
    }

    static Item create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "item");
        Item i = new Item(context, row);
        i.setDiscoverable(true);
        context.turnOffAuthorisationSystem();
        i.update();
        context.restoreAuthSystemState();
        context.addEvent(new Event(1, 2, i.getID(), null));
        log.info((Object)LogManager.getHeader(context, "create_item", "item_id=" + row.getIntColumn("item_id")));
        return i;
    }

    public static ItemIterator findAll(Context context) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1'";
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findAllUnfiltered(Context context) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1' or withdrawn='1'";
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    public static ItemIterator findBySubmitter(Context context, EPerson eperson) throws SQLException {
        String myQuery = "SELECT * FROM item WHERE in_archive='1' AND submitter_id=" + eperson.getID();
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", myQuery, new Object[0]);
        return new ItemIterator(context, rows);
    }

    @Override
    public int getID() {
        return this.itemRow.getIntColumn("item_id");
    }

    @Override
    public String getHandle() {
        if (this.handle == null) {
            try {
                this.handle = HandleManager.findHandle(this.ourContext, this);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.handle;
    }

    public boolean isArchived() {
        return this.itemRow.getBooleanColumn("in_archive");
    }

    public boolean isWithdrawn() {
        return this.itemRow.getBooleanColumn("withdrawn");
    }

    public boolean isDiscoverable() {
        return this.itemRow.getBooleanColumn("discoverable");
    }

    public Date getLastModified() {
        Date myDate = this.itemRow.getDateColumn("last_modified");
        if (myDate == null) {
            myDate = new Date();
        }
        return myDate;
    }

    @Override
    public void updateLastModified() {
        try {
            Timestamp lastModified = new Timestamp(new Date().getTime());
            this.itemRow.setColumn("last_modified", lastModified);
            DatabaseManager.updateQuery(this.ourContext, "UPDATE item SET last_modified = ? WHERE item_id= ? ", lastModified, this.getID());
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null));
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(this.ourContext, "Error while updating last modified timestamp", "Item: " + this.getID()));
        }
    }

    public void setArchived(boolean isArchived) {
        this.itemRow.setColumn("in_archive", isArchived);
        this.modified = true;
    }

    public void setDiscoverable(boolean discoverable) {
        this.itemRow.setColumn("discoverable", discoverable);
        this.modified = true;
    }

    public void setOwningCollection(Collection c) {
        this.itemRow.setColumn("owning_collection", c.getID());
        this.modified = true;
    }

    public Collection getOwningCollection() throws SQLException {
        Collection myCollection = null;
        int cid = this.itemRow.getIntColumn("owning_collection");
        myCollection = Collection.find(this.ourContext, cid);
        return myCollection;
    }

    private int getOwningCollectionID() {
        return this.itemRow.getIntColumn("owning_collection");
    }

    @Deprecated
    public DCValue[] getDC(String element, String qualifier, String lang) {
        return this.getMetadata("dc", element, qualifier, lang);
    }

    public DCValue[] getMetadata(String schema, String element, String qualifier, String lang) {
        ArrayList<DCValue> values = new ArrayList<DCValue>();
        for (DCValue dcv : this.getMetadata()) {
            if (!this.match(schema, element, qualifier, lang, dcv)) continue;
            DCValue copy = new DCValue();
            copy.element = dcv.element;
            copy.qualifier = dcv.qualifier;
            copy.value = dcv.value;
            copy.language = dcv.language;
            copy.schema = dcv.schema;
            copy.authority = dcv.authority;
            copy.confidence = dcv.confidence;
            values.add(copy);
        }
        DCValue[] valueArray = new DCValue[values.size()];
        valueArray = values.toArray(valueArray);
        return valueArray;
    }

    public DCValue[] getMetadata(String mdString) {
        StringTokenizer dcf = new StringTokenizer(mdString, ".");
        String[] tokens = new String[]{"", "", ""};
        int i = 0;
        while (dcf.hasMoreTokens()) {
            tokens[i] = dcf.nextToken().trim();
            ++i;
        }
        String schema = tokens[0];
        String element = tokens[1];
        String qualifier = tokens[2];
        DCValue[] values = ANY.equals(qualifier) ? this.getMetadata(schema, element, ANY, ANY) : ("".equals(qualifier) ? this.getMetadata(schema, element, null, ANY) : this.getMetadata(schema, element, qualifier, ANY));
        return values;
    }

    @Deprecated
    public void addDC(String element, String qualifier, String lang, String[] values) {
        this.addMetadata("dc", element, qualifier, lang, values);
    }

    @Deprecated
    public void addDC(String element, String qualifier, String lang, String value) {
        this.addMetadata("dc", element, qualifier, lang, value);
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String[] values) {
        String fieldKey;
        MetadataAuthorityManager mam = MetadataAuthorityManager.getManager();
        if (mam.isAuthorityControlled(fieldKey = MetadataAuthorityManager.makeFieldKey(schema, element, qualifier))) {
            String[] authorities = new String[values.length];
            int[] confidences = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                Choices c = ChoiceAuthorityManager.getManager().getBestMatch(fieldKey, values[i], this.getOwningCollectionID(), null);
                authorities[i] = c.values.length > 0 ? c.values[0].authority : null;
                confidences[i] = c.confidence;
            }
            this.addMetadata(schema, element, qualifier, lang, values, authorities, confidences);
        } else {
            this.addMetadata(schema, element, qualifier, lang, values, null, null);
        }
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String[] values, String[] authorities, int[] confidences) {
        List<DCValue> dublinCore = this.getMetadata();
        MetadataAuthorityManager mam = MetadataAuthorityManager.getManager();
        boolean authorityControlled = mam.isAuthorityControlled(schema, element, qualifier);
        boolean authorityRequired = mam.isAuthorityRequired(schema, element, qualifier);
        String fieldName = schema + "." + element + (qualifier == null ? "" : "." + qualifier);
        for (int i = 0; i < values.length; ++i) {
            DCValue dcv = new DCValue();
            dcv.schema = schema;
            dcv.element = element;
            dcv.qualifier = qualifier;
            String string = dcv.language = lang == null ? null : lang.trim();
            if (authorityControlled) {
                if (authorities != null && authorities[i] != null && authorities[i].length() > 0) {
                    dcv.authority = authorities[i];
                    dcv.confidence = confidences == null ? 0 : confidences[i];
                } else {
                    dcv.authority = null;
                    int n = dcv.confidence = confidences == null ? -1 : confidences[i];
                }
                if (authorityRequired && (dcv.authority == null || dcv.authority.length() == 0)) {
                    throw new IllegalArgumentException("The metadata field \"" + fieldName + "\" requires an authority key but none was provided. Vaue=\"" + dcv.value + "\"");
                }
            }
            if (values[i] != null) {
                String temp = values[i].trim();
                char[] dcvalue = temp.toCharArray();
                for (int charPos = 0; charPos < dcvalue.length; ++charPos) {
                    if (!Character.isISOControl(dcvalue[charPos]) || String.valueOf(dcvalue[charPos]).equals("\t") || String.valueOf(dcvalue[charPos]).equals("\n") || String.valueOf(dcvalue[charPos]).equals("\r")) continue;
                    dcvalue[charPos] = 32;
                }
                dcv.value = String.valueOf(dcvalue);
            } else {
                dcv.value = null;
            }
            dublinCore.add(dcv);
            this.addDetails(fieldName);
        }
        if (values.length > 0) {
            this.dublinCoreChanged = true;
        }
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String value) {
        String[] valArray = new String[]{value};
        this.addMetadata(schema, element, qualifier, lang, valArray);
    }

    public void addMetadata(String schema, String element, String qualifier, String lang, String value, String authority, int confidence) {
        String[] valArray = new String[1];
        String[] authArray = new String[1];
        int[] confArray = new int[1];
        valArray[0] = value;
        authArray[0] = authority;
        confArray[0] = confidence;
        this.addMetadata(schema, element, qualifier, lang, valArray, authArray, confArray);
    }

    @Deprecated
    public void clearDC(String element, String qualifier, String lang) {
        this.clearMetadata("dc", element, qualifier, lang);
    }

    public void clearMetadata(String schema, String element, String qualifier, String lang) {
        ArrayList<DCValue> values = new ArrayList<DCValue>();
        for (DCValue dcv : this.getMetadata()) {
            if (this.match(schema, element, qualifier, lang, dcv)) continue;
            values.add(dcv);
        }
        this.setMetadata(values);
        this.dublinCoreChanged = true;
    }

    private boolean match(String schema, String element, String qualifier, String language, DCValue dcv) {
        if (!element.equals(ANY) && !element.equals(dcv.element)) {
            return false;
        }
        if (qualifier == null ? dcv.qualifier != null : !qualifier.equals(ANY) && !qualifier.equals(dcv.qualifier)) {
            return false;
        }
        if (language == null ? dcv.language != null : !language.equals(ANY) && !language.equals(dcv.language)) {
            return false;
        }
        return schema.equals(ANY) || dcv.schema == null || dcv.schema.equals(schema);
    }

    public EPerson getSubmitter() throws SQLException {
        if (this.submitter == null && !this.itemRow.isColumnNull("submitter_id")) {
            this.submitter = EPerson.find(this.ourContext, this.itemRow.getIntColumn("submitter_id"));
        }
        return this.submitter;
    }

    public void setSubmitter(EPerson sub) {
        this.submitter = sub;
        if (this.submitter != null) {
            this.itemRow.setColumn("submitter_id", this.submitter.getID());
        } else {
            this.itemRow.setColumnNull("submitter_id");
        }
        this.modified = true;
    }

    public boolean isIn(Collection collection) throws SQLException {
        TableRow tr = DatabaseManager.querySingle(this.ourContext, "SELECT COUNT(*) AS count FROM collection2item WHERE collection_id = ? AND item_id = ?", collection.getID(), this.itemRow.getIntColumn("item_id"));
        return tr.getLongColumn("count") > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection[] getCollections() throws SQLException {
        ArrayList<Collection> collections = new ArrayList<Collection>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "collection", "SELECT collection.* FROM collection, collection2item WHERE collection2item.collection_id=collection.collection_id AND collection2item.item_id= ? ", this.itemRow.getIntColumn("item_id"));
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Collection fromCache = (Collection)this.ourContext.fromCache(Collection.class, row.getIntColumn("collection_id"));
                if (fromCache != null) {
                    collections.add(fromCache);
                    continue;
                }
                collections.add(new Collection(this.ourContext, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Collection[] collectionArray = new Collection[collections.size()];
        collectionArray = collections.toArray(collectionArray);
        return collectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Community[] getCommunities() throws SQLException {
        ArrayList<Community> communities = new ArrayList<Community>();
        TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "community", "SELECT community.* FROM community, community2item WHERE community2item.community_id=community.community_id AND community2item.item_id= ? ", this.itemRow.getIntColumn("item_id"));
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                Community owner = (Community)this.ourContext.fromCache(Community.class, row.getIntColumn("community_id"));
                if (owner == null) {
                    owner = new Community(this.ourContext, row);
                }
                communities.add(owner);
                Community[] parents = owner.getAllParents();
                communities.addAll(Arrays.asList(parents));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        Community[] communityArray = new Community[communities.size()];
        communityArray = communities.toArray(communityArray);
        return communityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() throws SQLException {
        if (this.bundles == null) {
            this.bundles = new ArrayList<Bundle>();
            TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "bundle", "SELECT bundle.* FROM bundle, item2bundle WHERE item2bundle.bundle_id=bundle.bundle_id AND item2bundle.item_id= ? ", this.itemRow.getIntColumn("item_id"));
            try {
                while (tri.hasNext()) {
                    TableRow r = tri.next();
                    Bundle fromCache = (Bundle)this.ourContext.fromCache(Bundle.class, r.getIntColumn("bundle_id"));
                    if (fromCache != null) {
                        this.bundles.add(fromCache);
                        continue;
                    }
                    this.bundles.add(new Bundle(this.ourContext, r));
                }
            }
            finally {
                if (tri != null) {
                    tri.close();
                }
            }
        }
        Bundle[] bundleArray = new Bundle[this.bundles.size()];
        bundleArray = this.bundles.toArray(bundleArray);
        return bundleArray;
    }

    public Bundle[] getBundles(String name) throws SQLException {
        ArrayList<Bundle> matchingBundles = new ArrayList<Bundle>();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (!name.equals(bunds[i].getName())) continue;
            matchingBundles.add(bunds[i]);
        }
        Bundle[] bundleArray = new Bundle[matchingBundles.size()];
        bundleArray = matchingBundles.toArray(bundleArray);
        return bundleArray;
    }

    public Bundle createBundle(String name) throws SQLException, AuthorizeException {
        if (name == null || "".equals(name)) {
            throw new SQLException("Bundle must be created with non-null name");
        }
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        Bundle b = Bundle.create(this.ourContext);
        b.setName(name);
        b.update();
        this.addBundle(b);
        return b;
    }

    public void addBundle(Bundle b) throws SQLException, AuthorizeException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 3);
        log.info((Object)LogManager.getHeader(this.ourContext, "add_bundle", "item_id=" + this.getID() + ",bundle_id=" + b.getID()));
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (b.getID() != bunds[i].getID()) continue;
            return;
        }
        AuthorizeManager.inheritPolicies(this.ourContext, this, b);
        this.bundles.add(b);
        TableRow mappingRow = DatabaseManager.row("item2bundle");
        mappingRow.setColumn("item_id", this.getID());
        mappingRow.setColumn("bundle_id", b.getID());
        DatabaseManager.insert(this.ourContext, mappingRow);
        this.ourContext.addEvent(new Event(8, 2, this.getID(), 1, b.getID(), b.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundle(Bundle b) throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        log.info((Object)LogManager.getHeader(this.ourContext, "remove_bundle", "item_id=" + this.getID() + ",bundle_id=" + b.getID()));
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            if (b.getID() != bunds[i].getID()) continue;
            this.bundles.remove(bunds[i]);
            break;
        }
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM item2bundle WHERE item_id= ? AND bundle_id= ? ", this.getID(), b.getID());
        this.ourContext.addEvent(new Event(16, 2, this.getID(), 1, b.getID(), b.getName()));
        TableRowIterator tri = DatabaseManager.query(this.ourContext, "SELECT * FROM item2bundle WHERE bundle_id= ? ", b.getID());
        try {
            if (!tri.hasNext()) {
                AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)b, 2, this.ourContext.getCurrentUser());
                AuthorizeManager.addPolicy(this.ourContext, (DSpaceObject)b, 4, this.ourContext.getCurrentUser());
                b.delete();
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    public Bitstream createSingleBitstream(InputStream is, String name) throws AuthorizeException, IOException, SQLException {
        Bundle bnd = this.createBundle(name);
        Bitstream bitstream = bnd.createBitstream(is);
        this.addBundle(bnd);
        return bitstream;
    }

    public Bitstream createSingleBitstream(InputStream is) throws AuthorizeException, IOException, SQLException {
        return this.createSingleBitstream(is, "ORIGINAL");
    }

    public Bitstream[] getNonInternalBitstreams() throws SQLException {
        ArrayList<Bitstream> bitstreamList = new ArrayList<Bitstream>();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bitstream[] bitstreams = bunds[i].getBitstreams();
            for (int j = 0; j < bitstreams.length; ++j) {
                if (bitstreams[j].getFormat().isInternal()) continue;
                bitstreamList.add(bitstreams[j]);
            }
        }
        return bitstreamList.toArray(new Bitstream[bitstreamList.size()]);
    }

    public void removeDSpaceLicense() throws SQLException, AuthorizeException, IOException {
        Bundle[] bunds = this.getBundles("LICENSE");
        for (int i = 0; i < bunds.length; ++i) {
            this.removeBundle(bunds[i]);
        }
    }

    public void removeLicenses() throws SQLException, AuthorizeException, IOException {
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(this.ourContext, "License");
        int licensetype = bf.getID();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            boolean removethisbundle = false;
            Bitstream[] bits = bunds[i].getBitstreams();
            for (int j = 0; j < bits.length; ++j) {
                BitstreamFormat bft = bits[j].getFormat();
                if (bft.getID() != licensetype) continue;
                removethisbundle = true;
            }
            if (!removethisbundle) continue;
            this.removeBundle(bunds[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws SQLException, AuthorizeException {
        int k;
        Bitstream[] streams;
        int i;
        if (!this.canEdit()) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "update_item", "item_id=" + this.getID()));
        int sequence = 0;
        Bundle[] bunds = this.getBundles();
        for (i = 0; i < bunds.length; ++i) {
            streams = bunds[i].getBitstreams();
            for (k = 0; k < streams.length; ++k) {
                if (streams[k].getSequenceID() <= sequence) continue;
                sequence = streams[k].getSequenceID();
            }
        }
        ++sequence;
        for (i = 0; i < bunds.length; ++i) {
            streams = bunds[i].getBitstreams();
            for (k = 0; k < streams.length; ++k) {
                if (streams[k].getSequenceID() >= 0) continue;
                streams[k].setSequenceID(sequence);
                ++sequence;
                streams[k].update();
                this.modified = true;
            }
        }
        HashMap<String, Integer> elementCount = new HashMap<String, Integer>();
        if (this.dublinCoreChanged) {
            this.dublinCoreChanged = false;
            int[] placeNum = new int[this.getMetadata().size()];
            boolean[] storedDC = new boolean[this.getMetadata().size()];
            MetadataField[] dcFields = new MetadataField[this.getMetadata().size()];
            for (int dcIdx = 0; dcIdx < this.getMetadata().size(); ++dcIdx) {
                DCValue dcv = this.getMetadata().get(dcIdx);
                int current = 0;
                String key = dcv.element + (dcv.qualifier == null ? "" : "." + dcv.qualifier);
                Integer currentInteger = (Integer)elementCount.get(key);
                if (currentInteger != null) {
                    current = currentInteger;
                }
                elementCount.put(key, ++current);
                placeNum[dcIdx] = current;
                storedDC[dcIdx] = false;
                dcFields[dcIdx] = this.getMetadataField(dcv);
                if (dcFields[dcIdx] != null) continue;
                log.warn((Object)LogManager.getHeader(this.ourContext, "bad_dc", "Bad DC field. schema=" + dcv.schema + ", element: \"" + (dcv.element == null ? "null" : dcv.element) + "\" qualifier: \"" + (dcv.qualifier == null ? "null" : dcv.qualifier) + "\" value: \"" + (dcv.value == null ? "null" : dcv.value) + "\""));
                throw new SQLException("bad_dublin_core schema=" + dcv.schema + ", " + dcv.element + " " + dcv.qualifier);
            }
            TableRowIterator tri = this.retrieveMetadata();
            if (tri != null) {
                try {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        boolean removeRow = true;
                        for (int dcIdx = 0; dcIdx < this.getMetadata().size() && removeRow; ++dcIdx) {
                            if (storedDC[dcIdx]) continue;
                            boolean matched = true;
                            DCValue dcv = this.getMetadata().get(dcIdx);
                            if (matched && dcFields[dcIdx].getFieldID() != tr.getIntColumn("metadata_field_id")) {
                                matched = false;
                            }
                            if (matched && placeNum[dcIdx] != tr.getIntColumn("place")) {
                                matched = false;
                            }
                            if (matched) {
                                String text = tr.getStringColumn("text_value");
                                matched = dcv.value == null && text == null ? true : dcv.value != null && dcv.value.equals(text);
                            }
                            if (matched) {
                                String lang = tr.getStringColumn("text_lang");
                                matched = dcv.language == null && lang == null ? true : dcv.language != null && dcv.language.equals(lang);
                            }
                            if (matched) {
                                String auth = tr.getStringColumn("authority");
                                int conf = tr.getIntColumn("confidence");
                                if (!(dcv.authority == null && auth == null || dcv.authority != null && auth != null && dcv.authority.equals(auth) && dcv.confidence == conf)) {
                                    matched = false;
                                }
                            }
                            if (!matched) continue;
                            storedDC[dcIdx] = true;
                            removeRow = false;
                        }
                        if (!removeRow) continue;
                        DatabaseManager.delete(this.ourContext, tr);
                        this.dublinCoreChanged = true;
                        this.modified = true;
                    }
                }
                finally {
                    tri.close();
                }
            }
            for (int dcIdx = 0; dcIdx < this.getMetadata().size(); ++dcIdx) {
                if (storedDC[dcIdx]) continue;
                DCValue dcv = this.getMetadata().get(dcIdx);
                MetadataValue metadata = new MetadataValue();
                metadata.setItemId(this.getID());
                metadata.setFieldId(dcFields[dcIdx].getFieldID());
                metadata.setValue(dcv.value);
                metadata.setLanguage(dcv.language);
                metadata.setPlace(placeNum[dcIdx]);
                metadata.setAuthority(dcv.authority);
                metadata.setConfidence(dcv.confidence);
                metadata.create(this.ourContext);
                this.dublinCoreChanged = true;
                this.modified = true;
            }
        }
        if (this.dublinCoreChanged || this.modified) {
            this.itemRow.setColumn("last_modified", new Date());
            if (this.itemRow.isColumnNull("in_archive")) {
                this.itemRow.setColumn("in_archive", false);
            }
            if (this.itemRow.isColumnNull("withdrawn")) {
                this.itemRow.setColumn("withdrawn", false);
            }
            if (this.itemRow.isColumnNull("discoverable")) {
                this.itemRow.setColumn("discoverable", false);
            }
            DatabaseManager.update(this.ourContext, this.itemRow);
            if (this.dublinCoreChanged) {
                this.ourContext.addEvent(new Event(4, 2, this.getID(), this.getDetails()));
                this.clearDetails();
                this.dublinCoreChanged = false;
            }
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null));
            this.modified = false;
        }
    }

    private MetadataField getMetadataField(DCValue dcv) throws SQLException, AuthorizeException {
        if (this.allMetadataFields == null) {
            this.allMetadataFields = MetadataField.findAll(this.ourContext);
        }
        if (this.allMetadataFields != null) {
            int schemaID = this.getMetadataSchemaID(dcv);
            for (MetadataField field : this.allMetadataFields) {
                if (field.getSchemaID() != schemaID || !StringUtils.equals((String)field.getElement(), (String)dcv.element) || !StringUtils.equals((String)field.getQualifier(), (String)dcv.qualifier)) continue;
                return field;
            }
        }
        return null;
    }

    private int getMetadataSchemaID(DCValue dcv) throws SQLException {
        MetadataSchema schema = MetadataSchema.find(this.ourContext, dcv.schema);
        int schemaID = schema == null ? 1 : schema.getSchemaID();
        return schemaID;
    }

    public void withdraw() throws SQLException, AuthorizeException, IOException {
        AuthorizeUtil.authorizeWithdrawItem(this.ourContext, this);
        String timestamp = DCDate.getCurrent().toString();
        EPerson e = this.ourContext.getCurrentUser();
        StringBuilder prov = new StringBuilder();
        prov.append("Item withdrawn by ").append(e.getFullName()).append(" (").append(e.getEmail()).append(") on ").append(timestamp).append("\n").append("Item was in collections:\n");
        Collection[] colls = this.getCollections();
        for (int i = 0; i < colls.length; ++i) {
            prov.append(colls[i].getMetadata("name")).append(" (ID: ").append(colls[i].getID()).append(")\n");
        }
        this.itemRow.setColumn("withdrawn", true);
        this.itemRow.setColumn("in_archive", false);
        prov.append(InstallItem.getBitstreamProvenanceMessage(this));
        this.addDC("description", "provenance", "en", prov.toString());
        this.update();
        this.ourContext.addEvent(new Event(2, 2, this.getID(), "WITHDRAW"));
        AuthorizeManager.removeAllPoliciesByDSOAndTypeNotEqualsTo(this.ourContext, this, ResourcePolicy.TYPE_CUSTOM);
        log.info((Object)LogManager.getHeader(this.ourContext, "withdraw_item", "user=" + e.getEmail() + ",item_id=" + this.getID()));
    }

    public void reinstate() throws SQLException, AuthorizeException, IOException {
        AuthorizeUtil.authorizeReinstateItem(this.ourContext, this);
        String timestamp = DCDate.getCurrent().toString();
        Collection[] colls = this.getCollections();
        EPerson e = this.ourContext.getCurrentUser();
        StringBuilder prov = new StringBuilder();
        prov.append("Item reinstated by ").append(e.getFullName()).append(" (").append(e.getEmail()).append(") on ").append(timestamp).append("\n").append("Item was in collections:\n");
        for (int i = 0; i < colls.length; ++i) {
            prov.append(colls[i].getMetadata("name")).append(" (ID: ").append(colls[i].getID()).append(")\n");
        }
        this.itemRow.setColumn("withdrawn", false);
        this.itemRow.setColumn("in_archive", true);
        prov.append(InstallItem.getBitstreamProvenanceMessage(this));
        this.addDC("description", "provenance", "en", prov.toString());
        this.update();
        this.ourContext.addEvent(new Event(2, 2, this.getID(), "REINSTATE"));
        if (colls.length > 0) {
            this.inheritCollectionDefaultPolicies(colls[0]);
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "reinstate_item", "user=" + e.getEmail() + ",item_id=" + this.getID()));
    }

    void delete() throws SQLException, AuthorizeException, IOException {
        AuthorizeManager.authorizeAction(this.ourContext, this, 4);
        this.ourContext.addEvent(new Event(32, 2, this.getID(), this.getHandle()));
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_item", "item_id=" + this.getID()));
        this.ourContext.removeCached(this, this.getID());
        try {
            IndexBrowse ib = new IndexBrowse(this.ourContext);
            ib.itemRemoved(this);
        }
        catch (BrowseException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new SQLException(e.getMessage(), e);
        }
        this.removeMetadataFromDatabase();
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            this.removeBundle(bunds[i]);
        }
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        HandleManager.unbindHandle(this.ourContext, this);
        this.removeVersion();
        DatabaseManager.delete(this.ourContext, this.itemRow);
    }

    private void removeVersion() throws AuthorizeException, SQLException {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        if (versioningService.getVersion(this.ourContext, this) != null) {
            versioningService.removeVersion(this.ourContext, this);
        } else {
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            try {
                identifierService.delete(this.ourContext, this);
            }
            catch (IdentifierException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void decache() throws SQLException {
        this.ourContext.removeCached(this, this.getID());
        if (this.submitter != null) {
            this.ourContext.removeCached(this.submitter, this.submitter.getID());
        }
        if (this.bundles != null) {
            Bundle[] bunds = this.getBundles();
            for (int i = 0; i < bunds.length; ++i) {
                this.ourContext.removeCached(bunds[i], bunds[i].getID());
                Bitstream[] bitstreams = bunds[i].getBitstreams();
                for (int j = 0; j < bitstreams.length; ++j) {
                    this.ourContext.removeCached(bitstreams[j], bitstreams[j].getID());
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        return this.getID() == other.getID();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.itemRow != null ? this.itemRow.hashCode() : 0);
        return hash;
    }

    public boolean isOwningCollection(Collection c) {
        int owner_id = this.itemRow.getIntColumn("owning_collection");
        return c.getID() == owner_id;
    }

    private void removeMetadataFromDatabase() throws SQLException {
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM MetadataValue WHERE item_id= ? ", this.getID());
    }

    @Override
    public int getType() {
        return 2;
    }

    public void replaceAllItemPolicies(List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        AuthorizeManager.removeAllPolicies(this.ourContext, this);
        AuthorizeManager.addPolicies(this.ourContext, newpolicies, this);
    }

    public void replaceAllBitstreamPolicies(List<ResourcePolicy> newpolicies) throws SQLException, AuthorizeException {
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            mybundle.replaceAllBitstreamPolicies(newpolicies);
        }
    }

    public void removeGroupPolicies(Group g) throws SQLException {
        AuthorizeManager.removeGroupPolicies(this.ourContext, this, g);
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            Bitstream[] bs = mybundle.getBitstreams();
            for (int j = 0; j < bs.length; ++j) {
                AuthorizeManager.removeGroupPolicies(this.ourContext, bs[j], g);
            }
            AuthorizeManager.removeGroupPolicies(this.ourContext, mybundle, g);
        }
    }

    public void inheritCollectionDefaultPolicies(Collection c) throws SQLException, AuthorizeException {
        this.adjustItemPolicies(c);
        this.adjustBundleBitstreamPolicies(c);
        log.debug((Object)LogManager.getHeader(this.ourContext, "item_inheritCollectionDefaultPolicies", "item_id=" + this.getID()));
    }

    public void adjustBundleBitstreamPolicies(Collection c) throws SQLException, AuthorizeException {
        List<ResourcePolicy> defaultCollectionPolicies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 9);
        if (defaultCollectionPolicies.size() < 1) {
            throw new SQLException("Collection " + c.getID() + " (" + c.getHandle() + ")" + " has no default bitstream READ policies");
        }
        Bundle[] bunds = this.getBundles();
        for (int i = 0; i < bunds.length; ++i) {
            Bundle mybundle = bunds[i];
            AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, mybundle, ResourcePolicy.TYPE_SUBMISSION);
            AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, mybundle, ResourcePolicy.TYPE_WORKFLOW);
            List<ResourcePolicy> policiesBundleToAdd = this.filterPoliciesToAdd(defaultCollectionPolicies, mybundle);
            AuthorizeManager.addPolicies(this.ourContext, policiesBundleToAdd, mybundle);
            for (Bitstream bitstream : mybundle.getBitstreams()) {
                AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, bitstream, ResourcePolicy.TYPE_SUBMISSION);
                AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, bitstream, ResourcePolicy.TYPE_WORKFLOW);
                List<ResourcePolicy> policiesBitstreamToAdd = this.filterPoliciesToAdd(defaultCollectionPolicies, bitstream);
                AuthorizeManager.addPolicies(this.ourContext, policiesBitstreamToAdd, bitstream);
            }
        }
    }

    public void adjustItemPolicies(Collection c) throws SQLException, AuthorizeException {
        List<ResourcePolicy> defaultCollectionPolicies = AuthorizeManager.getPoliciesActionFilter(this.ourContext, c, 10);
        if (defaultCollectionPolicies.size() < 1) {
            throw new SQLException("Collection " + c.getID() + " (" + c.getHandle() + ")" + " has no default item READ policies");
        }
        AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, this, ResourcePolicy.TYPE_SUBMISSION);
        AuthorizeManager.removeAllPoliciesByDSOAndType(this.ourContext, this, ResourcePolicy.TYPE_WORKFLOW);
        List<ResourcePolicy> policiesToAdd = this.filterPoliciesToAdd(defaultCollectionPolicies, this);
        AuthorizeManager.addPolicies(this.ourContext, policiesToAdd, this);
    }

    private List<ResourcePolicy> filterPoliciesToAdd(List<ResourcePolicy> defaultCollectionPolicies, DSpaceObject dso) throws SQLException {
        ArrayList<ResourcePolicy> policiesToAdd = new ArrayList<ResourcePolicy>();
        for (ResourcePolicy rp : defaultCollectionPolicies) {
            rp.setAction(0);
            if (AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(this.ourContext, dso, rp)) continue;
            rp.setRpType(ResourcePolicy.TYPE_INHERITED);
            policiesToAdd.add(rp);
        }
        return policiesToAdd;
    }

    public void move(Collection from, Collection to) throws SQLException, AuthorizeException, IOException {
        this.move(from, to, false);
    }

    public void move(Collection from, Collection to, boolean inheritDefaultPolicies) throws SQLException, AuthorizeException, IOException {
        if (!this.canEdit()) {
            AuthorizeManager.authorizeAction(this.ourContext, this, 1);
        }
        to.addItem(this);
        from.removeItem(this);
        if (this.isOwningCollection(from)) {
            log.info((Object)LogManager.getHeader(this.ourContext, "move_item", "item_id=" + this.getID() + ", from " + "collection_id=" + from.getID() + " to " + "collection_id=" + to.getID()));
            this.setOwningCollection(to);
            if (inheritDefaultPolicies) {
                log.info((Object)LogManager.getHeader(this.ourContext, "move_item", "Updating item with inherited policies"));
                this.inheritCollectionDefaultPolicies(to);
            }
            this.ourContext.turnOffAuthorisationSystem();
            this.update();
            this.ourContext.restoreAuthSystemState();
        } else {
            this.ourContext.addEvent(new Event(2, 2, this.getID(), null));
        }
    }

    public boolean hasUploadedFiles() throws SQLException {
        Bundle[] bundles = this.getBundles("ORIGINAL");
        if (bundles.length == 0) {
            return false;
        }
        Bitstream[] bitstreams = bundles[0].getBitstreams();
        return bitstreams.length != 0;
    }

    public Collection[] getCollectionsNotLinked() throws SQLException {
        Collection[] allCollections = Collection.findAll(this.ourContext);
        Collection[] linkedCollections = this.getCollections();
        Collection[] notLinkedCollections = new Collection[allCollections.length - linkedCollections.length];
        if (allCollections.length - linkedCollections.length == 0) {
            return notLinkedCollections;
        }
        int i = 0;
        for (Collection collection : allCollections) {
            boolean alreadyLinked = false;
            for (Collection linkedCommunity : linkedCollections) {
                if (collection.getID() != linkedCommunity.getID()) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked) continue;
            notLinkedCollections[i++] = collection;
        }
        return notLinkedCollections;
    }

    public boolean canEdit() throws SQLException {
        if (AuthorizeManager.authorizeActionBoolean(this.ourContext, this, 1)) {
            return true;
        }
        if (this.getOwningCollection() == null) {
            return true;
        }
        return this.getOwningCollection().canEditBoolean(false);
    }

    @Override
    public String getName() {
        DCValue[] t = this.getMetadata("dc", "title", null, ANY);
        return t.length >= 1 ? t[0].value : null;
    }

    public static ItemIterator findByMetadataField(Context context, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException, IOException {
        MetadataSchema mds = MetadataSchema.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = MetadataField.findByElement(context, mds.getSchemaID(), element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        String query = "SELECT item.* FROM metadatavalue,item WHERE item.in_archive='1' AND item.item_id = metadatavalue.item_id AND metadata_field_id = ?";
        TableRowIterator rows = null;
        if (ANY.equals(value)) {
            rows = DatabaseManager.queryTable(context, "item", query, mdf.getFieldID());
        } else {
            query = query + " AND metadatavalue.text_value = ?";
            rows = DatabaseManager.queryTable(context, "item", query, mdf.getFieldID(), value);
        }
        return new ItemIterator(context, rows);
    }

    @Override
    public DSpaceObject getAdminObject(int action) throws SQLException {
        DSpaceObject adminObject = null;
        Collection collection = this.getOwningCollection();
        Community community = null;
        if (collection != null) {
            Community[] communities = collection.getCommunities();
            if (communities != null && communities.length > 0) {
                community = communities[0];
            }
        } else {
            Community[] communities;
            TableRow qResult = DatabaseManager.querySingle(this.ourContext, "SELECT collection_id FROM collection WHERE template_item_id = ?", this.getID());
            if (qResult != null && (communities = (collection = Collection.find(this.ourContext, qResult.getIntColumn("collection_id"))).getCommunities()) != null && communities.length > 0) {
                community = communities[0];
            }
        }
        switch (action) {
            case 3: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamCreation()) {
                    adminObject = this;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamCreation()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamCreation()) break;
                adminObject = community;
                break;
            }
            case 4: {
                if (AuthorizeConfiguration.canItemAdminPerformBitstreamDeletion()) {
                    adminObject = this;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminPerformBitstreamDeletion()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminPerformBitstreamDeletion()) break;
                adminObject = community;
                break;
            }
            case 2: {
                if (this.getOwningCollection() != null) {
                    if (AuthorizeConfiguration.canCollectionAdminPerformItemDeletion()) {
                        adminObject = collection;
                        break;
                    }
                    if (!AuthorizeConfiguration.canCommunityAdminPerformItemDeletion()) break;
                    adminObject = community;
                    break;
                }
                if (AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
                    adminObject = collection;
                    break;
                }
                if (!AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) break;
                adminObject = community;
                break;
            }
            case 1: {
                if (this.getOwningCollection() == null) {
                    if (AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
                        adminObject = collection;
                        break;
                    }
                    if (!AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) break;
                    adminObject = community;
                    break;
                }
                adminObject = this;
                break;
            }
            default: {
                adminObject = this;
            }
        }
        return adminObject;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        Collection ownCollection = this.getOwningCollection();
        if (ownCollection != null) {
            return ownCollection;
        }
        TableRow qResult = DatabaseManager.querySingle(this.ourContext, "SELECT collection_id FROM collection WHERE template_item_id = ?", this.getID());
        if (qResult != null) {
            return Collection.find(this.ourContext, qResult.getIntColumn("collection_id"));
        }
        return null;
    }

    public static ItemIterator findByAuthorityValue(Context context, String schema, String element, String qualifier, String value) throws SQLException, AuthorizeException, IOException {
        MetadataSchema mds = MetadataSchema.find(context, schema);
        if (mds == null) {
            throw new IllegalArgumentException("No such metadata schema: " + schema);
        }
        MetadataField mdf = MetadataField.findByElement(context, mds.getSchemaID(), element, qualifier);
        if (mdf == null) {
            throw new IllegalArgumentException("No such metadata field: schema=" + schema + ", element=" + element + ", qualifier=" + qualifier);
        }
        TableRowIterator rows = DatabaseManager.queryTable(context, "item", "SELECT item.* FROM metadatavalue,item WHERE item.in_archive='1' AND item.item_id = metadatavalue.item_id AND metadata_field_id = ? AND authority = ?", mdf.getFieldID(), value);
        return new ItemIterator(context, rows);
    }

    private List<DCValue> getMetadata() {
        try {
            return this.dublinCore.get(this.ourContext, this.getID(), log);
        }
        catch (SQLException e) {
            log.error((Object)"Loading item - cannot load metadata");
            return new ArrayList<DCValue>();
        }
    }

    private void setMetadata(List<DCValue> metadata) {
        this.dublinCore.set(metadata);
        this.dublinCoreChanged = true;
    }

    class MetadataCache {
        List<DCValue> metadata = null;

        MetadataCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<DCValue> get(Context c, int itemId, Logger log) throws SQLException {
            if (this.metadata == null) {
                this.metadata = new ArrayList<DCValue>();
                TableRowIterator tri = this.retrieveMetadata(itemId);
                if (tri != null) {
                    try {
                        while (tri.hasNext()) {
                            TableRow resultRow = tri.next();
                            int fieldID = resultRow.getIntColumn("metadata_field_id");
                            MetadataField field = MetadataField.find(c, fieldID);
                            if (field == null) {
                                log.error((Object)("Loading item - cannot find metadata field " + fieldID));
                                continue;
                            }
                            MetadataSchema schema = MetadataSchema.find(c, field.getSchemaID());
                            if (schema == null) {
                                log.error((Object)("Loading item - cannot find metadata schema " + field.getSchemaID() + ", field " + fieldID));
                                continue;
                            }
                            DCValue dcv = new DCValue();
                            dcv.element = field.getElement();
                            dcv.qualifier = field.getQualifier();
                            dcv.value = resultRow.getStringColumn("text_value");
                            dcv.language = resultRow.getStringColumn("text_lang");
                            dcv.schema = schema.getName();
                            dcv.authority = resultRow.getStringColumn("authority");
                            dcv.confidence = resultRow.getIntColumn("confidence");
                            this.metadata.add(dcv);
                        }
                    }
                    finally {
                        if (tri != null) {
                            tri.close();
                        }
                    }
                }
            }
            return this.metadata;
        }

        void set(List<DCValue> m) {
            this.metadata = m;
        }

        TableRowIterator retrieveMetadata(int itemId) throws SQLException {
            if (itemId > 0) {
                return DatabaseManager.queryTable(Item.this.ourContext, "MetadataValue", "SELECT * FROM MetadataValue WHERE item_id= ? ORDER BY metadata_field_id, place", itemId);
            }
            return null;
        }
    }
}

