/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.eperson.EPerson;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.LocationUtils;
import org.dspace.statistics.util.SpiderDetector;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.indices.exists.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.client.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class ElasticSearchLogger {
    private static Logger log = Logger.getLogger(ElasticSearchLogger.class);
    private static boolean useProxies;
    public static final String DATE_FORMAT_8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DCDATE = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static LookupService locationService;
    public static String clusterName;
    public static String indexName;
    public static String indexType;
    public static String address;
    public static int port;
    private static Client client;

    public ElasticSearchLogger() {
    }

    public ElasticSearchLogger(boolean doInitialize) {
        this.initializeElasticSearch();
    }

    public static ElasticSearchLogger getInstance() {
        return ElasticSearchLoggerSingletonHolder.instance;
    }

    public void initializeElasticSearch() {
        log.info((Object)"DSpace ElasticSearchLogger Initializing");
        try {
            LookupService service = null;
            String dbfile = ConfigurationManager.getProperty("usage-statistics", "dbfile");
            if (dbfile != null) {
                try {
                    service = new LookupService(dbfile, 0);
                }
                catch (FileNotFoundException fe) {
                    log.error((Object)("The GeoLite Database file is missing (" + dbfile + ")! Usage Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file."), (Throwable)fe);
                }
                catch (IOException e) {
                    log.error((Object)("Unable to load GeoLite Database file (" + dbfile + ")! You may need to reinstall it. See the DSpace installation instructions for more details."), (Throwable)e);
                }
            } else {
                log.error((Object)"The required 'dbfile' configuration is missing in usage-statistics.cfg!");
            }
            locationService = service;
            useProxies = "true".equals(ConfigurationManager.getProperty("useProxies"));
            log.info((Object)("useProxies=" + useProxies));
            clusterName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "clusterName", clusterName);
            indexName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexName", indexName);
            indexType = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexType", indexType);
            address = this.getConfigurationStringWithFallBack("elastic-search-statistics", "address", address);
            port = ConfigurationManager.getIntProperty("elastic-search-statistics", "port", port);
            client = this.getClient();
            IndicesExistsRequest indicesExistsRequest = new IndicesExistsRequest(new String[0]);
            indicesExistsRequest.indices(new String[]{indexName});
            ActionFuture actionFutureIndicesExist = client.admin().indices().exists(indicesExistsRequest);
            log.info((Object)"DS ES Checking if index exists");
            if (!((IndicesExistsResponse)actionFutureIndicesExist.actionGet()).isExists()) {
                log.info((Object)"DS ES index didn't exist, we need to create it.");
                Settings settings = ImmutableSettings.settingsBuilder().put("number_of_replicas", 1).put("number_of_shards", 5).put("cluster.name", clusterName).build();
                String stringMappingJSON = "{\"" + indexType + "\" : { \"properties\" : {\n" + "   \"userAgent\":{\n" + "      \"type\":\"string\"\n" + "   },\n" + "   \"countryCode\":{\n" + "      \"type\":\"string\",\n" + "      \"index\":\"not_analyzed\",\n" + "      \"omit_norms\":true\n" + "   },\n" + "   \"dns\":{\n" + "      \"type\":\"multi_field\",\n" + "      \"fields\": {\n" + "        \"dns\": {\"type\":\"string\",\"index\":\"analyzed\"},\n" + "        \"untouched\":{\"type\":\"string\",\"index\":\"not_analyzed\"}\n" + "      }\n" + "   },\n" + "   \"isBot\":{\n" + "      \"type\":\"boolean\"\n" + "   },\n" + "   \"owningColl\":{\n" + "      \"type\":\"integer\",\n" + "      \"index\":\"not_analyzed\"\n" + "   },\n" + "   \"type\":{\n" + "      \"type\":\"string\",\n" + "      \"index\":\"not_analyzed\",\n" + "      \"omit_norms\":true\n" + "   },\n" + "   \"owningComm\":{\n" + "      \"type\":\"integer\",\n" + "      \"index\":\"not_analyzed\"\n" + "   },\n" + "   \"city\":{\n" + "      \"type\":\"multi_field\",\n" + "      \"fields\": {\n" + "        \"city\": {\"type\":\"string\",\"index\":\"analyzed\"},\n" + "        \"untouched\":{\"type\":\"string\",\"index\":\"not_analyzed\"}\n" + "      }\n" + "   },\n" + "   \"country\":{\n" + "      \"type\":\"multi_field\",\n" + "      \"fields\": {\n" + "         \"country\": {\"type\":\"string\",\"index\":\"analyzed\"},\n" + "         \"untouched\":{\"type\":\"string\",\"index\":\"not_analyzed\"}\n" + "       }\n" + "   },\n" + "   \"ip\":{\n" + "      \"type\":\"multi_field\",\n" + "       \"fields\": {\n" + "         \"ip\": {\"type\":\"string\",\"index\":\"analyzed\"},\n" + "         \"untouched\":{\"type\":\"string\",\"index\":\"not_analyzed\"}\n" + "       }\n" + "   },\n" + "   \"id\":{\n" + "      \"type\":\"integer\",\n" + "      \"index\":\"not_analyzed\"\n" + "   },\n" + "   \"time\":{\n" + "      \"type\":\"date\"\n" + "   },\n" + "   \"owningItem\":{\n" + "      \"type\":\"string\",\n" + "      \"index\":\"not_analyzed\"\n" + "   },\n" + "   \"continent\":{\n" + "      \"type\":\"string\",\n" + "      \"index\":\"not_analyzed\"\n" + "   },\n" + "   \"geo\":{\n" + "      \"type\":\"geo_point\"\n" + "   },\n" + "   \"bundleName\":{\n" + "      \"type\":\"string\",\n" + "      \"index\":\"not_analyzed\"\n" + "   },\n" + "   \"epersonid\":{\n" + "      \"type\":\"string\",\n" + "      \"index\":\"not_analyzed\"\n" + "   }\n" + "} } }";
                client.prepareIndex(indexName, indexType, "1").setSource(XContentFactory.jsonBuilder().startObject().field("user", "kimchy").field("postDate", new Date()).field("message", "trying out Elastic Search").endObject()).execute().actionGet();
                log.info((Object)("Create INDEX [" + indexName + "]/[" + indexType + "]"));
                client.admin().indices().prepareRefresh(new String[]{indexName}).execute().actionGet();
                log.info((Object)("Put Mapping for [" + indexName + "]/[" + indexType + "]=" + stringMappingJSON));
                PutMappingRequestBuilder putMappingRequestBuilder = client.admin().indices().preparePutMapping(new String[]{indexName}).setType(indexType);
                putMappingRequestBuilder.setSource(stringMappingJSON);
                PutMappingResponse response = (PutMappingResponse)putMappingRequestBuilder.execute().actionGet();
                if (!response.getAcknowledged()) {
                    log.info((Object)("Could not define mapping for type [" + indexName + "]/[" + indexType + "]"));
                } else {
                    log.info((Object)("Successfully put mapping for [" + indexName + "]/[" + indexType + "]"));
                }
                log.info((Object)"DS ES index didn't exist, but we created it.");
            } else {
                log.info((Object)"DS ES index already exists");
            }
            log.info((Object)"DSpace ElasticSearchLogger Initialized Successfully (I suppose)");
        }
        catch (Exception e) {
            log.info((Object)("Elastic Search crashed during init. " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(DSpaceObject dspaceObject, HttpServletRequest request, EPerson currentUser) {
        client = ElasticSearchLogger.getInstance().getClient();
        boolean isSpiderBot = SpiderDetector.isSpider(request);
        try {
            if (isSpiderBot && !ConfigurationManager.getBooleanProperty("usage-statistics", "logBots", true)) {
                return;
            }
            String ip = request.getRemoteAddr();
            if (this.isUseProxies() && request.getHeader("X-Forwarded-For") != null) {
                for (String xfip : request.getHeader("X-Forwarded-For").split(",")) {
                    if (request.getHeader("X-Forwarded-For").contains(ip)) continue;
                    ip = xfip.trim();
                }
            }
            XContentBuilder docBuilder = null;
            docBuilder = XContentFactory.jsonBuilder().startObject();
            docBuilder.field("ip", ip);
            docBuilder.field("id", dspaceObject.getID());
            docBuilder.field("typeIndex", dspaceObject.getType());
            docBuilder.field("type", Constants.typeText[dspaceObject.getType()]);
            docBuilder.field("time", DateFormatUtils.format((Date)new Date(), (String)DATE_FORMAT_8601));
            if (currentUser != null) {
                docBuilder.field("epersonid", currentUser.getID());
            }
            try {
                String dns = DnsLookup.reverseDns(ip);
                docBuilder.field("dns", dns.toLowerCase());
            }
            catch (Exception e) {
                log.error((Object)("Failed DNS Lookup for IP:" + ip));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            Location location = locationService.getLocation(ip);
            if (!(location == null || "--".equals(location.countryCode) && location.latitude == -180.0f && location.longitude == -180.0f)) {
                try {
                    docBuilder.field("continent", LocationUtils.getContinentCode(location.countryCode));
                }
                catch (Exception e) {
                    System.out.println("COUNTRY ERROR: " + location.countryCode);
                }
                docBuilder.field("countryCode", location.countryCode);
                docBuilder.field("city", location.city);
                docBuilder.field("latitude", location.latitude);
                docBuilder.field("longitude", location.longitude);
                docBuilder.field("isBot", isSpiderBot);
                if (request.getHeader("User-Agent") != null) {
                    docBuilder.field("userAgent", request.getHeader("User-Agent"));
                }
            }
            if (dspaceObject instanceof Bitstream) {
                Bitstream bit = (Bitstream)dspaceObject;
                Bundle[] bundles = bit.getBundles();
                docBuilder.field("bundleName").startArray();
                for (Bundle bundle : bundles) {
                    docBuilder.value(bundle.getName());
                }
                docBuilder.endArray();
            }
            this.storeParents(docBuilder, this.getParents(dspaceObject));
            docBuilder.endObject();
            if (docBuilder != null) {
                IndexRequestBuilder irb = client.prepareIndex(indexName, indexType).setSource(docBuilder);
                if (client == null) {
                    log.error((Object)"Hey, client is null");
                }
                irb.execute().actionGet();
            }
        }
        catch (RuntimeException re) {
            log.error((Object)("RunTimer in ESL:\n" + ExceptionUtils.getStackTrace((Throwable)re)));
            throw re;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        finally {
            client.close();
        }
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static void setClusterName(String clusterName) {
        ElasticSearchLogger.clusterName = clusterName;
    }

    public static String getIndexName() {
        return indexName;
    }

    public static void setIndexName(String indexName) {
        ElasticSearchLogger.indexName = indexName;
    }

    public static String getIndexType() {
        return indexType;
    }

    public static void setIndexType(String indexType) {
        ElasticSearchLogger.indexType = indexType;
    }

    public static String getAddress() {
        return address;
    }

    public static void setAddress(String address) {
        ElasticSearchLogger.address = address;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        ElasticSearchLogger.port = port;
    }

    public void buildParents(DSpaceObject dso, HashMap<String, ArrayList<Integer>> parents) throws SQLException {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(dso instanceof Community)) break block5;
                        for (Community comm = (Community)dso; comm != null && comm.getParentCommunity() != null; comm = comm.getParentCommunity()) {
                            parents.get("owningComm").add(comm.getID());
                        }
                        break block6;
                    }
                    if (!(dso instanceof Collection)) break block7;
                    Collection coll = (Collection)dso;
                    for (Community community : coll.getCommunities()) {
                        parents.get("owningComm").add(community.getID());
                        this.buildParents(community, parents);
                    }
                    break block6;
                }
                if (!(dso instanceof Item)) break block8;
                Item item = (Item)dso;
                for (Collection collection : item.getCollections()) {
                    parents.get("owningColl").add(collection.getID());
                    this.buildParents(collection, parents);
                }
                break block6;
            }
            if (!(dso instanceof Bitstream)) break block6;
            Bitstream bitstream = (Bitstream)dso;
            for (Bundle bundle : bitstream.getBundles()) {
                for (Item item : bundle.getItems()) {
                    parents.get("owningItem").add(item.getID());
                    this.buildParents(item, parents);
                }
            }
        }
    }

    public HashMap<String, ArrayList<Integer>> getParents(DSpaceObject dso) throws SQLException {
        HashMap<String, ArrayList<Integer>> parents = new HashMap<String, ArrayList<Integer>>();
        parents.put("owningComm", new ArrayList());
        parents.put("owningColl", new ArrayList());
        parents.put("owningItem", new ArrayList());
        this.buildParents(dso, parents);
        return parents;
    }

    public void storeParents(XContentBuilder docBuilder, HashMap<String, ArrayList<Integer>> parents) throws IOException {
        for (String key : parents.keySet()) {
            ArrayList<Integer> ids = parents.get(key);
            if (ids.size() <= 0) continue;
            docBuilder.field(key).startArray();
            for (Integer i : ids) {
                docBuilder.value(i);
            }
            docBuilder.endArray();
        }
    }

    public boolean isUseProxies() {
        return useProxies;
    }

    public void createTransportClient() {
        clusterName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "clusterName", clusterName);
        indexName = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexName", indexName);
        indexType = this.getConfigurationStringWithFallBack("elastic-search-statistics", "indexType", indexType);
        address = this.getConfigurationStringWithFallBack("elastic-search-statistics", "address", address);
        port = ConfigurationManager.getIntProperty("elastic-search-statistics", "port", port);
        log.info((Object)("Creating TransportClient to [Address:" + address + "] [Port:" + port + "] [cluster.name:" + clusterName + "]"));
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).build();
        client = new TransportClient(settings).addTransportAddress((TransportAddress)new InetSocketTransportAddress(address, port));
    }

    public Client getClient() {
        return this.getClient(ClientType.NODE);
    }

    public Client getClient(ClientType clientType) {
        if (client == null) {
            log.error((Object)"getClient reports null client");
            if (clientType == ClientType.TRANSPORT) {
                this.createTransportClient();
            } else {
                this.createNodeClient(clientType);
            }
        }
        return client;
    }

    public Client createNodeClient(ClientType clientType) {
        String dspaceDir = ConfigurationManager.getProperty("dspace.dir");
        Settings settings = ImmutableSettings.settingsBuilder().put("path.data", dspaceDir + "/elasticsearch/").build();
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().clusterName(clusterName).data(true).settings(settings);
        if (clientType == ClientType.LOCAL) {
            log.info((Object)"Create a Local Node.");
            nodeBuilder = nodeBuilder.local(true);
        } else if (clientType == ClientType.NODE) {
            log.info((Object)"Create a nodeClient, allows transport clients to connect");
            nodeBuilder = nodeBuilder.local(false);
        }
        Node node = nodeBuilder.node();
        log.info((Object)"Got node");
        client = node.client();
        log.info((Object)"Created new node client");
        return client;
    }

    public String getConfigurationStringWithFallBack(String module, String configurationKey, String defaultFallbackValue) {
        String configDrivenValue = ConfigurationManager.getProperty(module, configurationKey);
        if (configDrivenValue == null || configDrivenValue.trim().equalsIgnoreCase("")) {
            return defaultFallbackValue;
        }
        return configDrivenValue;
    }

    static {
        clusterName = "dspacestatslogging";
        indexName = "dspaceindex";
        indexType = "stats";
        address = "127.0.0.1";
        port = 9300;
    }

    private static class ElasticSearchLoggerSingletonHolder {
        public static final ElasticSearchLogger instance = new ElasticSearchLogger(true);

        private ElasticSearchLoggerSingletonHolder() {
        }
    }

    public static enum ClientType {
        NODE,
        LOCAL,
        TRANSPORT;

    }
}

