/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.discovery.SolrServiceSearchPlugin;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class SolrServiceResourceRestrictionPlugin
implements SolrServiceIndexPlugin,
SolrServiceSearchPlugin {
    private static final Logger log = Logger.getLogger(SolrServiceResourceRestrictionPlugin.class);

    @Override
    public void additionalIndex(Context context, DSpaceObject dso, SolrInputDocument document) {
        try {
            List<ResourcePolicy> policies = AuthorizeManager.getPoliciesActionFilter(context, dso, 0);
            for (ResourcePolicy resourcePolicy : policies) {
                String fieldValue = resourcePolicy.getGroupID() != -1 ? "g" + resourcePolicy.getGroupID() : "e" + resourcePolicy.getEPersonID();
                document.addField("read", (Object)fieldValue);
            }
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(context, "Error while indexing resource policies", "DSpace object: (id " + dso.getID() + " type " + dso.getType() + ")"));
        }
    }

    @Override
    public void additionalSearchParameters(Context context, DiscoverQuery discoveryQuery, SolrQuery solrQuery) {
        StringBuilder resourceQuery = new StringBuilder();
        resourceQuery.append("read:(g0");
        EPerson currentUser = context.getCurrentUser();
        if (currentUser != null) {
            try {
                resourceQuery.append(" OR e").append(currentUser.getID());
                Set<Integer> groupIds = Group.allMemberGroupIDs(context, currentUser);
                for (Integer groupId : groupIds) {
                    resourceQuery.append(" OR g").append(groupId);
                }
            }
            catch (SQLException e) {
                log.error((Object)LogManager.getHeader(context, "Error while adding resource policy information to query", ""), (Throwable)e);
            }
        }
        resourceQuery.append(")");
        try {
            if (AuthorizeManager.isAdmin(context)) {
                resourceQuery.append(" OR (!read[* TO *])");
            }
        }
        catch (SQLException e) {
            log.error((Object)LogManager.getHeader(context, "Error while verifying if current user is admin !", ""), (Throwable)e);
        }
        solrQuery.addFilterQuery(new String[]{resourceQuery.toString()});
    }
}

