/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dspace.app.bulkedit.DSpaceCSV;

public class DSpaceCSVLine
implements Serializable {
    private int id;
    private Map<String, ArrayList> items;

    public DSpaceCSVLine(int itemId) {
        this.id = itemId;
        this.items = new HashMap<String, ArrayList>();
    }

    public DSpaceCSVLine() {
        this.id = -1;
        this.items = new HashMap<String, ArrayList>();
    }

    public int getID() {
        return this.id;
    }

    public void add(String key, String value) {
        if (this.items.get(key) == null) {
            this.items.put(key, new ArrayList());
        }
        if (value != null) {
            this.items.get(key).add(value);
        }
    }

    public List<String> get(String key) {
        return this.items.get(key);
    }

    public String getAction() {
        ArrayList actions;
        if (this.items.containsKey("action") && (actions = this.items.get("action")).size() > 0) {
            return ((String)actions.get(0)).trim();
        }
        return "";
    }

    public Set<String> keys() {
        return this.items.keySet();
    }

    protected String toCSV(List<String> headings) {
        StringBuilder bits = new StringBuilder();
        bits.append("\"").append(this.id).append("\"").append(DSpaceCSV.fieldSeparator);
        bits.append(this.valueToCSV(this.items.get("collection")));
        for (String heading : headings) {
            bits.append(DSpaceCSV.fieldSeparator);
            List values = this.items.get(heading);
            if (values == null || "collection".equals(heading)) continue;
            bits.append(this.valueToCSV(values));
        }
        return bits.toString();
    }

    protected String valueToCSV(List<String> values) {
        String s;
        if (values == null) {
            return "";
        }
        if (values.size() == 1) {
            s = values.get(0);
        } else {
            StringBuilder str = new StringBuilder();
            for (String value : values) {
                if (str.length() > 0) {
                    str.append(DSpaceCSV.valueSeparator);
                }
                str.append(value);
            }
            s = str.toString();
        }
        return "\"" + s.replaceAll("\"", "\"\"") + "\"";
    }
}

