/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.TokenMgrError;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.search.DSIndexer;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;

public class DSQuery {
    static final String ALL = "999";
    static final String ITEM = "2";
    static final String COLLECTION = "3";
    static final String COMMUNITY = "4";
    private static IndexSearcher searcher = null;
    private static String indexDir = null;
    private static String operator = null;
    private static long lastModified;
    private static Logger log;

    public static QueryResults doQuery(Context c, QueryArgs args) throws IOException {
        String querystring = args.getQuery();
        QueryResults qr = new QueryResults();
        ArrayList<String> hitHandles = new ArrayList<String>();
        ArrayList<Integer> hitIds = new ArrayList<Integer>();
        ArrayList<Integer> hitTypes = new ArrayList<Integer>();
        qr.setHitHandles(hitHandles);
        qr.setHitIds(hitIds);
        qr.setHitTypes(hitTypes);
        qr.setStart(args.getStart());
        qr.setPageSize(args.getPageSize());
        qr.setEtAl(args.getEtAl());
        querystring = DSQuery.checkEmptyQuery(querystring);
        querystring = DSQuery.stripHandles(querystring);
        querystring = DSQuery.stripAsterisk(querystring);
        try {
            Date startTime = new Date();
            IndexSearcher searcher = DSQuery.getSearcher(c);
            QueryParser qp = new QueryParser(DSIndexer.luceneVersion, "default", DSIndexer.getAnalyzer());
            log.debug((Object)("Final query string: " + querystring));
            if (operator == null || operator.equals("OR")) {
                qp.setDefaultOperator(QueryParser.OR_OPERATOR);
            } else {
                qp.setDefaultOperator(QueryParser.AND_OPERATOR);
            }
            Query myquery = qp.parse(querystring);
            TopDocs hits = DSQuery.performQuery(args, searcher, myquery, args.getPageSize() * (args.getStart() + 1));
            Date endTime = new Date();
            qr.setQueryTime(endTime.getTime() - startTime.getTime());
            qr.setHitCount(hits.totalHits);
            if (args.getStart() < hits.totalHits) {
                int hitsRemaining = hits.totalHits - args.getStart();
                int hitsToProcess = hitsRemaining < args.getPageSize() ? hitsRemaining : args.getPageSize();
                for (int i = args.getStart(); i < args.getStart() + hitsToProcess; ++i) {
                    Document d = searcher.doc(hits.scoreDocs[i].doc);
                    String resourceId = d.get("search.resourceid");
                    String resourceType = d.get("search.resourcetype");
                    String handleText = d.get("handle");
                    String handleType = d.get("type");
                    switch (Integer.parseInt(resourceType != null ? resourceType : handleType)) {
                        case 2: {
                            hitTypes.add(2);
                            break;
                        }
                        case 3: {
                            hitTypes.add(3);
                            break;
                        }
                        case 4: {
                            hitTypes.add(4);
                        }
                    }
                    hitHandles.add(handleText);
                    hitIds.add(resourceId == null ? null : Integer.valueOf(Integer.parseInt(resourceId)));
                }
            }
        }
        catch (NumberFormatException e) {
            log.warn((Object)LogManager.getHeader(c, "Number format exception", "" + e));
            qr.setErrorMsg("number-format-exception");
        }
        catch (ParseException e) {
            log.warn((Object)LogManager.getHeader(c, "Invalid search string", "" + (Object)((Object)e)));
            qr.setErrorMsg("invalid-search-string");
        }
        catch (TokenMgrError tme) {
            log.warn((Object)LogManager.getHeader(c, "Invalid search string", "" + (Object)((Object)tme)));
            qr.setErrorMsg("invalid-search-string");
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.warn((Object)LogManager.getHeader(c, "Query too broad", e.toString()));
            qr.setErrorMsg("query-too-broad");
        }
        return qr;
    }

    private static TopDocs performQuery(QueryArgs args, IndexSearcher searcher, Query myquery, int max) throws IOException {
        TopFieldDocs hits;
        try {
            if (args.getSortOption() == null) {
                SortField[] sortFields = new SortField[]{new SortField("search.resourcetype", SortField.Type.INT, true), new SortField(null, SortField.FIELD_SCORE.getType(), "ASC".equals(args.getSortOrder()))};
                hits = searcher.search(myquery, max, new Sort(sortFields));
            } else {
                SortField[] sortFields = new SortField[]{new SortField("search.resourcetype", SortField.Type.INT, true), new SortField("sort_" + args.getSortOption().getName(), SortField.Type.STRING, "DESC".equals(args.getSortOrder())), SortField.FIELD_SCORE};
                hits = searcher.search(myquery, max, new Sort(sortFields));
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to use speficied sort option: " + (args.getSortOption() == null ? "type/relevance" : args.getSortOption().getName())));
            hits = searcher.search(myquery, max, new Sort(SortField.FIELD_SCORE));
        }
        return hits;
    }

    static String checkEmptyQuery(String myquery) {
        if (myquery == null || myquery.equals("()") || myquery.equals("")) {
            myquery = "empty_query_string";
        }
        return myquery;
    }

    static String workAroundLuceneBug(String myquery) {
        return myquery.replaceAll(" AND ", " && ").replaceAll(" OR ", " || ").replaceAll(" NOT ", " ! ").toLowerCase();
    }

    static String stripHandles(String myquery) {
        return myquery.replaceAll("^\\s*http://hdl\\.handle\\.net/", "").replaceAll("^\\s*hdl:", "");
    }

    static String stripAsterisk(String myquery) {
        return myquery.replaceAll("^\\*", "").replaceAll("\\s\\*", " ").replaceAll("\\(\\*", "(").replaceAll(":\\*", ":");
    }

    public static QueryResults doQuery(Context c, QueryArgs args, Collection coll) throws IOException {
        String querystring = args.getQuery();
        querystring = DSQuery.checkEmptyQuery(querystring);
        String location = "l" + coll.getID();
        String newquery = "+(" + querystring + ") +location:\"" + location + "\"";
        args.setQuery(newquery);
        return DSQuery.doQuery(c, args);
    }

    public static QueryResults doQuery(Context c, QueryArgs args, Community comm) throws IOException {
        String querystring = args.getQuery();
        querystring = DSQuery.checkEmptyQuery(querystring);
        String location = "m" + comm.getID();
        String newquery = "+(" + querystring + ") +location:\"" + location + "\"";
        args.setQuery(newquery);
        return DSQuery.doQuery(c, args);
    }

    public static void doCMDLineQuery(String query) {
        System.out.println("Command line query: " + query);
        System.out.println("Only reporting default-sized results list");
        try {
            Context c = new Context();
            QueryArgs args = new QueryArgs();
            args.setQuery(query);
            QueryResults results = DSQuery.doQuery(c, args);
            Iterator<String> i = results.getHitHandles().iterator();
            Iterator<Integer> j = results.getHitTypes().iterator();
            while (i.hasNext()) {
                String thisHandle = i.next();
                Integer thisType = j.next();
                String type = Constants.typeText[thisType];
                System.out.println(type + "\t" + thisHandle);
            }
        }
        catch (Exception e) {
            System.out.println("Exception caught: " + e);
        }
    }

    public static synchronized void close() {
        if (searcher != null) {
            try {
                searcher.getIndexReader().close();
                searcher = null;
            }
            catch (IOException ioe) {
                log.error((Object)"DSQuery: Unable to close open IndexSearcher", (Throwable)ioe);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            DSQuery.doCMDLineQuery(args[0]);
        }
    }

    protected static IndexReader getIndexReader() throws IOException {
        return DSQuery.getSearcher(null).getIndexReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized IndexSearcher getSearcher(Context c) throws IOException {
        FSDirectory searchDir = FSDirectory.open((File)new File(indexDir));
        DirectoryReader reader = DirectoryReader.open((Directory)searchDir);
        if (searcher != null && lastModified != reader.getVersion()) {
            try {
                searcher.getIndexReader().close();
            }
            catch (IOException ioe) {
                log.warn((Object)"DSQuery: Unable to check for updated index", (Throwable)ioe);
            }
            finally {
                searcher = null;
            }
        }
        if (searcher == null) {
            lastModified = reader.getVersion();
            searcher = new IndexSearcher((IndexReader)reader);
        }
        return searcher;
    }

    static {
        log = Logger.getLogger(DSQuery.class);
        String maxClauses = ConfigurationManager.getProperty("search.max-clauses");
        if (maxClauses != null) {
            BooleanQuery.setMaxClauseCount((int)Integer.parseInt(maxClauses));
        }
        indexDir = ConfigurationManager.getProperty("search.dir");
        operator = ConfigurationManager.getProperty("search.operator");
    }
}

