/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpException;
import org.dspace.core.Context;
import org.dspace.submit.lookup.CrossRefService;
import org.dspace.submit.lookup.NetworkSubmissionLookupDataLoader;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class CrossRefOnlineDataLoader
extends NetworkSubmissionLookupDataLoader {
    private CrossRefService crossrefService = new CrossRefService();
    private boolean searchProvider = true;

    public void setSearchProvider(boolean searchProvider) {
        this.searchProvider = searchProvider;
    }

    public void setCrossrefService(CrossRefService crossrefService) {
        this.crossrefService = crossrefService;
    }

    @Override
    public List<String> getSupportedIdentifiers() {
        return Arrays.asList("doi");
    }

    @Override
    public List<Record> getByIdentifier(Context context, Map<String, Set<String>> keys) throws HttpException, IOException {
        if (keys != null && keys.containsKey("doi")) {
            Set<String> dois = keys.get("doi");
            List<Record> items = null;
            ArrayList<Record> results = new ArrayList<Record>();
            try {
                items = this.crossrefService.search(context, dois);
            }
            catch (JDOMException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            for (Record record : items) {
                results.add(this.convertFields(record));
            }
            return results;
        }
        return null;
    }

    @Override
    public List<Record> search(Context context, String title, String author, int year) throws HttpException, IOException {
        List<Record> items = this.crossrefService.search(context, title, author, year, 10);
        return items;
    }

    @Override
    public boolean isSearchProvider() {
        return this.searchProvider;
    }
}

