/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.bulkedit.DSpaceCSV;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class MetadataExport {
    private ItemIterator toExport;
    private boolean exportAll;

    public MetadataExport(Context c, ItemIterator toExport, boolean exportAll) {
        this.toExport = toExport;
        this.exportAll = exportAll;
    }

    public MetadataExport(Context c, Community toExport, boolean exportAll) {
        try {
            this.toExport = new ItemIterator(c, this.buildFromCommunity(toExport, new ArrayList<Integer>(), 0));
            this.exportAll = exportAll;
        }
        catch (SQLException sqle) {
            System.err.println("Error running exporter:");
            sqle.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private List<Integer> buildFromCommunity(Community community, List<Integer> itemIDs, int indent) throws SQLException {
        Community[] communities;
        Collection[] collections;
        for (Collection collection : collections = community.getCollections()) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            ItemIterator items = collection.getAllItems();
            while (items.hasNext()) {
                int id = items.next().getID();
                if (itemIDs.contains(id)) continue;
                itemIDs.add(id);
            }
        }
        for (Community subCommunity : communities = community.getSubcommunities()) {
            for (int i = 0; i < indent; ++i) {
                System.out.print(" ");
            }
            this.buildFromCommunity(subCommunity, itemIDs, indent + 1);
        }
        return itemIDs;
    }

    public DSpaceCSV export() {
        try {
            DSpaceCSV csv = new DSpaceCSV(this.exportAll);
            while (this.toExport.hasNext()) {
                csv.addItem(this.toExport.next());
            }
            return csv;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void printHelp(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("MetadataExport\n", options);
        System.out.println("\nfull export: metadataexport -f filename");
        System.out.println("partial export: metadataexport -i handle -f filename");
        System.exit(exitCode);
    }

    public static void main(String[] argv) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("i", "id", true, "ID or handle of thing to export (item, collection, or community)");
        options.addOption("f", "file", true, "destination where you want file written");
        options.addOption("a", "all", false, "include all metadata fields that are not normally changed (e.g. provenance)");
        options.addOption("h", "help", false, "help");
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (ParseException pe) {
            System.err.println("Error with commands.");
            MetadataExport.printHelp(options, 1);
            System.exit(0);
        }
        if (line.hasOption('h')) {
            MetadataExport.printHelp(options, 0);
        }
        if (!line.hasOption('f')) {
            System.err.println("Required parameter -f missing!");
            MetadataExport.printHelp(options, 1);
        }
        String filename = line.getOptionValue('f');
        Context c = new Context();
        c.turnOffAuthorisationSystem();
        ItemIterator toExport = null;
        MetadataExport exporter = null;
        boolean exportAll = line.hasOption('a');
        if (!line.hasOption('i')) {
            System.out.println("Exporting whole repository WARNING: May take some time!");
            exporter = new MetadataExport(c, Item.findAll(c), exportAll);
        } else {
            String handle = line.getOptionValue('i');
            DSpaceObject dso = HandleManager.resolveToObject(c, handle);
            if (dso == null) {
                System.err.println("Item '" + handle + "' does not resolve to an item in your repository!");
                MetadataExport.printHelp(options, 1);
            }
            if (dso.getType() == 2) {
                System.out.println("Exporting item '" + dso.getName() + "' (" + handle + ")");
                ArrayList<Integer> item = new ArrayList<Integer>();
                item.add(dso.getID());
                exporter = new MetadataExport(c, new ItemIterator(c, item), exportAll);
            } else if (dso.getType() == 3) {
                System.out.println("Exporting collection '" + dso.getName() + "' (" + handle + ")");
                Collection collection = (Collection)dso;
                toExport = collection.getAllItems();
                exporter = new MetadataExport(c, toExport, exportAll);
            } else if (dso.getType() == 4) {
                System.out.println("Exporting community '" + dso.getName() + "' (" + handle + ")");
                exporter = new MetadataExport(c, (Community)dso, exportAll);
            } else {
                System.err.println("Error identifying '" + handle + "'");
                System.exit(1);
            }
        }
        DSpaceCSV csv = exporter.export();
        csv.save(filename);
        c.restoreAuthSystemState();
        c.complete();
    }
}

