/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public abstract class DSpaceObject {
    private StringBuffer eventDetails = null;

    protected void clearDetails() {
        this.eventDetails = null;
    }

    protected void addDetails(String d) {
        if (this.eventDetails == null) {
            this.eventDetails = new StringBuffer(d);
        } else {
            this.eventDetails.append(", ").append(d);
        }
    }

    protected String getDetails() {
        return this.eventDetails == null ? null : this.eventDetails.toString();
    }

    public abstract int getType();

    public String getTypeText() {
        return Constants.typeText[this.getType()];
    }

    public abstract int getID();

    public abstract String getHandle();

    public abstract String getName();

    public static DSpaceObject find(Context context, int type, int id) throws SQLException {
        switch (type) {
            case 0: {
                return Bitstream.find(context, id);
            }
            case 1: {
                return Bundle.find(context, id);
            }
            case 2: {
                return Item.find(context, id);
            }
            case 3: {
                return Collection.find(context, id);
            }
            case 4: {
                return Community.find(context, id);
            }
            case 6: {
                return Group.find(context, id);
            }
            case 7: {
                return EPerson.find(context, id);
            }
            case 5: {
                return Site.find(context, id);
            }
        }
        return null;
    }

    public DSpaceObject getAdminObject(int action) throws SQLException {
        if (action == 11) {
            throw new IllegalArgumentException("Illegal call to the DSpaceObject.getAdminObject method");
        }
        return this;
    }

    public DSpaceObject getParentObject() throws SQLException {
        return null;
    }

    public abstract void update() throws SQLException, AuthorizeException;

    public abstract void updateLastModified();
}

