/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import org.dspace.identifier.IdentifierException;

public class DOIIdentifierException
extends IdentifierException {
    public static final int CODE_NOT_SET = 0;
    public static final int DOI_DOES_NOT_EXIST = 1;
    public static final int DOI_ALREADY_EXISTS = 2;
    public static final int FOREIGN_DOI = 3;
    public static final int BAD_ANSWER = 4;
    public static final int BAD_REQUEST = 5;
    public static final int REGISTER_FIRST = 6;
    public static final int AUTHENTICATION_ERROR = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int CONVERSION_ERROR = 9;
    public static final int MISMATCH = 10;
    public static final int UNRECOGNIZED = 11;
    public static final int UNAUTHORIZED_METADATA_MANIPULATION = 12;
    public static final int DOI_IS_DELETED = 13;
    private int code;

    public static String codeToString(int code) {
        switch (code) {
            case 0: {
                return "CODE_NOT_SET";
            }
            case 1: {
                return "DOI_DOES_NOT_EXSIT";
            }
            case 2: {
                return "DOI_ALREADY_EXISTS";
            }
            case 3: {
                return "FOREIGN_DOI";
            }
            case 4: {
                return "BAD_ANSWER";
            }
            case 6: {
                return "REGISTER_FIRST";
            }
            case 7: {
                return "AUTHENTICATION_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "CONVERSION_ERROR";
            }
            case 10: {
                return "MISMATCH";
            }
            case 11: {
                return "UNRECOGNIZED";
            }
            case 12: {
                return "UNAUTHORIZED_METADATA_MANIPULATION";
            }
            case 13: {
                return "DELETED";
            }
        }
        return "UNKOWN";
    }

    public DOIIdentifierException() {
        this.code = 0;
    }

    public DOIIdentifierException(int code) {
        this.code = code;
    }

    public DOIIdentifierException(String message) {
        super(message);
        this.code = 0;
    }

    public DOIIdentifierException(String message, int code) {
        super(message);
        this.code = code;
    }

    public DOIIdentifierException(String message, Throwable cause) {
        super(message, cause);
        this.code = 0;
    }

    public DOIIdentifierException(String message, Throwable cause, int code) {
        super(message, cause);
        this.code = code;
    }

    public DOIIdentifierException(Throwable cause) {
        super(cause);
        this.code = 0;
    }

    public DOIIdentifierException(Throwable cause, int code) {
        super(cause);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if ((message == null || message.isEmpty()) && this.code != 0) {
            return DOIIdentifierException.codeToString(this.code);
        }
        return message;
    }
}

