/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.doi;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.handle.HandleManager;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.utils.DSpace;

public class DOIOrganiser {
    private static final Logger LOG = Logger.getLogger(DOIOrganiser.class);
    private DOIIdentifierProvider provider;
    private Context context;
    private boolean quiet;

    public DOIOrganiser(Context context, DOIIdentifierProvider provider) {
        this.context = context;
        this.provider = provider;
        this.quiet = false;
    }

    public static void main(String[] args) {
        LOG.debug((Object)"Starting DOI organiser ");
        Context context = null;
        try {
            context = new Context();
        }
        catch (SQLException sqle) {
            System.err.println("Can't connect to database: " + sqle.getMessage());
            System.exit(-1);
        }
        context.turnOffAuthorisationSystem();
        DOIOrganiser organiser = new DOIOrganiser(context, (DOIIdentifierProvider)new DSpace().getSingletonService(DOIIdentifierProvider.class));
        DOIOrganiser.runCLI(context, organiser, args);
        try {
            context.complete();
        }
        catch (SQLException sqle) {
            System.err.println("Cannot save changes to database: " + sqle.getMessage());
            System.exit(-1);
        }
    }

    public static void runCLI(Context context, DOIOrganiser organiser, String[] args) {
        String identifier;
        DSpaceObject dso;
        TableRow doiRow;
        TableRowIterator it;
        Options options = new Options();
        options.addOption("h", "help", false, "Help");
        options.addOption("l", "list", false, "List all objects to be reserved, registered, deleted of updated ");
        options.addOption("r", "register-all", false, "Perform online registration for all identifiers queued for registration.");
        options.addOption("s", "reserve-all", false, "Perform online reservation for all identifiers queued for reservation.");
        options.addOption("u", "update-all", false, "Perform online metadata update for all identifiers queued for metadata update.");
        options.addOption("d", "delete-all", false, "Perform online deletion for all identifiers queued for deletion.");
        options.addOption("q", "quiet", false, "Turn the command line output off.");
        OptionBuilder.withArgName((String)"DOI|ItemID|handle");
        OptionBuilder.withLongOpt((String)"register-doi");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Register a specified identifier. You can specify the identifier by ItemID, Handle or DOI.");
        Option registerDoi = OptionBuilder.create();
        options.addOption(registerDoi);
        OptionBuilder.withArgName((String)"DOI|ItemID|handle");
        OptionBuilder.withLongOpt((String)"reserve-doi");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Reserve a specified identifier online. You can specify the identifier by ItemID, Handle or DOI.");
        Option reserveDoi = OptionBuilder.create();
        options.addOption(reserveDoi);
        OptionBuilder.withArgName((String)"DOI|ItemID|handle");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Update online an object for a given DOI identifier or ItemID or Handle. A DOI identifier or an ItemID or a Handle is needed.\n");
        OptionBuilder.withLongOpt((String)"update-doi");
        Option update = OptionBuilder.create();
        options.addOption(update);
        OptionBuilder.withArgName((String)"DOI identifier");
        OptionBuilder.withLongOpt((String)"delete-doi");
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.withDescription((String)"Delete a specified identifier.");
        Option delete = OptionBuilder.create();
        options.addOption(delete);
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        HelpFormatter helpformater = new HelpFormatter();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            LOG.fatal((Object)ex);
            System.exit(1);
        }
        if (line.hasOption('h') || 0 == line.getOptions().length) {
            helpformater.printHelp("\nDOI organiser\n", options);
        }
        if (line.hasOption('q')) {
            organiser.setQuiet();
        }
        if (line.hasOption('l')) {
            organiser.list("reservation", null, null, DOIIdentifierProvider.TO_BE_RESERVERED);
            organiser.list("registration", null, null, DOIIdentifierProvider.TO_BE_REGISTERED);
            organiser.list("update", null, null, DOIIdentifierProvider.UPDATE_BEFORE_REGISTERATION, DOIIdentifierProvider.UPDATE_REGISTERED, DOIIdentifierProvider.UPDATE_RESERVERED);
            organiser.list("deletion", null, null, DOIIdentifierProvider.TO_BE_DELETED);
        }
        if (line.hasOption('s')) {
            it = organiser.getDOIsByStatus(DOIIdentifierProvider.TO_BE_RESERVERED);
            try {
                if (!it.hasNext()) {
                    System.err.println("There are no objects in the database that could be reserved.");
                }
                while (it.hasNext()) {
                    doiRow = it.next();
                    dso = DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                    organiser.reserve(doiRow, dso);
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('r')) {
            it = organiser.getDOIsByStatus(DOIIdentifierProvider.TO_BE_REGISTERED);
            try {
                if (!it.hasNext()) {
                    System.err.println("There are no objects in the database that could be registered.");
                }
                while (it.hasNext()) {
                    doiRow = it.next();
                    dso = DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                    organiser.register(doiRow, dso);
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('u')) {
            it = organiser.getDOIsByStatus(DOIIdentifierProvider.UPDATE_BEFORE_REGISTERATION, DOIIdentifierProvider.UPDATE_RESERVERED, DOIIdentifierProvider.UPDATE_REGISTERED);
            try {
                if (!it.hasNext()) {
                    System.err.println("There are no objects in the database whose metadata needs an update.");
                }
                while (it.hasNext()) {
                    doiRow = it.next();
                    dso = DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                    organiser.update(doiRow, dso);
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption('d')) {
            it = organiser.getDOIsByStatus(DOIIdentifierProvider.TO_BE_DELETED);
            try {
                if (!it.hasNext()) {
                    System.err.println("There are no objects in the database that could be deleted.");
                }
                while (it.hasNext()) {
                    doiRow = it.next();
                    organiser.delete(doiRow.getStringColumn("doi"));
                }
            }
            catch (SQLException ex) {
                System.err.println("Error in database connection:" + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        if (line.hasOption("reserve-doi")) {
            identifier = line.getOptionValue("reserve-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.findTableRow(identifier);
                    dso = DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                    organiser.reserve(doiRow, dso);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex);
                }
                catch (IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("register-doi")) {
            identifier = line.getOptionValue("register-doi");
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.findTableRow(identifier);
                    dso = DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                    organiser.register(doiRow, dso);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex);
                }
                catch (IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("update-doi")) {
            identifier = line.getOptionValue('u');
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    doiRow = organiser.findTableRow(identifier);
                    dso = DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                    organiser.update(doiRow, dso);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalStateException ex) {
                    LOG.error((Object)ex);
                }
                catch (IdentifierException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
        if (line.hasOption("delete-doi")) {
            identifier = line.getOptionValue('d');
            if (null == identifier) {
                helpformater.printHelp("\nDOI organiser\n", options);
            } else {
                try {
                    organiser.delete(identifier);
                }
                catch (SQLException ex) {
                    LOG.error((Object)ex);
                }
                catch (IllegalArgumentException ex) {
                    LOG.error((Object)ex);
                }
            }
        }
    }

    public TableRowIterator getDOIsByStatus(Integer ... status) {
        try {
            String sql = "SELECT * FROM Doi";
            for (int i = 0; i < status.length; ++i) {
                sql = 0 == i ? sql + " WHERE " : sql + " OR ";
                sql = sql + " status = ?";
            }
            if (status.length < 1) {
                return DatabaseManager.queryTable(this.context, "Doi", sql, new Object[0]);
            }
            return DatabaseManager.queryTable(this.context, "Doi", sql, status);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error while trying to get data from database", (Throwable)ex);
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(String processName, PrintStream out, PrintStream err, Integer ... status) {
        String indent = "    ";
        if (null == out) {
            out = System.out;
        }
        if (null == err) {
            err = System.err;
        }
        TableRowIterator it = this.getDOIsByStatus(status);
        try {
            if (it.hasNext()) {
                out.println("DOIs queued for " + processName + ": ");
            } else {
                out.println("There are no DOIs queued for " + processName + ".");
            }
            while (it.hasNext()) {
                TableRow doiRow = it.next();
                DSpaceObject dso = DSpaceObject.find(this.context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
                out.print(indent + "doi:" + doiRow.getStringColumn("doi"));
                if (null != dso) {
                    out.println(" (belongs to item with handle " + dso.getHandle() + ")");
                    continue;
                }
                out.println(" (cannot determine handle of assigned object)");
            }
            out.println("");
        }
        catch (SQLException ex) {
            err.println("Error in database Connection: " + ex.getMessage());
            ex.printStackTrace(err);
        }
        finally {
            it.close();
        }
    }

    public void register(TableRow doiRow, DSpaceObject dso) throws SQLException {
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.registerOnline(this.context, dso, "doi:" + doiRow.getStringColumn("doi"));
            if (!this.quiet) {
                System.out.println("This identifier: doi:" + doiRow.getStringColumn("doi") + " is successfully registered.");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error((Object)("It wasn't possible to register this identifier: doi:" + doiRow.getStringColumn("doi") + " online. "), (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Register", dso, "doi:" + doiRow.getStringColumn("doi"), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error((Object)"Couldn't send mail", (Throwable)ioe);
            }
            LOG.error((Object)("It wasn't possible to register this identifier : doi:" + doiRow.getStringColumn("doi") + " online. Exceptions code: " + DOIIdentifierException.codeToString(doiIdentifierException.getCode())), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getStringColumn("doi") + "!"), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getStringColumn("doi") + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error while trying to get data from database", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to register this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    public void reserve(TableRow doiRow, DSpaceObject dso) throws SQLException {
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.reserveOnline(this.context, dso, "doi:" + doiRow.getStringColumn("doi"));
            if (!this.quiet) {
                System.out.println("This identifier : doi:" + doiRow.getStringColumn("doi") + " is successfully reserved.");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error((Object)("It wasn't possible to register this identifier : doi:" + doiRow.getStringColumn("doi") + " online. "), (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Reserve", dso, "doi:" + doiRow.getStringColumn("doi"), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error((Object)"Couldn't send mail", (Throwable)ioe);
            }
            LOG.error((Object)("It wasn't possible to reserve the identifier online.  Exceptions code:  " + DOIIdentifierException.codeToString(doiIdentifierException.getCode())), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getStringColumn("doi") + "!"), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getStringColumn("doi") + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error((Object)"Error while trying to get data from database", (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to reserve this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
            throw new RuntimeException("Error while trying to get data from database", ex);
        }
    }

    public void update(TableRow doiRow, DSpaceObject dso) {
        if (2 != dso.getType()) {
            throw new IllegalArgumentException("Currenty DSpace supports DOIs for Items only.");
        }
        try {
            this.provider.updateMetadataOnline(this.context, dso, "doi:" + doiRow.getStringColumn("doi"));
            if (!this.quiet) {
                System.out.println("Successfully updated metadata of DOI doi:" + doiRow.getStringColumn("doi") + ".");
            }
        }
        catch (IdentifierException ex) {
            if (!(ex instanceof DOIIdentifierException)) {
                LOG.error((Object)"It wasn't possible to register the identifier online. ", (Throwable)ex);
            }
            DOIIdentifierException doiIdentifierException = (DOIIdentifierException)ex;
            try {
                this.sendAlertMail("Update", dso, "doi:" + doiRow.getStringColumn("doi"), DOIIdentifierException.codeToString(doiIdentifierException.getCode()));
            }
            catch (IOException ioe) {
                LOG.error((Object)"Couldn't send mail", (Throwable)ioe);
            }
            LOG.error((Object)("It wasn't possible to update this identifier:  doi:" + doiRow.getStringColumn("doi") + " Exceptions code:  " + DOIIdentifierException.codeToString(doiIdentifierException.getCode())), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to update this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.error((Object)("Database table DOI contains a DOI that is not valid: doi:" + doiRow.getStringColumn("doi") + "!"), (Throwable)ex);
            if (!this.quiet) {
                System.err.println("It wasn't possible to update this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
            throw new IllegalStateException("Database table DOI contains a DOI  that is not valid: doi:" + doiRow.getStringColumn("doi") + "!", ex);
        }
        catch (SQLException ex) {
            LOG.error((Object)"It wasn't possible to connect to the Database!", (Throwable)ex);
        }
    }

    public void delete(String identifier) throws SQLException {
        block6: {
            String doi = null;
            TableRow doiRow = null;
            try {
                doi = DOI.formatIdentifier(identifier);
                doiRow = DatabaseManager.findByUnique(this.context, "Doi", "doi", doi.substring("doi:".length()));
                if (null == doiRow) {
                    throw new IllegalStateException("You specified a valid DOI, that is not stored in our database.");
                }
                this.provider.deleteOnline(this.context, doi);
                if (!this.quiet) {
                    System.err.println("It was possible to delete this identifier: doi:" + doiRow.getStringColumn("doi") + " online.");
                }
            }
            catch (DOIIdentifierException ex) {
                LOG.error((Object)("It wasn't possible to detect this identifier:  " + identifier + " Exceptions code:  " + DOIIdentifierException.codeToString(ex.getCode())), (Throwable)ex);
                if (!this.quiet) {
                    System.err.println("It wasn't possible to detect this identifier: " + identifier);
                }
            }
            catch (IllegalArgumentException ex) {
                if (this.quiet) break block6;
                System.err.println("It wasn't possible to delete this identifier: doi:" + doiRow.getStringColumn("doi") + " online. Take a look in log file.");
            }
        }
    }

    public TableRow findTableRow(String identifier) throws SQLException, IllegalArgumentException, IllegalStateException, IdentifierException {
        TableRow doiRow;
        block10: {
            if (null == identifier || identifier.isEmpty()) {
                throw new IllegalArgumentException("Identifier is null or empty.");
            }
            String sql = "SELECT * FROM Doi WHERE resource_type_id = ? AND resource_id = ? ";
            doiRow = null;
            String doi = null;
            if (identifier.matches("\\d*")) {
                Integer itemID = Integer.valueOf(identifier);
                Item dso = Item.find(this.context, itemID);
                if (null != dso) {
                    doiRow = DatabaseManager.querySingleTable(this.context, "Doi", sql, 2, ((DSpaceObject)dso).getID());
                    if (null == doiRow) {
                        doi = this.provider.mint(this.context, dso);
                        doiRow = DatabaseManager.findByUnique(this.context, "Doi", "doi", doi.substring("doi:".length()));
                        return doiRow;
                    }
                    return doiRow;
                }
                throw new IllegalStateException("You specified an ItemID, that is not stored in our database.");
            }
            DSpaceObject dso = HandleManager.resolveToObject(this.context, identifier);
            if (null != dso) {
                if (dso.getType() != 2) {
                    throw new IllegalArgumentException("Currently DSpace supports DOIs for Items only. Cannot process specified handle as it does not identify an Item.");
                }
                doiRow = DatabaseManager.querySingleTable(this.context, "Doi", sql, 2, dso.getID());
                if (null == doiRow) {
                    doi = this.provider.mint(this.context, dso);
                    doiRow = DatabaseManager.findByUnique(this.context, "Doi", "doi", doi.substring("doi:".length()));
                }
                return doiRow;
            }
            try {
                doi = DOI.formatIdentifier(identifier);
                doiRow = DatabaseManager.findByUnique(this.context, "Doi", "doi", doi.substring("doi:".length()));
                if (null == doiRow) {
                    throw new IllegalStateException("You specified a valid DOI, that is not stored in our database.");
                }
            }
            catch (DOIIdentifierException ex) {
                LOG.error((Object)("It wasn't possible to detect this identifier:  " + identifier + " Exceptions code:  " + DOIIdentifierException.codeToString(ex.getCode())), (Throwable)ex);
                if (this.quiet) break block10;
                System.err.println("It wasn't possible to detect this identifier: doi:" + doiRow.getStringColumn("doi"));
            }
        }
        return doiRow;
    }

    private void sendAlertMail(String action, DSpaceObject dso, String doi, String reason) throws IOException {
        block4: {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            try {
                if (recipient != null) {
                    Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "doi_maintenance_error"));
                    email.addRecipient(recipient);
                    email.addArgument(action);
                    email.addArgument(new Date());
                    email.addArgument(dso.getTypeText());
                    email.addArgument(new Integer(dso.getID()));
                    email.addArgument(doi);
                    email.addArgument(reason);
                    email.send();
                    if (!this.quiet) {
                        System.err.println("Email alert is sent.");
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to send email alert", (Throwable)e);
                if (this.quiet) break block4;
                System.err.println("Unable to send email alert.");
            }
        }
    }

    private void setQuiet() {
        this.quiet = true;
    }
}

