/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.dspace.core.ConfigurationManager;
import org.dspace.sort.SortOption;

public class QueryArgs {
    private String query;
    private int start = 0;
    private int pageSize = 10;
    private SortOption sortOption = null;
    private String sortOrder = "DESC";
    private int etAl = ConfigurationManager.getIntProperty("webui.itemlist.author-limit");

    public int getEtAl() {
        return this.etAl;
    }

    public void setEtAl(int etAl) {
        this.etAl = etAl;
    }

    public void setQuery(String newQuery) {
        this.query = newQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setStart(int newStart) {
        this.start = newStart;
    }

    public int getStart() {
        return this.start;
    }

    public void setPageSize(int newSize) {
        this.pageSize = newSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public SortOption getSortOption() {
        return this.sortOption;
    }

    public void setSortOption(SortOption sortOption) {
        this.sortOption = sortOption;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String buildQuery(HttpServletRequest request) {
        String newquery = "(";
        String numFieldStr = request.getParameter("num_search_field");
        if (numFieldStr == null) {
            numFieldStr = "3";
        }
        int numField = Integer.parseInt(numFieldStr);
        ArrayList<String> query = new ArrayList<String>();
        ArrayList<String> field = new ArrayList<String>();
        ArrayList<String> conjunction = new ArrayList<String>();
        for (int i = 1; i <= numField; ++i) {
            String tmp_query = request.getParameter("query" + i);
            String tmp_field = request.getParameter("field" + i);
            if (tmp_field != null) {
                tmp_field = tmp_field.replace('/', ' ');
                tmp_field = tmp_field.replace('<', ' ');
                tmp_field = tmp_field.replace('\\', ' ');
                tmp_field = tmp_field.replace(':', ' ');
            }
            if (tmp_query == null || tmp_query.equals("")) continue;
            query.add(tmp_query.trim());
            if (tmp_field == null) {
                field.add("ANY");
            } else {
                field.add(tmp_field.trim());
            }
            if (i == numField) continue;
            conjunction.add(request.getParameter("conjunction" + i) != null ? request.getParameter("conjunction" + i) : "AND");
        }
        Iterator iquery = query.iterator();
        Iterator ifield = field.iterator();
        Iterator iconj = conjunction.iterator();
        String conj_curr = "";
        while (iquery.hasNext()) {
            newquery = newquery + conj_curr;
            String query_curr = (String)iquery.next();
            String field_curr = (String)ifield.next();
            newquery = newquery + this.buildQueryPart(query_curr, field_curr);
            if (!iconj.hasNext()) continue;
            conj_curr = " " + (String)iconj.next() + " ";
        }
        newquery = newquery + ")";
        return newquery;
    }

    private String buildQueryPart(String myquery, String myfield) {
        StringBuilder newQuery = new StringBuilder();
        newQuery.append("(");
        boolean newTerm = true;
        boolean inPhrase = false;
        char phraseChar = '\"';
        StringTokenizer qtok = new StringTokenizer(myquery, " \t\n\r\f\"'", true);
        while (qtok.hasMoreTokens()) {
            String token = qtok.nextToken();
            if (StringUtils.isWhitespace((String)token)) {
                if (!inPhrase) {
                    newTerm = true;
                }
                newQuery.append(token);
                continue;
            }
            if (inPhrase && token.charAt(0) == phraseChar) {
                newQuery.append("\"");
                inPhrase = false;
                continue;
            }
            if (!newTerm && token.charAt(0) == '\'') {
                newQuery.append(token);
                continue;
            }
            if (!newTerm && token.charAt(0) == '\"') {
                newQuery.append(" ");
                newTerm = true;
            }
            if (newTerm && !myfield.equals("ANY")) {
                newQuery.append(myfield).append(":");
            }
            if (token.charAt(0) == '\"' || token.charAt(0) == '\'') {
                newQuery.append("\"");
                inPhrase = true;
                newTerm = false;
                phraseChar = token.charAt(0);
                continue;
            }
            newQuery.append(token);
            newTerm = false;
        }
        newQuery.append(")");
        return newQuery.toString();
    }

    public Map<String, String> buildQueryMap(HttpServletRequest request) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        String numFieldStr = request.getParameter("num_search_field");
        if (numFieldStr == null) {
            numFieldStr = "3";
        }
        int numField = Integer.parseInt(numFieldStr);
        for (int i = 1; i < numField; ++i) {
            String queryStr = "query" + i;
            String fieldStr = "field" + i;
            String conjunctionStr = "conjunction" + i;
            queryMap.put(queryStr, StringUtils.defaultString((String)request.getParameter(queryStr), (String)""));
            queryMap.put(fieldStr, StringUtils.defaultString((String)request.getParameter(fieldStr), (String)"ANY"));
            queryMap.put(conjunctionStr, StringUtils.defaultString((String)request.getParameter(conjunctionStr), (String)"AND"));
        }
        String queryStr = "query" + numField;
        String fieldStr = "field" + numField;
        queryMap.put(queryStr, StringUtils.defaultString((String)request.getParameter(queryStr), (String)""));
        queryMap.put(fieldStr, StringUtils.defaultString((String)request.getParameter(fieldStr), (String)"ANY"));
        return queryMap;
    }

    public String buildHTTPQuery(HttpServletRequest request) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        Map<String, String> queryMap = this.buildQueryMap(request);
        for (Map.Entry<String, String> query : queryMap.entrySet()) {
            queryString.append("&").append(query.getKey()).append("=").append(URLEncoder.encode(query.getValue(), "UTF-8"));
        }
        if (request.getParameter("num_search_field") != null) {
            queryString.append("&num_search_field=").append(request.getParameter("num_search_field"));
        }
        return queryString.substring(1);
    }
}

