/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.LinkedList;
import java.util.List;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.util.SubmissionLookupPublication;
import org.w3c.dom.Element;

public class ArxivUtils {
    public static Record convertArxixDomToRecord(Element dataRoot) {
        LinkedList<StringValue> values;
        String journalRef;
        String doi;
        List<Element> links;
        String comment;
        String splashPageUrl;
        String year;
        String summary;
        SubmissionLookupPublication record = new SubmissionLookupPublication("");
        String articleTitle = XMLUtils.getElementValue(dataRoot, "title");
        if (articleTitle != null) {
            record.addValue("title", (Value)new StringValue(articleTitle));
        }
        if ((summary = XMLUtils.getElementValue(dataRoot, "summary")) != null) {
            record.addValue("summary", (Value)new StringValue(summary));
        }
        if ((year = XMLUtils.getElementValue(dataRoot, "published")) != null) {
            record.addValue("published", (Value)new StringValue(year));
        }
        if ((splashPageUrl = XMLUtils.getElementValue(dataRoot, "id")) != null) {
            record.addValue("id", (Value)new StringValue(splashPageUrl));
        }
        if ((comment = XMLUtils.getElementValue(dataRoot, "arxiv:comment")) != null) {
            record.addValue("comment", (Value)new StringValue(comment));
        }
        if ((links = XMLUtils.getElementList(dataRoot, "link")) != null) {
            for (Element link : links) {
                String pdfUrl;
                if (!"related".equals(link.getAttribute("rel")) || !"pdf".equals(link.getAttribute("title")) || (pdfUrl = link.getAttribute("href")) == null) continue;
                record.addValue("pdfUrl", (Value)new StringValue(pdfUrl));
            }
        }
        if ((doi = XMLUtils.getElementValue(dataRoot, "arxiv:doi")) != null) {
            record.addValue("doi", (Value)new StringValue(doi));
        }
        if ((journalRef = XMLUtils.getElementValue(dataRoot, "arxiv:journal_ref")) != null) {
            record.addValue("journalRef", (Value)new StringValue(journalRef));
        }
        LinkedList<String> primaryCategory = new LinkedList<String>();
        List<Element> primaryCategoryList = XMLUtils.getElementList(dataRoot, "arxiv:primary_category");
        if (primaryCategoryList != null) {
            for (Element primaryCategoryElement : primaryCategoryList) {
                primaryCategory.add(primaryCategoryElement.getAttribute("term"));
            }
        }
        if (primaryCategory.size() > 0) {
            LinkedList<StringValue> values2 = new LinkedList<StringValue>();
            for (String s : primaryCategory) {
                values2.add(new StringValue(s));
            }
            record.addField("primaryCategory", values2);
        }
        LinkedList<String> category = new LinkedList<String>();
        List<Element> categoryList = XMLUtils.getElementList(dataRoot, "category");
        if (categoryList != null) {
            for (Element categoryElement : categoryList) {
                category.add(categoryElement.getAttribute("term"));
            }
        }
        if (category.size() > 0) {
            LinkedList<StringValue> values3 = new LinkedList<StringValue>();
            for (String s : category) {
                values3.add(new StringValue(s));
            }
            record.addField("category", values3);
        }
        LinkedList<String> authors = new LinkedList<String>();
        LinkedList<String> authorsWithAffiliations = new LinkedList<String>();
        List<Element> authorList = XMLUtils.getElementList(dataRoot, "author");
        if (authorList != null) {
            for (Element authorElement : authorList) {
                String authorName = XMLUtils.getElementValue(authorElement, "name");
                String authorAffiliation = XMLUtils.getElementValue(authorElement, "arxiv:affiliation");
                authors.add(authorName);
                authorsWithAffiliations.add(authorName + ": " + authorAffiliation);
            }
        }
        if (authors.size() > 0) {
            values = new LinkedList<StringValue>();
            for (String sArray : authors) {
                values.add(new StringValue(sArray));
            }
            record.addField("author", values);
        }
        if (authorsWithAffiliations.size() > 0) {
            values = new LinkedList();
            for (String sArray : authorsWithAffiliations) {
                values.add(new StringValue(sArray));
            }
            record.addField("authorWithAffiliation", values);
        }
        return record;
    }
}

