/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.itunes.EntryInformationImpl;
import com.sun.syndication.feed.module.itunes.types.Duration;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.feed.synd.SyndPersonImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.handle.HandleManager;
import org.w3c.dom.Document;

public class SyndicationFeed {
    private static final Logger log = Logger.getLogger(SyndicationFeed.class);
    public static final String MSG_UNTITLED = "notitle";
    public static final String MSG_LOGO_TITLE = "logo.title";
    public static final String MSG_FEED_TITLE = "feed.title";
    public static final String MSG_FEED_DESCRIPTION = "general-feed.description";
    public static final String MSG_METADATA = "metadata.";
    public static final String MSG_UITYPE = "ui.type";
    public static final String UITYPE_XMLUI = "xmlui";
    public static final String UITYPE_JSPUI = "jspui";
    private static String defaultTitleField = "dc.title";
    private static String defaultAuthorField = "dc.contributor.author";
    private static String defaultDateField = "dc.date.issued";
    private static String defaultDescriptionFields = "dc.description.abstract, dc.description, dc.title.alternative, dc.title";
    private static String defaultExternalMedia = "dc.source.uri";
    private static String titleField = SyndicationFeed.getDefaultedConfiguration("webui.feed.item.title", defaultTitleField);
    private static String dateField = SyndicationFeed.getDefaultedConfiguration("webui.feed.item.date", defaultDateField);
    private static String[] descriptionFields = SyndicationFeed.getDefaultedConfiguration("webui.feed.item.description", defaultDescriptionFields).split("\\s*,\\s*");
    private static String authorField = SyndicationFeed.getDefaultedConfiguration("webui.feed.item.author", defaultAuthorField);
    private static String externalSourceField = SyndicationFeed.getDefaultedConfiguration("webui.feed.podcast.sourceuri", defaultExternalMedia);
    private static String dcCreatorField = ConfigurationManager.getProperty("webui.feed.item.dc.creator");
    private static String dcDateField = ConfigurationManager.getProperty("webui.feed.item.dc.date");
    private static String dcDescriptionField = ConfigurationManager.getProperty("webui.feed.item.dc.description");
    private static String podcastableMIMETypes = SyndicationFeed.getDefaultedConfiguration("webui.feed.podcast.mimetypes", "audio/x-mpeg");
    private SyndFeed feed = new SyndFeedImpl();
    private String uiType = null;
    private HttpServletRequest request = null;
    private String baseURL = null;

    public SyndicationFeed(String ui) {
        this.uiType = ui;
    }

    public static String[] getDescriptionSelectors() {
        return (String[])ArrayUtils.clone((Object[])descriptionFields);
    }

    public void populate(HttpServletRequest request, DSpaceObject dso, DSpaceObject[] items, Map<String, String> labels) {
        String logoURL = null;
        String objectURL = null;
        String defaultTitle = null;
        boolean podcastFeed = false;
        this.request = request;
        if (dso == null) {
            defaultTitle = ConfigurationManager.getProperty("dspace.name");
            this.feed.setDescription(this.localize(labels, MSG_FEED_DESCRIPTION));
            objectURL = this.resolveURL(request, null);
            logoURL = ConfigurationManager.getProperty("webui.feed.logo.url");
        } else {
            Bitstream logo = null;
            if (dso.getType() == 3) {
                Collection col = (Collection)dso;
                defaultTitle = col.getMetadata("name");
                this.feed.setDescription(col.getMetadata("short_description"));
                logo = col.getLogo();
                String cols = ConfigurationManager.getProperty("webui.feed.podcast.collections");
                if (cols != null && cols.length() > 1 && cols.contains(col.getHandle())) {
                    podcastFeed = true;
                }
            } else if (dso.getType() == 4) {
                Community comm = (Community)dso;
                defaultTitle = comm.getMetadata("name");
                this.feed.setDescription(comm.getMetadata("short_description"));
                logo = comm.getLogo();
                String comms = ConfigurationManager.getProperty("webui.feed.podcast.communities");
                if (comms != null && comms.length() > 1 && comms.contains(comm.getHandle())) {
                    podcastFeed = true;
                }
            }
            objectURL = this.resolveURL(request, dso);
            if (logo != null) {
                logoURL = this.urlOfBitstream(request, logo);
            }
        }
        this.feed.setTitle(labels.containsKey(MSG_FEED_TITLE) ? this.localize(labels, MSG_FEED_TITLE) : defaultTitle);
        this.feed.setLink(objectURL);
        this.feed.setPublishedDate(new Date());
        this.feed.setUri(objectURL);
        if (logoURL != null) {
            SyndImageImpl image = new SyndImageImpl();
            image.setLink(objectURL);
            if (StringUtils.isNotBlank((String)this.feed.getTitle())) {
                image.setTitle(this.feed.getTitle());
            } else {
                image.setTitle(this.localize(labels, MSG_LOGO_TITLE));
            }
            image.setUrl(logoURL);
            this.feed.setImage((SyndImage)image);
        }
        if (items != null) {
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (DSpaceObject itemDSO : items) {
                String subject;
                String extent;
                DCValue[] authors;
                if (itemDSO.getType() != 2) continue;
                Item item = (Item)itemDSO;
                boolean hasDate = false;
                SyndEntryImpl entry = new SyndEntryImpl();
                entries.add(entry);
                String entryURL = this.resolveURL(request, item);
                entry.setLink(entryURL);
                entry.setUri(entryURL);
                String title = this.getOneDC(item, titleField);
                entry.setTitle(title == null ? this.localize(labels, MSG_UNTITLED) : title);
                String pubDate = this.getOneDC(item, dateField);
                if (pubDate != null) {
                    entry.setPublishedDate(new DCDate(pubDate).toDate());
                    hasDate = true;
                }
                entry.setUpdatedDate(item.getLastModified());
                StringBuffer db = new StringBuffer();
                for (String df : descriptionFields) {
                    DCValue[] dcv;
                    boolean isDate;
                    boolean bl = isDate = df.indexOf("(date)") > 0;
                    if (isDate) {
                        df = df.replaceAll("\\(date\\)", "");
                    }
                    if ((dcv = item.getMetadata(df)).length <= 0) continue;
                    String fieldLabel = labels.get(MSG_METADATA + df);
                    if (fieldLabel != null && fieldLabel.length() > 0) {
                        db.append(fieldLabel).append(": ");
                    }
                    boolean first = true;
                    for (DCValue v : dcv) {
                        if (first) {
                            first = false;
                        } else {
                            db.append("; ");
                        }
                        db.append(isDate ? new DCDate(v.value).toString() : v.value);
                    }
                    db.append("\n");
                }
                if (db.length() > 0) {
                    SyndContentImpl desc = new SyndContentImpl();
                    desc.setType("text/plain");
                    desc.setValue(db.toString());
                    entry.setDescription((SyndContent)desc);
                }
                if ((authors = item.getMetadata(authorField)).length > 0) {
                    ArrayList<SyndPersonImpl> creators = new ArrayList<SyndPersonImpl>();
                    for (DCValue author : authors) {
                        SyndPersonImpl sp = new SyndPersonImpl();
                        sp.setName(author.value);
                        creators.add(sp);
                    }
                    entry.setAuthors(creators);
                }
                if (dcCreatorField != null || dcDateField != null || dcDescriptionField != null) {
                    DCValue[] v;
                    DCValue[] dcAuthors;
                    DCModuleImpl dc = new DCModuleImpl();
                    if (dcCreatorField != null && (dcAuthors = item.getMetadata(dcCreatorField)).length > 0) {
                        ArrayList<String> creators = new ArrayList<String>();
                        for (DCValue author : dcAuthors) {
                            creators.add(author.value);
                        }
                        dc.setCreators(creators);
                    }
                    if (dcDateField != null && !hasDate && (v = item.getMetadata(dcDateField)).length > 0) {
                        dc.setDate(new DCDate(v[0].value).toDate());
                    }
                    if (dcDescriptionField != null && (v = item.getMetadata(dcDescriptionField)).length > 0) {
                        StringBuffer descs = new StringBuffer();
                        for (DCValue d : v) {
                            if (descs.length() > 0) {
                                descs.append("\n\n");
                            }
                            descs.append(d.value);
                        }
                        dc.setDescription(descs.toString());
                    }
                    entry.getModules().add(dc);
                }
                if (!podcastFeed) continue;
                ArrayList<SyndEnclosureImpl> enclosures = new ArrayList<SyndEnclosureImpl>();
                try {
                    DCValue[] externalMedia;
                    Bundle[] bunds = item.getBundles("ORIGINAL");
                    if (bunds[0] != null) {
                        Bitstream[] bits = bunds[0].getBitstreams();
                        for (int i = 0; i < bits.length; ++i) {
                            String mime = bits[i].getFormat().getMIMEType();
                            if (!podcastableMIMETypes.contains(mime)) continue;
                            SyndEnclosureImpl enc = new SyndEnclosureImpl();
                            enc.setType(bits[i].getFormat().getMIMEType());
                            enc.setLength(bits[i].getSize());
                            enc.setUrl(this.urlOfBitstream(request, bits[i]));
                            enclosures.add(enc);
                        }
                    }
                    if ((externalMedia = item.getMetadata(externalSourceField)).length > 0) {
                        for (int i = 0; i < externalMedia.length; ++i) {
                            SyndEnclosureImpl enc = new SyndEnclosureImpl();
                            enc.setType("audio/x-mpeg");
                            enc.setLength(1L);
                            enc.setUrl(externalMedia[i].value);
                            enclosures.add(enc);
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                entry.setEnclosures(enclosures);
                EntryInformationImpl itunes = new EntryInformationImpl();
                String author = this.getOneDC(item, authorField);
                if (author != null && author.length() > 0) {
                    itunes.setAuthor(author);
                }
                itunes.setSubtitle(title == null ? this.localize(labels, MSG_UNTITLED) : title);
                if (db.length() > 0) {
                    itunes.setSummary(db.toString());
                }
                if ((extent = this.getOneDC(item, "dc.format.extent")) != null && extent.length() > 0) {
                    extent = extent.split(" ")[0];
                    Integer duration = Integer.parseInt(extent);
                    itunes.setDuration(new Duration((long)duration.intValue()));
                }
                if ((subject = this.getOneDC(item, "dc.subject")) != null && subject.length() > 0) {
                    String[] subjects = new String[]{subject};
                    itunes.setKeywords(subjects);
                }
                entry.getModules().add(itunes);
            }
            this.feed.setEntries(entries);
        }
    }

    public void setType(String feedType) {
        this.feed.setFeedType(feedType);
        if ("rss_1.0".equals(feedType)) {
            this.feed.setImage(null);
        }
    }

    public Document outputW3CDom() throws FeedException {
        try {
            SyndFeedOutput feedWriter = new SyndFeedOutput();
            return feedWriter.outputW3CDom(this.feed);
        }
        catch (FeedException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public String outputString() throws FeedException {
        SyndFeedOutput feedWriter = new SyndFeedOutput();
        return feedWriter.outputString(this.feed);
    }

    public void output(Writer writer) throws FeedException, IOException {
        SyndFeedOutput feedWriter = new SyndFeedOutput();
        feedWriter.output(this.feed, writer);
    }

    public void addModule(Module m) {
        this.feed.getModules().add(m);
    }

    private static String getDefaultedConfiguration(String key, String dfl) {
        String result = ConfigurationManager.getProperty(key);
        return result == null ? dfl : result;
    }

    private String urlOfBitstream(HttpServletRequest request, Bitstream logo) {
        String name = logo.getName();
        return this.resolveURL(request, null) + (this.uiType.equalsIgnoreCase(UITYPE_XMLUI) ? "/bitstream/id/" : "/retrieve/") + logo.getID() + "/" + (name == null ? "" : name);
    }

    private String resolveURL(HttpServletRequest request, DSpaceObject dso) {
        if (dso == null) {
            if (this.baseURL == null) {
                if (request == null) {
                    this.baseURL = ConfigurationManager.getProperty("dspace.url");
                } else {
                    this.baseURL = request.isSecure() ? "https://" : "http://";
                    this.baseURL = this.baseURL + ConfigurationManager.getProperty("dspace.hostname");
                    this.baseURL = this.baseURL + ":" + request.getServerPort();
                    this.baseURL = this.baseURL + request.getContextPath();
                }
            }
            return this.baseURL;
        }
        if (ConfigurationManager.getBooleanProperty("webui.feed.localresolve")) {
            return this.resolveURL(request, null) + "/handle/" + dso.getHandle();
        }
        return HandleManager.getCanonicalForm(dso.getHandle());
    }

    private String localize(Map<String, String> labels, String s) {
        return labels.containsKey(s) ? labels.get(s) : "Untranslated:" + s;
    }

    private String getOneDC(Item item, String field) {
        DCValue[] dcv = item.getMetadata(field);
        return dcv.length > 0 ? dcv[0].value : null;
    }
}

