/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.submit.lookup.CrossRefUtils;
import org.dspace.submit.lookup.SubmissionLookupUtils;
import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CrossRefService {
    private static final Logger log = Logger.getLogger(CrossRefService.class);
    private int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> search(Context context, Set<String> dois, String apiKey) throws HttpException, IOException, JDOMException, ParserConfigurationException, SAXException {
        ArrayList<Record> results = new ArrayList<Record>();
        if (dois != null && dois.size() > 0) {
            for (String record : dois) {
                try {
                    GetMethod method = null;
                    try {
                        HttpClient client = new HttpClient();
                        client.setConnectionTimeout(this.timeout);
                        method = new GetMethod("http://www.crossref.org/openurl/");
                        NameValuePair pid = new NameValuePair("pid", apiKey);
                        NameValuePair noredirect = new NameValuePair("noredirect", "true");
                        NameValuePair id = new NameValuePair("id", record);
                        method.setQueryString(new NameValuePair[]{pid, noredirect, id});
                        int statusCode = client.executeMethod((HttpMethod)method);
                        if (statusCode != 200) {
                            throw new RuntimeException("Http call failed: " + method.getStatusLine());
                        }
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            factory.setValidating(false);
                            factory.setIgnoringComments(true);
                            factory.setIgnoringElementContentWhitespace(true);
                            DocumentBuilder db = factory.newDocumentBuilder();
                            Document inDoc = db.parse(method.getResponseBodyAsStream());
                            Element xmlRoot = inDoc.getDocumentElement();
                            Element queryResult = XMLUtils.getSingleElement(xmlRoot, "query_result");
                            Element body = XMLUtils.getSingleElement(queryResult, "body");
                            Element dataRoot = XMLUtils.getSingleElement(body, "query");
                            Record crossitem = CrossRefUtils.convertCrossRefDomToRecord(dataRoot);
                            results.add(crossitem);
                        }
                        catch (Exception e) {
                            log.warn((Object)LogManager.getHeader(context, "retrieveRecordDOI", record + " DOI is not valid or not exist: " + e.getMessage()));
                        }
                    }
                    finally {
                        if (method != null) {
                            method.releaseConnection();
                        }
                    }
                }
                catch (RuntimeException rt) {
                    log.error((Object)rt.getMessage(), (Throwable)rt);
                }
            }
        }
        return results;
    }

    public NameValuePair[] buildQueryPart(String title, String author, int year, int count) {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank((String)title)) {
            sb.append(title);
        }
        sb.append(" ");
        if (StringUtils.isNotBlank((String)author)) {
            sb.append(author);
        }
        String q = sb.toString().trim();
        NameValuePair qParam = new NameValuePair("q", title);
        NameValuePair yearParam = new NameValuePair("year", year != -1 ? String.valueOf(year) : "");
        NameValuePair countParam = new NameValuePair("rows", count != -1 ? String.valueOf(count) : "");
        NameValuePair[] query = new NameValuePair[]{qParam, yearParam, countParam};
        return query;
    }

    public List<Record> search(Context context, String title, String authors, int year, int count, String apiKey) throws IOException, HttpException {
        GetMethod method = null;
        try {
            NameValuePair[] query = this.buildQueryPart(title, authors, year, count);
            HttpClient client = new HttpClient();
            client.setTimeout(this.timeout);
            method = new GetMethod("http://search.labs.crossref.org/dois");
            method.setQueryString(query);
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                throw new RuntimeException("Http call failed:: " + method.getStatusLine());
            }
            Gson gson = new Gson();
            Type listType = new TypeToken<ArrayList<Map>>(){}.getType();
            List json = (List)gson.fromJson(method.getResponseBodyAsString(), listType);
            HashSet<String> dois = new HashSet<String>();
            for (Map r : json) {
                dois.add(SubmissionLookupUtils.normalizeDOI((String)r.get("doi")));
            }
            method.releaseConnection();
            List<Record> list = this.search(context, dois, apiKey);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

