/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.versioning.Version;

public class VersionImpl
implements Version {
    private int versionId;
    private EPerson eperson;
    private int itemID = -1;
    private Date versionDate;
    private int versionNumber;
    private String summary;
    private int versionHistoryID;
    private Context myContext;
    private TableRow myRow;

    protected VersionImpl(Context c, TableRow row) {
        this.myContext = c;
        this.myRow = row;
        c.cache(this, row.getIntColumn("versionitem_id"));
    }

    @Override
    public int getVersionId() {
        return this.myRow.getIntColumn("versionitem_id");
    }

    protected void setVersionId(int versionId) {
        this.versionId = versionId;
    }

    @Override
    public EPerson getEperson() {
        try {
            if (this.eperson == null) {
                return EPerson.find(this.myContext, this.myRow.getIntColumn("eperson_id"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.eperson;
    }

    public void setEperson(EPerson ePerson) {
        this.eperson = ePerson;
        this.myRow.setColumn("eperson_id", ePerson.getID());
    }

    @Override
    public int getItemID() {
        return this.myRow.getIntColumn("item_id");
    }

    @Override
    public Item getItem() {
        try {
            if (this.getItemID() == -1) {
                return null;
            }
            return Item.find(this.myContext, this.getItemID());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setItemID(int itemID) {
        this.itemID = itemID;
        this.myRow.setColumn("item_id", itemID);
    }

    @Override
    public Date getVersionDate() {
        return this.myRow.getDateColumn("version_date");
    }

    public void setVersionDate(Date versionDate) {
        this.versionDate = versionDate;
        this.myRow.setColumn("version_date", versionDate);
    }

    @Override
    public int getVersionNumber() {
        return this.myRow.getIntColumn("version_number");
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
        this.myRow.setColumn("version_number", versionNumber);
    }

    @Override
    public String getSummary() {
        return this.myRow.getStringColumn("version_summary");
    }

    public void setSummary(String summary) {
        this.summary = summary;
        this.myRow.setColumn("version_summary", summary);
    }

    @Override
    public int getVersionHistoryID() {
        return this.myRow.getIntColumn("versionhistory_id");
    }

    public void setVersionHistory(int versionHistoryID) {
        this.versionHistoryID = versionHistoryID;
        this.myRow.setColumn("versionhistory_id", versionHistoryID);
    }

    public Context getMyContext() {
        return this.myContext;
    }

    protected TableRow getMyRow() {
        return this.myRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionImpl version = (VersionImpl)o;
        return this.getVersionId() == version.getVersionId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.getVersionId() ^ this.getVersionId() >>> 32);
        return hash;
    }
}

