/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.identifier.Handle;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionDAO;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersionHistoryDAO;
import org.dspace.versioning.VersionHistoryImpl;
import org.dspace.versioning.VersionImpl;
import org.dspace.versioning.VersioningService;
import org.springframework.stereotype.Component;

@Component
public class VersionedHandleIdentifierProvider
extends IdentifierProvider {
    private static Logger log = Logger.getLogger(VersionedHandleIdentifierProvider.class);
    static final String EXAMPLE_PREFIX = "123456789";
    private static final char DOT = '.';
    private String[] supportedPrefixes = new String[]{"info:hdl", "hdl", "http://"};
    private VersionDAO versionDAO;
    private VersionHistoryDAO versionHistoryDAO;

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return Handle.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        for (String prefix : this.supportedPrefixes) {
            if (!identifier.startsWith(prefix)) continue;
            return true;
        }
        try {
            String outOfUrl = VersionedHandleIdentifierProvider.retrieveHandleOutOfUrl(identifier);
            if (outOfUrl != null) {
                return true;
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public String register(Context context, DSpaceObject dso) {
        try {
            String id = this.mint(context, dso);
            if (dso != null && dso.getType() == 2) {
                Item item = (Item)dso;
                VersionHistory history = this.retrieveVersionHistory(context, (Item)dso);
                if (history != null) {
                    String canonical = this.getCanonical(item);
                    TableRow canonicalRecord = VersionedHandleIdentifierProvider.findHandleInternal(context, canonical);
                    this.modifyHandleRecord(context, dso, canonicalRecord, canonical);
                    Version version = history.getVersion(item);
                    Version previous = history.getPrevious(version);
                    if (history.isFirstVersion(previous)) {
                        this.modifyHandleMetadata(previous.getItem(), canonical + '.' + 1);
                    }
                    if (previous != null && VersionedHandleIdentifierProvider.getHandleInternal(context, 2, previous.getItemID()) == null) {
                        this.makeIdentifierBasedOnHistory(context, previous.getItem(), canonical, history);
                    }
                }
                this.populateHandleMetadata(item);
            }
            return id;
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + (dso != null ? Integer.valueOf(dso.getID()) : "")), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + (dso != null ? Integer.valueOf(dso.getID()) : ""));
        }
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) {
        try {
            Item item = (Item)dso;
            VersionHistory itemHistory = this.getHistory(context, identifier);
            if (!identifier.matches(".*/.*\\.\\d+") && itemHistory != null) {
                int newVersionNumber = itemHistory.getLatestVersion().getVersionNumber() + 1;
                String canonical = identifier;
                identifier = identifier.concat(".").concat("" + newVersionNumber);
                this.restoreItAsVersion(context, dso, identifier, item, canonical, itemHistory);
            } else if (identifier.matches(".*/.*\\.\\d+")) {
                String canonical = this.getCanonical(identifier);
                DSpaceObject canonicalItem = this.resolve(context, canonical, new String[0]);
                if (canonicalItem == null) {
                    this.restoreItAsCanonical(context, dso, identifier, item, canonical);
                } else {
                    VersionHistory history = this.retrieveVersionHistory(context, (Item)canonicalItem);
                    if (history == null) {
                        this.restoreItAsCanonical(context, dso, identifier, item, canonical);
                    } else {
                        this.restoreItAsVersion(context, dso, identifier, item, canonical, history);
                    }
                }
            } else {
                this.createNewIdentifier(context, dso, identifier);
                if (dso instanceof Item) {
                    this.populateHandleMetadata(item);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID(), e);
        }
    }

    private VersionHistory getHistory(Context context, String identifier) {
        DSpaceObject item = this.resolve(context, identifier, new String[0]);
        if (item != null) {
            VersionHistory history = this.retrieveVersionHistory(context, (Item)item);
            return history;
        }
        return null;
    }

    private void restoreItAsVersion(Context context, DSpaceObject dso, String identifier, Item item, String canonical, VersionHistory history) throws SQLException, IOException, AuthorizeException {
        this.createNewIdentifier(context, dso, identifier);
        this.populateHandleMetadata(item);
        int versionNumber = Integer.parseInt(identifier.substring(identifier.lastIndexOf(".") + 1));
        this.createVersion(context, history, item, "Restoring from AIP Service", new Date(), versionNumber);
        Version latest = history.getLatestVersion();
        if (latest.getVersionNumber() < versionNumber) {
            TableRow canonicalRecord = VersionedHandleIdentifierProvider.findHandleInternal(context, canonical);
            this.modifyHandleRecord(context, dso, canonicalRecord, canonical);
        }
    }

    private void restoreItAsCanonical(Context context, DSpaceObject dso, String identifier, Item item, String canonical) throws SQLException, IOException, AuthorizeException {
        this.createNewIdentifier(context, dso, identifier);
        this.populateHandleMetadata(item);
        int versionNumber = Integer.parseInt(identifier.substring(identifier.lastIndexOf(".") + 1));
        VersionHistoryImpl history = this.versionHistoryDAO.create(context);
        this.createVersion(context, history, item, "Restoring from AIP Service", new Date(), versionNumber);
        TableRow canonicalRecord = VersionedHandleIdentifierProvider.findHandleInternal(context, canonical);
        this.modifyHandleRecord(context, dso, canonicalRecord, canonical);
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) {
        try {
            TableRow handle = DatabaseManager.create(context, "Handle");
            this.modifyHandleRecord(context, dso, handle, identifier);
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public String mint(Context context, DSpaceObject dso) {
        if (dso.getHandle() != null) {
            return dso.getHandle();
        }
        try {
            String handleId = null;
            VersionHistory history = null;
            if (dso instanceof Item) {
                history = this.retrieveVersionHistory(context, (Item)dso);
            }
            handleId = history != null ? this.makeIdentifierBasedOnHistory(context, dso, handleId, history) : this.createNewIdentifier(context, dso, null);
            return handleId;
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to create handle", "Item id: " + dso.getID()), (Throwable)e);
            throw new RuntimeException("Error while attempting to create identifier for Item id: " + dso.getID());
        }
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) {
        try {
            TableRow dbhandle = VersionedHandleIdentifierProvider.findHandleInternal(context, identifier);
            if (dbhandle == null) {
                if ((identifier = VersionedHandleIdentifierProvider.retrieveHandleOutOfUrl(identifier)) != null) {
                    dbhandle = VersionedHandleIdentifierProvider.findHandleInternal(context, identifier);
                }
                if (dbhandle == null) {
                    return null;
                }
            }
            if (dbhandle.isColumnNull("resource_type_id") || dbhandle.isColumnNull("resource_id")) {
                throw new IllegalStateException("No associated resource type");
            }
            int handletypeid = dbhandle.getIntColumn("resource_type_id");
            int resourceID = dbhandle.getIntColumn("resource_id");
            if (handletypeid == 2) {
                Item item = Item.find(context, resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved handle " + identifier + " to item " + (item == null ? -1 : item.getID())));
                }
                return item;
            }
            if (handletypeid == 3) {
                Collection collection = Collection.find(context, resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved handle " + identifier + " to collection " + (collection == null ? -1 : collection.getID())));
                }
                return collection;
            }
            if (handletypeid == 4) {
                Community community = Community.find(context, resourceID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resolved handle " + identifier + " to community " + (community == null ? -1 : community.getID())));
                }
                return community;
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while resolving handle to item", "handle: " + identifier), (Throwable)e);
        }
        return null;
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        try {
            TableRow row = VersionedHandleIdentifierProvider.getHandleInternal(context, dso.getType(), dso.getID());
            if (row == null) {
                if (dso.getType() == 5) {
                    return Site.getSiteHandle();
                }
                return null;
            }
            return row.getStringColumn("handle");
        }
        catch (SQLException sqe) {
            throw new IdentifierNotResolvableException(sqe.getMessage(), sqe);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        this.delete(context, dso);
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        try {
            Item item;
            VersionHistory history;
            if (dso instanceof Item && (history = this.retrieveVersionHistory(context, item = (Item)dso)) != null && history.getLatestVersion().getItem().equals(item) && history.size() > 1) {
                Item previous = history.getPrevious(history.getLatestVersion()).getItem();
                String canonical = this.getCanonical(previous);
                TableRow canonicalRecord = VersionedHandleIdentifierProvider.findHandleInternal(context, canonical);
                this.modifyHandleRecord(context, previous, canonicalRecord, canonical);
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while attempting to register doi", "Item id: " + dso.getID()), (Throwable)e);
            throw new IdentifierException("Error while moving doi identifier", e);
        }
    }

    public static String retrieveHandleOutOfUrl(String url) throws SQLException {
        if (!url.contains("/")) {
            return null;
        }
        String[] splitUrl = url.split("/");
        return splitUrl[splitUrl.length - 2] + "/" + splitUrl[splitUrl.length - 1];
    }

    public static String getPrefix() {
        String prefix = ConfigurationManager.getProperty("handle.prefix");
        if (null == prefix) {
            prefix = EXAMPLE_PREFIX;
            log.error((Object)("handle.prefix is not configured; using " + prefix));
        }
        return prefix;
    }

    protected static String getCanonicalForm(String handle) {
        String handlePrefix = ConfigurationManager.getProperty("handle.canonical.prefix");
        if (handlePrefix == null || handlePrefix.length() == 0) {
            handlePrefix = "http://hdl.handle.net/";
        }
        return handlePrefix + handle;
    }

    protected String createNewIdentifier(Context context, DSpaceObject dso, String handleId) throws SQLException {
        int previousType;
        TableRow handle = null;
        if (handleId != null) {
            handle = VersionedHandleIdentifierProvider.findHandleInternal(context, handleId);
            if (handle != null && !handle.isColumnNull("resource_id")) {
                int resourceID = handle.getIntColumn("resource_id");
                int resourceType = handle.getIntColumn("resource_type_id");
                if (resourceID == dso.getID() && resourceType == dso.getType()) {
                    return handleId;
                }
                throw new IllegalStateException("Attempted to create a handle which is already in use: " + handleId);
            }
        } else if (handle != null && !handle.isColumnNull("resource_type_id") && (previousType = handle.getIntColumn("resource_type_id")) != dso.getType()) {
            throw new IllegalStateException("Attempted to reuse a handle previously used by a " + Constants.typeText[previousType] + " for a new " + Constants.typeText[dso.getType()]);
        }
        if (handle == null) {
            handle = DatabaseManager.create(context, "Handle");
        }
        if (handleId == null) {
            handleId = VersionedHandleIdentifierProvider.createId(handle.getIntColumn("handle_id"));
        }
        this.modifyHandleRecord(context, dso, handle, handleId);
        return handleId;
    }

    protected String makeIdentifierBasedOnHistory(Context context, DSpaceObject dso, String handleId, VersionHistory history) throws AuthorizeException, SQLException {
        String idNew;
        TableRow handleRow;
        String identifierPreviousItem;
        Item item = (Item)dso;
        Version version = history.getVersion(item);
        Version previous = history.getPrevious(version);
        String canonical = this.getCanonical(previous.getItem());
        if (history.isFirstVersion(previous) && VersionedHandleIdentifierProvider.findHandleInternal(context, identifierPreviousItem = canonical + '.' + 1) == null) {
            TableRow handle = DatabaseManager.create(context, "Handle");
            this.modifyHandleRecord(context, previous.getItem(), handle, identifierPreviousItem);
        }
        if ((handleRow = VersionedHandleIdentifierProvider.findHandleInternal(context, idNew = canonical + '.' + version.getVersionNumber())) == null) {
            handleRow = DatabaseManager.create(context, "Handle");
        }
        this.modifyHandleRecord(context, dso, handleRow, idNew);
        return handleId;
    }

    protected String modifyHandleRecord(Context context, DSpaceObject dso, TableRow handle, String handleId) throws SQLException {
        handle.setColumn("handle", handleId);
        handle.setColumn("resource_type_id", dso.getType());
        handle.setColumn("resource_id", dso.getID());
        DatabaseManager.update(context, handle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new handle for " + Constants.typeText[dso.getType()] + " " + handleId));
        }
        return handleId;
    }

    protected String getCanonical(Item item) {
        String canonical = item.getHandle();
        if (canonical.lastIndexOf(46) != -1) {
            canonical = canonical.substring(0, canonical.lastIndexOf(46));
        }
        return canonical;
    }

    protected String getCanonical(String identifier) {
        String canonical = identifier;
        if (canonical.lastIndexOf(46) != -1) {
            canonical = canonical.substring(0, canonical.lastIndexOf(46));
        }
        return canonical;
    }

    protected static TableRow findHandleInternal(Context context, String handle) throws SQLException {
        if (handle == null) {
            throw new IllegalArgumentException("Handle is null");
        }
        return DatabaseManager.findByUnique(context, "Handle", "handle", handle);
    }

    protected static TableRow getHandleInternal(Context context, int type, int id) throws SQLException {
        String sql = "SELECT * FROM Handle WHERE resource_type_id = ? AND resource_id = ?";
        return DatabaseManager.querySingleTable(context, "Handle", sql, type, id);
    }

    protected static String createId(int id) throws SQLException {
        String handlePrefix = VersionedHandleIdentifierProvider.getPrefix();
        return handlePrefix + (handlePrefix.endsWith("/") ? "" : "/") + id;
    }

    protected VersionHistory retrieveVersionHistory(Context c, Item item) {
        VersioningService versioningService = (VersioningService)new DSpace().getSingletonService(VersioningService.class);
        return versioningService.findVersionHistory(c, item.getID());
    }

    protected void populateHandleMetadata(Item item) throws SQLException, IOException, AuthorizeException {
        DCValue[] identifiers;
        String handleref = VersionedHandleIdentifierProvider.getCanonicalForm(this.getCanonical(item));
        boolean identifierExists = false;
        for (DCValue identifier : identifiers = item.getDC("identifier", "uri", "*")) {
            if (!handleref.equals(identifier.value)) continue;
            identifierExists = true;
        }
        if (!identifierExists) {
            item.addDC("identifier", "uri", null, handleref);
        }
    }

    protected void modifyHandleMetadata(Item item, String handle) throws SQLException, IOException, AuthorizeException {
        String handleref = VersionedHandleIdentifierProvider.getCanonicalForm(handle);
        item.clearMetadata("dc", "identifier", "uri", "*");
        item.addDC("identifier", "uri", null, handleref);
        item.update();
    }

    protected VersionImpl createVersion(Context c, VersionHistory vh, Item item, String summary, Date date, int versionNumber) {
        try {
            VersionImpl version = this.versionDAO.create(c);
            if (vh != null && vh.getVersions() != null) {
                for (Version v : vh.getVersions()) {
                    if (v.getVersionNumber() != versionNumber) continue;
                    throw new RuntimeException("A Version for this versionNumber is already present. Impossible complete the operation.");
                }
            }
            version.setVersionNumber(versionNumber);
            version.setVersionDate(date);
            version.setEperson(item.getSubmitter());
            version.setItemID(item.getID());
            version.setSummary(summary);
            version.setVersionHistory(vh.getVersionHistoryId());
            this.versionDAO.update(version);
            return version;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected int getNextVersionNumer(Version latest) {
        if (latest == null) {
            return 1;
        }
        return latest.getVersionNumber() + 1;
    }

    public void setVersionDAO(VersionDAO versionDAO) {
        this.versionDAO = versionDAO;
    }

    public void setVersionHistoryDAO(VersionHistoryDAO versionHistoryDAO) {
        this.versionHistoryDAO = versionHistoryDAO;
    }
}

