/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.lookup.ArxivUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArXivService {
    private int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public List<Record> getByDOIs(Set<String> dois) throws HttpException, IOException {
        if (dois != null && dois.size() > 0) {
            String doisQuery = StringUtils.join(dois.iterator(), (String)" OR ");
            return this.search(doisQuery, null, 100);
        }
        return null;
    }

    public List<Record> searchByTerm(String title, String author, int year) throws HttpException, IOException {
        StringBuffer query = new StringBuffer();
        if (StringUtils.isNotBlank((String)title)) {
            query.append("ti:\"").append(title).append("\"");
        }
        if (StringUtils.isNotBlank((String)author)) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append("au:\"").append(author).append("\"");
        }
        return this.search(query.toString(), "", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Record> search(String query, String arxivid, int max_result) throws IOException, HttpException {
        ArrayList<Record> results = new ArrayList<Record>();
        GetMethod method = null;
        try {
            HttpClient client = new HttpClient();
            client.setTimeout(this.timeout);
            method = new GetMethod("http://export.arxiv.org/api/query");
            NameValuePair id = new NameValuePair("id_list", arxivid);
            NameValuePair queryParam = new NameValuePair("search_query", query);
            NameValuePair count = new NameValuePair("max_results", String.valueOf(max_result));
            method.setQueryString(new NameValuePair[]{id, queryParam, count});
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                if (statusCode == 400) {
                    throw new RuntimeException("arXiv query is not valid");
                }
                throw new RuntimeException("Http call failed: " + method.getStatusLine());
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                factory.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = factory.newDocumentBuilder();
                Document inDoc = db.parse(method.getResponseBodyAsStream());
                Element xmlRoot = inDoc.getDocumentElement();
                List<Element> dataRoots = XMLUtils.getElementList(xmlRoot, "entry");
                for (Element dataRoot : dataRoots) {
                    Record crossitem = ArxivUtils.convertArxixDomToRecord(dataRoot);
                    if (crossitem == null) continue;
                    results.add(crossitem);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("ArXiv identifier is not valid or not exist");
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return results;
    }

    public Record getByArXivIDs(String raw) throws HttpException, IOException {
        if (StringUtils.isNotBlank((String)raw)) {
            if ((raw = raw.trim()).startsWith("http://arxiv.org/abs/")) {
                raw = raw.substring("http://arxiv.org/abs/".length());
            } else if (raw.toLowerCase().startsWith("arxiv:")) {
                raw = raw.substring("arxiv:".length());
            }
            List<Record> result = this.search("", raw, 1);
            if (result != null && result.size() > 0) {
                return result.get(0);
            }
        }
        return null;
    }
}

