/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.license.CCLookup;
import org.dspace.license.CreativeCommons;
import org.dspace.submit.AbstractProcessingStep;

public class CCLicenseStep
extends AbstractProcessingStep {
    public static final int STATUS_LICENSE_REJECTED = 1;
    private static Logger log = Logger.getLogger(CCLicenseStep.class);

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException, IOException {
        HttpSession session = request.getSession();
        session.setAttribute("inProgress", (Object)"TRUE");
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        if ("submit_grant".equalsIgnoreCase(buttonPressed) || "submit_no_cc".equalsIgnoreCase(buttonPressed)) {
            return this.processCC(context, request, response, subInfo);
        }
        String choiceButton = Util.getSubmitButton(request, "submit_change");
        Enumeration e = request.getParameterNames();
        String isFieldRequired = "FALSE";
        while (e.hasMoreElements()) {
            String parameterName = (String)e.nextElement();
            if (!parameterName.equals("button_required")) continue;
            isFieldRequired = "TRUE";
            break;
        }
        session.setAttribute("isFieldRequired", (Object)isFieldRequired);
        if (choiceButton.equals("submit_change")) {
            Item item = subInfo.getSubmissionItem().getItem();
            CreativeCommons.MdField uriField = CreativeCommons.getCCField("uri");
            CreativeCommons.MdField nameField = CreativeCommons.getCCField("name");
            String licenseUri = uriField.ccItemValue(item);
            if (licenseUri != null) {
                uriField.removeItemValue(item, licenseUri);
                if (ConfigurationManager.getBooleanProperty("cc.submit.setname")) {
                    String licenseName = nameField.keyedItemValue(item, licenseUri);
                    nameField.removeItemValue(item, licenseName);
                }
                if (ConfigurationManager.getBooleanProperty("cc.submit.addBitstream")) {
                    CreativeCommons.removeLicense(context, item);
                }
                this.removeRequiredAttributes(session);
                item.update();
                context.commit();
            }
            return 0;
        }
        if (buttonPressed.startsWith("submit_jump_") || buttonPressed.equals("submit_prev")) {
            this.removeRequiredAttributes(session);
        }
        if (buttonPressed.equals("submit_next") || buttonPressed.equals("submit_cancel")) {
            return this.processCCWS(context, request, response, subInfo);
        }
        this.removeRequiredAttributes(session);
        session.removeAttribute("inProgress");
        return 0;
    }

    protected int processCC(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        String ccLicenseUrl = request.getParameter("cc_license_url");
        if (buttonPressed.equals("submit_no_cc")) {
            CreativeCommons.removeLicense(context, subInfo.getSubmissionItem().getItem());
        } else if (ccLicenseUrl != null && ccLicenseUrl.length() > 0) {
            Item item = subInfo.getSubmissionItem().getItem();
            CreativeCommons.setLicense(context, item, ccLicenseUrl);
        }
        context.commit();
        return 0;
    }

    protected int processCCWS(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String jurisdiction;
        String ccLicenseUrl = request.getParameter("cc_license_url");
        HttpSession session = request.getSession();
        HashMap<String, String> map = new HashMap<String, String>();
        String licenseclass = request.getParameter("licenseclass_chooser") != null ? request.getParameter("licenseclass_chooser") : "";
        String string = jurisdiction = ConfigurationManager.getProperty("cc.license.jurisdiction") != null ? ConfigurationManager.getProperty("cc.license.jurisdiction") : "";
        if (licenseclass.equals("standard")) {
            map.put("commercial", request.getParameter("commercial_chooser"));
            map.put("derivatives", request.getParameter("derivatives_chooser"));
        } else if (licenseclass.equals("recombo")) {
            map.put("sampling", request.getParameter("sampling_chooser"));
        }
        map.put("jurisdiction", jurisdiction);
        CCLookup ccLookup = new CCLookup();
        CreativeCommons.MdField uriField = CreativeCommons.getCCField("uri");
        CreativeCommons.MdField nameField = CreativeCommons.getCCField("name");
        ccLookup.issue(licenseclass, map, ConfigurationManager.getProperty("cc.license.locale"));
        Item item = subInfo.getSubmissionItem().getItem();
        if (licenseclass.equals("xmlui.Submission.submit.CCLicenseStep.no_license")) {
            String licenseUri = uriField.ccItemValue(item);
            if (licenseUri != null) {
                uriField.removeItemValue(item, licenseUri);
                if (ConfigurationManager.getBooleanProperty("cc.submit.setname")) {
                    String licenseName = nameField.keyedItemValue(item, licenseUri);
                    nameField.removeItemValue(item, licenseName);
                }
                if (ConfigurationManager.getBooleanProperty("cc.submit.addBitstream")) {
                    CreativeCommons.removeLicense(context, item);
                }
                item.update();
                context.commit();
                this.removeRequiredAttributes(session);
            }
            return 0;
        }
        if (licenseclass.equals("xmlui.Submission.submit.CCLicenseStep.select_change")) {
            this.removeRequiredAttributes(session);
            return 0;
        }
        if (ccLookup.isSuccess()) {
            uriField.addItemValue(item, ccLookup.getLicenseUrl());
            if (ConfigurationManager.getBooleanProperty("cc.submit.addbitstream")) {
                CreativeCommons.setLicenseRDF(context, item, ccLookup.getRdf());
            }
            if (ConfigurationManager.getBooleanProperty("cc.submit.setname")) {
                nameField.addItemValue(item, ccLookup.getLicenseName());
            }
        } else {
            request.getSession().setAttribute("ccError", (Object)ccLookup.getErrorMessage());
            String licenseUri = uriField.ccItemValue(item);
            if (licenseUri != null) {
                uriField.removeItemValue(item, licenseUri);
            }
            return 1;
        }
        item.update();
        context.commit();
        this.removeRequiredAttributes(session);
        session.removeAttribute("inProgress");
        return 0;
    }

    private void removeRequiredAttributes(HttpSession session) {
        session.removeAttribute("ccError");
        session.removeAttribute("isFieldRequired");
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }
}

