/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.utils.DSpace;

public class SolrBrowseDAO
implements BrowseDAO {
    private static Logger log = Logger.getLogger(SolrBrowseDAO.class);
    private Context context;
    private String table = null;
    private String focusField = null;
    private String focusValue = null;
    private String valueField = null;
    private String value = null;
    private String authority = null;
    private boolean valuePartial = false;
    private String containerTable = null;
    private String containerIDField = null;
    private int containerID = -1;
    private String orderField = null;
    private boolean ascending = true;
    private int limit = -1;
    private int offset = 0;
    private boolean equalsComparator = true;
    private boolean distinct = false;
    private String facetField;
    DSpace dspace = new DSpace();
    SearchService searcher = (SearchService)this.dspace.getServiceManager().getServiceByName(SearchService.class.getName(), SearchService.class);
    private DiscoverResult sResponse = null;
    private boolean itemsWithdrawn = false;
    private boolean itemsDiscoverable = true;
    private boolean showFrequencies;

    public SolrBrowseDAO(Context context) {
        this.context = context;
    }

    private DiscoverResult getSolrResponse() throws BrowseException {
        if (this.sResponse == null) {
            DiscoverQuery query = new DiscoverQuery();
            this.addLocationScopeFilter(query);
            this.addStatusFilter(query);
            if (this.distinct) {
                DiscoverFacetField dff = new DiscoverFacetField(this.facetField, "text", -1, DiscoveryConfigurationParameters.SORT.VALUE);
                query.addFacetField(dff);
                query.setFacetMinCount(1);
                query.setMaxResults(0);
            } else {
                query.setMaxResults(this.limit > 0 ? this.limit : 20);
                if (this.offset > 0) {
                    query.setStart(this.offset);
                }
                if (this.authority != null) {
                    query.addFilterQueries("{!field f=" + this.facetField + "_authority_filter}" + this.authority);
                } else if (this.value != null && !this.valuePartial) {
                    query.addFilterQueries("{!field f=" + this.facetField + "_value_filter}" + this.value);
                } else if (this.valuePartial) {
                    query.addFilterQueries("{!field f=" + this.facetField + "_partial}" + this.value);
                }
                query.addFilterQueries("search.resourcetype:2");
                if (this.orderField != null) {
                    query.setSortField("bi_" + this.orderField + "_sort", this.ascending ? DiscoverQuery.SORT_ORDER.asc : DiscoverQuery.SORT_ORDER.desc);
                }
            }
            try {
                this.sResponse = this.searcher.search(this.context, query, this.itemsWithdrawn || !this.itemsDiscoverable);
            }
            catch (SearchServiceException e) {
                throw new BrowseException(e);
            }
        }
        return this.sResponse;
    }

    private void addStatusFilter(DiscoverQuery query) {
        if (this.itemsWithdrawn) {
            query.addFilterQueries("withdrawn:true");
        } else if (!this.itemsDiscoverable) {
            query.addFilterQueries("discoverable:false");
        }
    }

    private void addLocationScopeFilter(DiscoverQuery query) {
        if (this.containerID > 0) {
            if (this.containerIDField.startsWith("collection")) {
                query.addFilterQueries("location.coll:" + this.containerID);
            } else if (this.containerIDField.startsWith("community")) {
                query.addFilterQueries("location.comm:" + this.containerID);
            }
        }
    }

    @Override
    public int doCountQuery() throws BrowseException {
        DiscoverResult resp = this.getSolrResponse();
        int count = 0;
        if (this.distinct) {
            List<DiscoverResult.FacetResult> facetResults = resp.getFacetResult(this.facetField);
            count = facetResults.size();
        } else {
            count = (int)resp.getTotalSearchResults();
            this.sResponse = null;
        }
        return count;
    }

    public List doValueQuery() throws BrowseException {
        DiscoverResult resp = this.getSolrResponse();
        List<DiscoverResult.FacetResult> facet = resp.getFacetResult(this.facetField);
        int count = this.doCountQuery();
        int start = this.offset > 0 ? this.offset : 0;
        int max = this.limit > 0 ? this.limit : 20;
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (this.ascending) {
            for (int i = start; i < start + max && i < count; ++i) {
                DiscoverResult.FacetResult c = facet.get(i);
                String freq = this.showFrequencies ? String.valueOf(c.getCount()) : "";
                result.add(new String[]{c.getDisplayedValue(), c.getAuthorityKey(), freq});
            }
        } else {
            for (int i = count - start - 1; i >= count - (start + max) && i >= 0; --i) {
                DiscoverResult.FacetResult c = facet.get(i);
                String freq = this.showFrequencies ? String.valueOf(c.getCount()) : "";
                result.add(new String[]{c.getDisplayedValue(), c.getAuthorityKey(), freq});
            }
        }
        return result;
    }

    public List doQuery() throws BrowseException {
        DiscoverResult resp = this.getSolrResponse();
        ArrayList<BrowseItem> bitems = new ArrayList<BrowseItem>();
        for (DSpaceObject solrDoc : resp.getDspaceObjects()) {
            Item item = (Item)solrDoc;
            BrowseItem bitem = new BrowseItem(this.context, item.getID(), item.isArchived(), item.isWithdrawn(), item.isDiscoverable());
            bitems.add(bitem);
        }
        return bitems;
    }

    @Override
    public String doMaxQuery(String column, String table, int itemID) throws BrowseException {
        DiscoverQuery query = new DiscoverQuery();
        query.setQuery("search.resourceid:" + itemID + " AND search.resourcetype:" + 2);
        query.setMaxResults(1);
        DiscoverResult resp = null;
        try {
            resp = this.searcher.search(this.context, query);
        }
        catch (SearchServiceException e) {
            throw new BrowseException(e);
        }
        if (resp.getTotalSearchResults() > 0L) {
            DiscoverResult.SearchDocument doc = resp.getSearchDocument(resp.getDspaceObjects().get(0)).get(0);
            return doc.getSearchFieldValues(column).get(0);
        }
        return null;
    }

    @Override
    public int doOffsetQuery(String column, String value, boolean isAscending) throws BrowseException {
        DiscoverQuery query = new DiscoverQuery();
        this.addLocationScopeFilter(query);
        this.addStatusFilter(query);
        query.setMaxResults(0);
        query.addFilterQueries("search.resourcetype:2");
        if (isAscending) {
            query.setQuery("bi_" + column + "_sort" + ": [* TO \"" + value + "\"]");
        } else {
            query.setQuery("bi_" + column + "_sort" + ": [\"" + value + "\" TO *]");
        }
        DiscoverResult resp = null;
        try {
            resp = this.searcher.search(this.context, query);
        }
        catch (SearchServiceException e) {
            throw new BrowseException(e);
        }
        return (int)resp.getTotalSearchResults();
    }

    @Override
    public int doDistinctOffsetQuery(String column, String value, boolean isAscending) throws BrowseException {
        int ascValue;
        DiscoverResult resp = this.getSolrResponse();
        List<DiscoverResult.FacetResult> facets = resp.getFacetResult(this.facetField);
        FacetValueComparator comparator = new FacetValueComparator();
        Collections.sort(facets, comparator);
        int x = Collections.binarySearch(facets, value, comparator);
        int n = ascValue = x >= 0 ? x : -(x + 1);
        if (isAscending) {
            return ascValue;
        }
        return this.doCountQuery() - ascValue;
    }

    @Override
    public boolean isEnableBrowseFrequencies() {
        return this.showFrequencies;
    }

    @Override
    public void setEnableBrowseFrequencies(boolean enableBrowseFrequencies) {
        this.showFrequencies = enableBrowseFrequencies;
    }

    @Override
    public int getContainerID() {
        return this.containerID;
    }

    @Override
    public String getContainerIDField() {
        return this.containerIDField;
    }

    @Override
    public String getContainerTable() {
        return this.containerTable;
    }

    @Override
    public String[] getCountValues() {
        return null;
    }

    @Override
    public String getJumpToField() {
        return this.focusField;
    }

    @Override
    public String getJumpToValue() {
        return this.focusValue;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getOrderField() {
        return this.orderField;
    }

    @Override
    public String[] getSelectValues() {
        return null;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getFilterValue() {
        return this.value;
    }

    @Override
    public String getFilterValueField() {
        return this.valueField;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    @Override
    public void setContainerID(int containerID) {
        this.containerID = containerID;
    }

    @Override
    public void setContainerIDField(String containerIDField) {
        this.containerIDField = containerIDField;
    }

    @Override
    public void setContainerTable(String containerTable) {
        this.containerTable = containerTable;
    }

    @Override
    public void setCountValues(String[] fields) {
    }

    @Override
    public void setDistinct(boolean bool) {
        this.distinct = bool;
    }

    @Override
    public void setEqualsComparator(boolean equalsComparator) {
        this.equalsComparator = equalsComparator;
    }

    @Override
    public void setJumpToField(String focusField) {
        this.focusField = focusField;
    }

    @Override
    public void setJumpToValue(String focusValue) {
        this.focusValue = focusValue;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    @Override
    public void setSelectValues(String[] selectValues) {
    }

    @Override
    public void setTable(String table) {
        if (table.equals(BrowseIndex.getWithdrawnBrowseIndex().getTableName())) {
            this.itemsWithdrawn = true;
        } else if (table.equals(BrowseIndex.getPrivateBrowseIndex().getTableName())) {
            this.itemsDiscoverable = false;
        }
        this.facetField = table;
    }

    @Override
    public void setFilterMappingTables(String tableDis, String tableMap) {
        if (tableDis != null) {
            this.facetField = tableDis;
        }
    }

    @Override
    public void setFilterValue(String value) {
        this.value = value;
    }

    @Override
    public void setFilterValuePartial(boolean part) {
        this.valuePartial = part;
    }

    @Override
    public void setFilterValueField(String valueField) {
        this.valueField = valueField;
    }

    @Override
    public boolean useEqualsComparator() {
        return this.equalsComparator;
    }

    @Override
    public String getAuthorityValue() {
        return this.authority;
    }

    @Override
    public void setAuthorityValue(String value) {
        this.authority = value;
    }

    private static class FacetValueComparator
    implements Comparator {
        private FacetValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = "";
            String s2 = "";
            if (o1 instanceof DiscoverResult.FacetResult && o2 instanceof String) {
                DiscoverResult.FacetResult c = (DiscoverResult.FacetResult)o1;
                s1 = c.getSortValue();
                s2 = (String)o2;
            } else if (o2 instanceof DiscoverResult.FacetResult && o1 instanceof String) {
                DiscoverResult.FacetResult c = (DiscoverResult.FacetResult)o2;
                s1 = (String)o1;
                s2 = c.getSortValue();
            }
            return s1.compareTo(s2);
        }
    }
}

