/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.browse.BrowseCreateDAO;
import org.dspace.browse.BrowseCreateDAOOracle;
import org.dspace.browse.BrowseCreateDAOPostgres;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.MappingResults;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.discovery.SolrServiceIndexPlugin;
import org.dspace.sort.OrderFormat;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.dspace.utils.DSpace;

public class SolrBrowseCreateDAO
implements BrowseCreateDAO,
SolrServiceIndexPlugin {
    private static final String INFO_NOSQL_TO_RUN = "No SQL to run: data are stored in the SOLR Search Core. PLEASE NOTE THAT YOU MUST UPDATE THE DISCOVERY INDEX AFTER ANY CHANGES TO THE BROWSE CONFIGURATION";
    private BrowseCreateDAO dbCreateDAO;
    private static final Logger log = Logger.getLogger(SolrBrowseCreateDAO.class);
    private BrowseIndex[] bis;

    public SolrBrowseCreateDAO() {
        try {
            this.bis = BrowseIndex.getBrowseIndices();
        }
        catch (BrowseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        for (BrowseIndex bi : this.bis) {
            bi.generateMdBits();
        }
    }

    public SolrBrowseCreateDAO(Context context) throws BrowseException {
        String db = ConfigurationManager.getProperty("db.name");
        if ("postgres".equals(db)) {
            this.dbCreateDAO = new BrowseCreateDAOPostgres(context);
        } else if ("oracle".equals(db)) {
            this.dbCreateDAO = new BrowseCreateDAOOracle(context);
        } else {
            throw new BrowseException("The configuration for db.name is either invalid, or contains an unrecognised database");
        }
        try {
            this.bis = BrowseIndex.getBrowseIndices();
        }
        catch (BrowseException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IllegalStateException(e);
        }
        for (BrowseIndex bi : this.bis) {
            bi.generateMdBits();
        }
    }

    @Override
    public void additionalIndex(Context context, DSpaceObject dso, SolrInputDocument doc) {
        if (!(dso instanceof Item)) {
            return;
        }
        Item item = (Item)dso;
        for (BrowseIndex bi : this.bis) {
            log.debug((Object)("Indexing for item " + item.getID() + ", for index: " + bi.getTableName()));
            if (!bi.isMetadataIndex()) continue;
            HashSet<String> distFValues = new HashSet<String>();
            HashSet<String> distFVal = new HashSet<String>();
            HashSet<String> distFAuths = new HashSet<String>();
            HashSet<String> distValuesForAC = new HashSet<String>();
            if (item.isArchived() || item.isWithdrawn()) {
                for (int mdIdx = 0; mdIdx < bi.getMetadataCount(); ++mdIdx) {
                    String[] md = bi.getMdBits(mdIdx);
                    DCValue[] values = item.getMetadata(md[0], md[1], md[2], "*");
                    if (values == null || values.length <= 0) continue;
                    int minConfidence = MetadataAuthorityManager.getManager().getMinConfidence(values[0].schema, values[0].element, values[0].qualifier);
                    boolean ignoreAuthority = (Boolean)new DSpace().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore." + bi.getName(), new DSpace().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore", (Object)new Boolean(false)), true);
                    for (int x = 0; x < values.length; ++x) {
                        if (StringUtils.isEmpty((String)values[x].value)) {
                            log.error((Object)("Null metadata value for item " + item.getID() + ", field: " + values[x].schema + "." + values[x].element + (values[x].qualifier == null ? "" : "." + values[x].qualifier)));
                            continue;
                        }
                        if (bi.isAuthorityIndex() && (values[x].authority == null || values[x].confidence < minConfidence)) {
                            log.debug((Object)("Skipping item=" + item.getID() + ", field=" + values[x].schema + "." + values[x].element + "." + values[x].qualifier + ", value=" + values[x].value + ", authority=" + values[x].authority + ", confidence=" + values[x].confidence + " (BAD AUTHORITY)"));
                            continue;
                        }
                        if (ignoreAuthority && !bi.isAuthorityIndex() || values[x].authority != null && values[x].confidence >= minConfidence) {
                            distFAuths.add(values[x].authority);
                            distValuesForAC.add(values[x].value);
                            String preferedLabel = null;
                            boolean ignorePrefered = (Boolean)new DSpace().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-prefered." + bi.getName(), new DSpace().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-prefered", (Object)new Boolean(false)), true);
                            if (!ignorePrefered) {
                                preferedLabel = ChoiceAuthorityManager.getManager().getLabel(values[x].schema, values[x].element, values[x].qualifier, values[x].authority, values[x].language);
                            }
                            List<String> variants = null;
                            boolean ignoreVariants = (Boolean)new DSpace().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-variants." + bi.getName(), new DSpace().getConfigurationService().getPropertyAsType("discovery.browse.authority.ignore-variants", (Object)new Boolean(false)), true);
                            if (!ignoreVariants) {
                                variants = ChoiceAuthorityManager.getManager().getVariants(values[x].schema, values[x].element, values[x].qualifier, values[x].authority, values[x].language);
                            }
                            if (StringUtils.isNotBlank((String)preferedLabel)) {
                                String nLabel = OrderFormat.makeSortString(preferedLabel, values[x].language, bi.getDataType());
                                distFValues.add(nLabel + "\n|||\n" + preferedLabel + "###" + values[x].authority);
                                distValuesForAC.add(preferedLabel);
                            }
                            if (variants == null) continue;
                            for (String var : variants) {
                                String nVal = OrderFormat.makeSortString(var, values[x].language, bi.getDataType());
                                distFValues.add(nVal + "\n|||\n" + var + "###" + values[x].authority);
                                distValuesForAC.add(var);
                            }
                            continue;
                        }
                        String nVal = OrderFormat.makeSortString(values[x].value, values[x].language, bi.getDataType());
                        distFValues.add(nVal + "\n|||\n" + values[x].value);
                        distFVal.add(values[x].value);
                        distValuesForAC.add(values[x].value);
                    }
                }
            }
            for (String facet : distFValues) {
                doc.addField(bi.getDistinctTableName() + "_filter", (Object)facet);
            }
            for (String facet : distFAuths) {
                doc.addField(bi.getDistinctTableName() + "_authority_filter", (Object)facet);
            }
            for (String facet : distValuesForAC) {
                doc.addField(bi.getDistinctTableName() + "_partial", (Object)facet);
            }
            for (String facet : distFVal) {
                doc.addField(bi.getDistinctTableName() + "_value_filter", (Object)facet);
            }
        }
        try {
            for (SortOption so : SortOption.getSortOptions()) {
                DCValue[] dcvalue = item.getMetadata(so.getMetadata());
                if (dcvalue == null || dcvalue.length <= 0) continue;
                String nValue = OrderFormat.makeSortString(dcvalue[0].value, dcvalue[0].language, so.getType());
                doc.addField("bi_sort_" + so.getNumber() + "_sort", (Object)nValue);
            }
        }
        catch (SortException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteByItemID(String table, int itemID) throws BrowseException {
    }

    @Override
    public void deleteCommunityMappings(int itemID) throws BrowseException {
    }

    @Override
    public void updateCommunityMappings(int itemID) throws BrowseException {
    }

    public void insertIndex(String table, int itemID, Map sortCols) throws BrowseException {
        this.dbCreateDAO.deleteCommunityMappings(itemID);
    }

    public boolean updateIndex(String table, int itemID, Map sortCols) throws BrowseException {
        return false;
    }

    @Override
    public int getDistinctID(String table, String value, String authority, String sortValue) throws BrowseException {
        return 0;
    }

    @Override
    public int insertDistinctRecord(String table, String value, String authority, String sortValue) throws BrowseException {
        return 0;
    }

    @Override
    public String dropIndexAndRelated(String table, boolean execute) throws BrowseException {
        return this.dbCreateDAO.dropIndexAndRelated(table, execute);
    }

    @Override
    public String dropSequence(String sequence, boolean execute) throws BrowseException {
        return this.dbCreateDAO.dropSequence(sequence, execute);
    }

    @Override
    public String dropView(String view, boolean execute) throws BrowseException {
        return this.dbCreateDAO.dropView(view, execute);
    }

    @Override
    public String createSequence(String sequence, boolean execute) throws BrowseException {
        return INFO_NOSQL_TO_RUN;
    }

    public String createPrimaryTable(String table, List sortCols, boolean execute) throws BrowseException {
        return INFO_NOSQL_TO_RUN;
    }

    @Override
    public String[] createDatabaseIndices(String table, List<Integer> sortCols, boolean value, boolean execute) throws BrowseException {
        return new String[]{INFO_NOSQL_TO_RUN};
    }

    @Override
    public String[] createMapIndices(String disTable, String mapTable, boolean execute) throws BrowseException {
        return new String[]{INFO_NOSQL_TO_RUN};
    }

    @Override
    public String createCollectionView(String table, String view, boolean execute) throws BrowseException {
        return INFO_NOSQL_TO_RUN;
    }

    @Override
    public String createCommunityView(String table, String view, boolean execute) throws BrowseException {
        return INFO_NOSQL_TO_RUN;
    }

    @Override
    public String createDistinctTable(String table, boolean execute) throws BrowseException {
        return INFO_NOSQL_TO_RUN;
    }

    @Override
    public String createDistinctMap(String table, String map, boolean execute) throws BrowseException {
        return INFO_NOSQL_TO_RUN;
    }

    @Override
    public MappingResults updateDistinctMappings(String table, int itemID, Set<Integer> distinctIDs) throws BrowseException {
        return new MappingResults(){

            @Override
            public List<Integer> getRetainedDistinctIds() {
                return new ArrayList<Integer>();
            }

            @Override
            public List<Integer> getRemovedDistinctIds() {
                return new ArrayList<Integer>();
            }

            @Override
            public List<Integer> getAddedDistinctIds() {
                return new ArrayList<Integer>();
            }
        };
    }

    @Override
    public boolean testTableExistence(String table) throws BrowseException {
        return this.dbCreateDAO.testTableExistence(table);
    }

    @Override
    public List<Integer> deleteMappingsByItemID(String mapTable, int itemID) throws BrowseException {
        return new ArrayList<Integer>();
    }

    @Override
    public void pruneExcess(String table, boolean withdrawn) throws BrowseException {
    }

    @Override
    public void pruneMapExcess(String map, boolean withdrawn, List<Integer> distinctIds) throws BrowseException {
    }

    @Override
    public void pruneDistinct(String table, String map, List<Integer> distinctIds) throws BrowseException {
    }
}

