/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.sql.SQLException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.storedcomponents.CollectionRole;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class Role {
    private String id;
    private String name;
    private String description;
    private boolean isInternal;
    private Scope scope;

    public Role(String id, String name, String description, boolean isInternal, Scope scope) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.isInternal = isInternal;
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public Scope getScope() {
        return this.scope;
    }

    public RoleMembers getMembers(Context context, XmlWorkflowItem wfi) throws SQLException {
        if (this.scope == Scope.REPOSITORY) {
            Group group = Group.findByName(context, this.name);
            if (group == null) {
                return new RoleMembers();
            }
            RoleMembers assignees = new RoleMembers();
            assignees.addGroup(group);
            return assignees;
        }
        if (this.scope == Scope.COLLECTION) {
            CollectionRole collectionRole = CollectionRole.find(context, wfi.getCollection().getID(), this.id);
            if (collectionRole != null) {
                RoleMembers assignees = new RoleMembers();
                assignees.addGroup(collectionRole.getGroup());
                return assignees;
            }
            return new RoleMembers();
        }
        WorkflowItemRole[] roles = WorkflowItemRole.find(context, wfi.getID(), this.id);
        RoleMembers assignees = new RoleMembers();
        for (WorkflowItemRole itemRole : roles) {
            Group group;
            EPerson user = itemRole.getEPerson();
            if (user != null) {
                assignees.addEPerson(user);
            }
            if ((group = itemRole.getGroup()) == null) continue;
            assignees.addGroup(group);
        }
        return assignees;
    }

    public static enum Scope {
        REPOSITORY,
        COLLECTION,
        ITEM;

    }
}

