/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.bulkedit.DSpaceCSVLine;
import org.dspace.app.bulkedit.MetadataImportInvalidHeadingException;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class DSpaceCSV
implements Serializable {
    private List<String> headings;
    private List<DSpaceCSVLine> lines;
    private int counter;
    protected static String valueSeparator;
    protected static String escapedValueSeparator;
    protected static String fieldSeparator;
    protected static String escapedFieldSeparator;
    protected static String authoritySeparator;
    protected static String escapedAuthoritySeparator;
    private boolean exportAll;
    private Map<String, String> ignore;

    public DSpaceCSV(boolean exportAll) {
        this.init();
        this.exportAll = exportAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSpaceCSV(File f, Context c) throws Exception {
        this.init();
        BufferedReader input = null;
        try {
            String lineRead;
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            String head = input.readLine();
            String[] headingElements = head.split(escapedFieldSeparator);
            int columnCounter = 0;
            for (String element : headingElements) {
                MetadataSchema foundSchema;
                ++columnCounter;
                if (element.startsWith("\"") && element.endsWith("\"")) {
                    element = element.substring(1, element.length() - 1);
                }
                if ("collection".equals(element)) {
                    this.headings.add(element);
                    continue;
                }
                if ("action".equals(element)) {
                    this.headings.add(element);
                    continue;
                }
                if ("id".equals(element)) continue;
                String[] clean = element.split("\\[");
                String[] parts = clean[0].split("\\.");
                if (parts.length < 2) {
                    throw new MetadataImportInvalidHeadingException(element, 99, columnCounter);
                }
                String metadataSchema = parts[0];
                String metadataElement = parts[1];
                String metadataQualifier = null;
                if (parts.length > 2) {
                    metadataQualifier = parts[2];
                }
                if ((foundSchema = MetadataSchema.find(c, metadataSchema)) == null) {
                    throw new MetadataImportInvalidHeadingException(clean[0], 0, columnCounter);
                }
                int schemaID = foundSchema.getSchemaID();
                MetadataField foundField = MetadataField.findByElement(c, schemaID, metadataElement, metadataQualifier);
                if (foundField == null) {
                    throw new MetadataImportInvalidHeadingException(clean[0], 1, columnCounter);
                }
                this.headings.add(element);
            }
            StringBuilder lineBuilder = new StringBuilder();
            while ((lineRead = input.readLine()) != null) {
                int pos;
                int quoteCount;
                if (lineBuilder.length() > 0) {
                    lineBuilder.append("\n").append(lineRead);
                    quoteCount = 0;
                    for (pos = 0; pos < lineBuilder.length(); ++pos) {
                        if (lineBuilder.charAt(pos) != '\"') continue;
                        ++quoteCount;
                    }
                    if (quoteCount % 2 != 0) continue;
                    this.addItem(lineBuilder.toString());
                    lineBuilder = new StringBuilder();
                    continue;
                }
                if (lineRead.indexOf(34) > -1) {
                    quoteCount = 0;
                    for (pos = 0; pos < lineRead.length(); ++pos) {
                        if (lineRead.charAt(pos) != '\"') continue;
                        ++quoteCount;
                    }
                    if (quoteCount % 2 == 0) {
                        this.addItem(lineRead);
                        continue;
                    }
                    lineBuilder.append(lineRead);
                    continue;
                }
                this.addItem(lineRead);
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    private void init() {
        String[] toIgnoreArray;
        this.setValueSeparator();
        this.setFieldSeparator();
        this.setAuthoritySeparator();
        this.headings = new ArrayList<String>();
        this.lines = new ArrayList<DSpaceCSVLine>();
        this.counter = 0;
        this.ignore = new HashMap<String, String>();
        String toIgnore = ConfigurationManager.getProperty("bulkedit", "ignore-on-export");
        if (toIgnore == null || "".equals(toIgnore.trim())) {
            toIgnore = "dc.date.accessioned, dc.date.available, dc.date.updated, dc.description.provenance";
        }
        for (String toIgnoreString : toIgnoreArray = toIgnore.split(",")) {
            if ("".equals(toIgnoreString.trim())) continue;
            this.ignore.put(toIgnoreString.trim(), toIgnoreString.trim());
        }
    }

    public boolean hasActions() {
        for (String header : this.headings) {
            if (!header.equals("action")) continue;
            return true;
        }
        return false;
    }

    private void setValueSeparator() {
        valueSeparator = ConfigurationManager.getProperty("bulkedit", "valueseparator");
        valueSeparator = valueSeparator != null && !"".equals(valueSeparator.trim()) ? valueSeparator.trim() : "||";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(valueSeparator);
        escapedValueSeparator = match.replaceAll("\\\\$1");
    }

    private void setFieldSeparator() {
        fieldSeparator = ConfigurationManager.getProperty("bulkedit", "fieldseparator");
        fieldSeparator = fieldSeparator != null && !"".equals(fieldSeparator.trim()) ? ("tab".equals(fieldSeparator = fieldSeparator.trim()) ? "\t" : ("semicolon".equals(fieldSeparator) ? ";" : ("hash".equals(fieldSeparator) ? "#" : fieldSeparator.trim()))) : ",";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(fieldSeparator);
        escapedFieldSeparator = match.replaceAll("\\\\$1");
    }

    private void setAuthoritySeparator() {
        authoritySeparator = ConfigurationManager.getProperty("bulkedit", "authorityseparator");
        authoritySeparator = authoritySeparator != null && !"".equals(authoritySeparator.trim()) ? authoritySeparator.trim() : "::";
        Pattern spchars = Pattern.compile("([\\\\*+\\[\\](){}\\$.?\\^|])");
        Matcher match = spchars.matcher(authoritySeparator);
        escapedAuthoritySeparator = match.replaceAll("\\\\$1");
    }

    public final void addItem(Item i) throws Exception {
        DCValue[] md;
        Collection[] collections;
        if (i.getOwningCollection() == null) {
            return;
        }
        DSpaceCSVLine line = new DSpaceCSVLine(i.getID());
        String owningCollectionHandle = i.getOwningCollection().getHandle();
        line.add("collection", owningCollectionHandle);
        for (Collection c : collections = i.getCollections()) {
            if (c.getHandle().equals(owningCollectionHandle)) continue;
            line.add("collection", c.getHandle());
        }
        for (DCValue value : md = i.getMetadata("*", "*", "*", "*")) {
            String key = value.schema + "." + value.element;
            if (value.qualifier != null) {
                key = key + "." + value.qualifier;
            }
            if (value.language != null) {
                key = key + "[" + value.language + "]";
            }
            if (!this.exportAll && !this.okToExport(value)) continue;
            String mdValue = value.value;
            if (value.authority != null && !"".equals(value.authority)) {
                mdValue = mdValue + authoritySeparator + value.authority + authoritySeparator + value.confidence;
            }
            line.add(key, mdValue);
            if (this.headings.contains(key)) continue;
            this.headings.add(key);
        }
        this.lines.add(line);
        ++this.counter;
    }

    public final void addItem(String line) throws Exception {
        DSpaceCSVLine csvLine;
        boolean last = false;
        if (line.endsWith(fieldSeparator)) {
            last = true;
            line = line + " ";
        }
        String[] parts = line.split(escapedFieldSeparator);
        ArrayList<String> bits = new ArrayList<String>();
        bits.addAll(Arrays.asList(parts));
        boolean alldone = false;
        while (!alldone) {
            boolean found = false;
            int i = 0;
            for (String part : bits) {
                int bitcounter = part.length() - part.replaceAll("\"", "").length();
                if (part.startsWith("\"") && (!part.endsWith("\"") || (bitcounter & 1) == 1)) {
                    found = true;
                    String add = (String)bits.get(i) + fieldSeparator + (String)bits.get(i + 1);
                    bits.remove(i);
                    bits.add(i, add);
                    bits.remove(i + 1);
                    break;
                }
                ++i;
            }
            alldone = !found;
        }
        int i = 0;
        for (String part : bits) {
            if (part.startsWith("\"") && part.endsWith("\"")) {
                part = part.substring(1, part.length() - 1);
                bits.set(i, part);
            }
            ++i;
        }
        i = 0;
        for (String part : bits) {
            if (part.contains("\"\"")) {
                part = part.replaceAll("\"\"", "\"");
                bits.set(i, part);
            }
            ++i;
        }
        String id = parts[0].replaceAll("\"", "");
        if ("+".equals(id)) {
            csvLine = new DSpaceCSVLine();
        } else {
            try {
                csvLine = new DSpaceCSVLine(Integer.parseInt(id));
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid item identifier: " + id);
                System.err.println("Please check your CSV file for information. Item id must be numeric, or a '+' to add a new item");
                throw nfe;
            }
        }
        i = 0;
        for (String part : bits) {
            if (i > 0) {
                String[] elements;
                if (last && i == this.headings.size()) {
                    part = "";
                }
                if (this.headings.size() < i) {
                    throw new MetadataImportInvalidHeadingException("", 98, i + 1);
                }
                csvLine.add(this.headings.get(i - 1), null);
                for (String element : elements = part.split(escapedValueSeparator)) {
                    if (element == null || "".equals(element)) continue;
                    csvLine.add(this.headings.get(i - 1), element);
                }
            }
            ++i;
        }
        this.lines.add(csvLine);
        ++this.counter;
    }

    public final List<DSpaceCSVLine> getCSVLines() {
        return this.lines;
    }

    public final String[] getCSVLinesAsStringArray() {
        String[] csvLines = new String[this.counter + 1];
        csvLines[0] = "id" + fieldSeparator + "collection";
        Collections.sort(this.headings);
        for (String value : this.headings) {
            csvLines[0] = csvLines[0] + fieldSeparator + value;
        }
        Iterator<DSpaceCSVLine> i = this.lines.iterator();
        int c = 1;
        while (i.hasNext()) {
            csvLines[c++] = i.next().toCSV(this.headings);
        }
        return csvLines;
    }

    public final void save(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
        for (String csvLine : this.getCSVLinesAsStringArray()) {
            out.write(csvLine + "\n");
        }
        out.flush();
        out.close();
    }

    private final boolean okToExport(DCValue md) {
        String key = md.schema + "." + md.element;
        if (md.qualifier != null) {
            key = key + "." + md.qualifier;
        }
        return this.ignore.get(key) == null;
    }

    public List<String> getHeadings() {
        return this.headings;
    }

    public final String toString() {
        String[] lines;
        StringBuffer csvLines = new StringBuffer();
        for (String line : lines = this.getCSVLinesAsStringArray()) {
            csvLines.append(line).append("\n");
        }
        return csvLines.toString();
    }
}

