/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.dspace.app.util.DSpaceWebappMXBean;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDSpaceWebapp
implements DSpaceWebappMXBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractDSpaceWebapp.class);
    protected String kind;
    protected Date started;
    protected String url;
    private TableRow row;

    protected AbstractDSpaceWebapp() {
    }

    public AbstractDSpaceWebapp(String kind) {
        this.kind = kind;
        this.started = new Date();
        this.url = ConfigurationManager.getProperty("dspace.url");
        if (null == this.url) {
            throw new IllegalStateException("dspace.url is undefined");
        }
    }

    public void register() {
        Timestamp now = new Timestamp(this.started.getTime());
        try {
            Context context = new Context();
            this.row = DatabaseManager.create(context, "Webapp");
            this.row.setColumn("AppName", this.kind);
            this.row.setColumn("URL", this.url);
            this.row.setColumn("Started", now);
            this.row.setColumn("isUI", this.isUI() ? 1 : 0);
            DatabaseManager.update(context, this.row);
            context.complete();
        }
        catch (SQLException e) {
            log.error("Failed to record startup in Webapp table.", (Throwable)e);
        }
    }

    public void deregister() {
        try {
            Context context = new Context();
            DatabaseManager.delete(context, this.row);
            context.complete();
        }
        catch (SQLException e) {
            log.error("Failed to record shutdown in Webapp table.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AbstractDSpaceWebapp> getApps() {
        ArrayList<AbstractDSpaceWebapp> apps = new ArrayList<AbstractDSpaceWebapp>();
        Context context = null;
        HeadMethod request = null;
        try {
            context = new Context();
            TableRowIterator tri = DatabaseManager.queryTable(context, "Webapp", "SELECT * FROM Webapp", new Object[0]);
            for (TableRow row : tri.toList()) {
                DSpaceWebapp app = new DSpaceWebapp();
                app.kind = row.getStringColumn("AppName");
                app.url = row.getStringColumn("URL");
                app.started = row.getDateColumn("Started");
                app.uiQ = row.getBooleanColumn("isUI");
                HttpClient client = new HttpClient();
                request = new HeadMethod(app.url);
                int status = client.executeMethod((HttpMethod)request);
                request.getResponseBody();
                if (status != 200) {
                    DatabaseManager.delete(context, row);
                    context.commit();
                    continue;
                }
                apps.add(app);
            }
        }
        catch (SQLException e) {
            log.error("Unable to list running applications", (Throwable)e);
        }
        catch (HttpException e) {
            log.error("Failure checking for a running webapp", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Failure checking for a running webapp", (Throwable)e);
        }
        finally {
            if (null != request) {
                request.releaseConnection();
            }
            if (null != context) {
                context.abort();
            }
        }
        return apps;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getStarted() {
        return this.started.toString();
    }

    private static class DSpaceWebapp
    extends AbstractDSpaceWebapp {
        private boolean uiQ;

        private DSpaceWebapp() {
        }

        @Override
        public boolean isUI() {
            return this.uiQ;
        }
    }
}

